/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.maxhenkel.advancedtools.items.tools.AbstractTool;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;

public class AdvancedHoe
extends AbstractTool {
    private static final Set<Material> EFFECTIVE_ON = Sets.newHashSet((Object[])new Material[]{Material.field_151584_j, Material.field_151583_m, Material.field_151577_b});

    public AdvancedHoe() {
        this.setRegistryName(new ResourceLocation("advancedtools", "hoe"));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (this.isBroken(stack)) {
            return ActionResultType.PASS;
        }
        ActionResultType result = Items.field_151012_L.func_195939_a(context);
        if (result.func_226246_a_()) {
            StackUtils.incrementToolStat(stack, StackUtils.Stat.STAT_HOED, 1);
        }
        return result;
    }

    @Override
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)ToolType.HOE);
    }

    @Override
    public float getAttackDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getAttackModifier() + 1.0f;
        }
        return 0.0f;
    }

    @Override
    public float getAttackSpeed(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return -3.0f;
        }
        return 0.0f;
    }

    @Override
    public float getEfficiency(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getEfficiency();
        }
        return 1.0f;
    }

    @Override
    public Set<Material> getEffectiveMaterials(ItemStack stack) {
        return EFFECTIVE_ON;
    }

    @Override
    public int getHarvestLevel(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getHarvestLevel();
        }
        return 0;
    }

    @Override
    public String getPrimaryToolType() {
        return "hoe";
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return mat.getMaxDamage();
        }
        return 0;
    }

    @Override
    public int getRepairCost(ItemStack stack, AdvancedToolMaterial material) {
        return material == AdvancedToolMaterial.NETHERITE ? 1 : 2;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, (Consumer<LivingEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, func_220039_b(net.minecraft.entity.LivingEntity ), (Lnet/minecraft/entity/LivingEntity;)V)());
        return true;
    }

    private static /* synthetic */ void lambda$hurtEnemy$0(LivingEntity livingEntity) {
    }
}

