/*
 * Decompiled with CFR 0.152.
 */
package com.GenZVirus.AgeOfTitans;

import com.GenZVirus.AgeOfTitans.Client.Keybind.ModKeybind;
import com.GenZVirus.AgeOfTitans.Common.Config.AOTConfig;
import com.GenZVirus.AgeOfTitans.Common.Init.BiomeInit;
import com.GenZVirus.AgeOfTitans.Common.Init.BlockInit;
import com.GenZVirus.AgeOfTitans.Common.Init.DimensionInit;
import com.GenZVirus.AgeOfTitans.Common.Init.EffectInit;
import com.GenZVirus.AgeOfTitans.Common.Init.ItemInit;
import com.GenZVirus.AgeOfTitans.Common.Init.ModContainerTypes;
import com.GenZVirus.AgeOfTitans.Common.Init.ModEntityTypes;
import com.GenZVirus.AgeOfTitans.Common.Init.ModTileEntityTypes;
import com.GenZVirus.AgeOfTitans.Common.Init.ParticleInit;
import com.GenZVirus.AgeOfTitans.Common.Init.SoundInit;
import com.GenZVirus.AgeOfTitans.Common.Network.PacketHandlerCommon;
import com.GenZVirus.AgeOfTitans.SpellSystem.ActiveAbility;
import com.GenZVirus.AgeOfTitans.SpellSystem.PassiveAbility;
import java.io.File;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ageoftitans")
@Mod.EventBusSubscriber(modid="ageoftitans", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AgeOfTitans {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "ageoftitans";
    public static AgeOfTitans instance;
    public static final ResourceLocation EDEN_DIMENSION_TYPE;

    public AgeOfTitans() {
        File folder = new File("config/AgeOfTitans/");
        if (!folder.exists()) {
            try {
                folder.mkdir();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to create config directory");
            }
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AOTConfig.COMMON_SPEC, "AgeOfTitans/AgeOfTitansConfigs.toml");
        LOGGER.info("Configs loaded successfully");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        ParticleInit.PARTICLES.register(modEventBus);
        LOGGER.info("Particles loaded successfully");
        SoundInit.SOUNDS.register(modEventBus);
        LOGGER.info("Sounds loaded successfully");
        ItemInit.ITEMS.register(modEventBus);
        LOGGER.info("Items loaded successfully");
        BlockInit.BLOCKS.register(modEventBus);
        LOGGER.info("Blocks loaded successfully");
        EffectInit.MOD_EFFECTS.register(modEventBus);
        LOGGER.info("Effects loaded successfully");
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        LOGGER.info("Tile Entity Types loaded successfully");
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        LOGGER.info("Container Types loaded successfully");
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        LOGGER.info("Entity Types loaded successfully");
        BiomeInit.BIOMES.register(modEventBus);
        LOGGER.info("Biomes loaded successfully");
        DimensionInit.MOD_DIMENSIONS.register(modEventBus);
        LOGGER.info("Dimensions loaded successfully");
        ActiveAbility.registerSpells();
        LOGGER.info("Spells loaded successfully");
        PassiveAbility.registerPassives();
        LOGGER.info("Passives loaded successfully");
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockInit.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a((ItemGroup)AgeOfTitansItemGroup.instance);
            BlockItem blockItem = new BlockItem(block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        BiomeInit.registerBiomes();
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandlerCommon.init();
        LOGGER.info("Packets loaded successfully");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModKeybind.register();
        LOGGER.info("Keybinds loaded successfully");
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void loadCompleteEvent(FMLLoadCompleteEvent event) {
    }

    static {
        EDEN_DIMENSION_TYPE = new ResourceLocation(MOD_ID, "eden");
    }

    public static class AgeOfTitansItemGroup
    extends ItemGroup {
        public static final AgeOfTitansItemGroup instance = new AgeOfTitansItemGroup(ItemGroup.field_78032_a.length, "ageoftitans");

        private AgeOfTitansItemGroup(int index, String label) {
            super(index, label);
            LOGGER.info("Item Group created successfully");
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.FRUIT_OF_THE_GODS.get());
        }
    }
}

