/*
 * Decompiled with CFR 0.152.
 */
package com.GenZVirus.AgeOfTitans.SpellSystem;

import com.GenZVirus.AgeOfTitans.Common.Config.AOTConfig;
import com.GenZVirus.AgeOfTitans.Common.Entities.ChainEntity;
import com.GenZVirus.AgeOfTitans.Common.Entities.GravityBombEntity;
import com.GenZVirus.AgeOfTitans.Common.Entities.SwordSlashEntity;
import com.GenZVirus.AgeOfTitans.Common.Init.EffectInit;
import com.GenZVirus.AgeOfTitans.Common.Init.ModEntityTypes;
import com.GenZVirus.AgeOfTitans.Common.Init.SoundInit;
import com.GenZVirus.AgeOfTitans.Common.Network.PacketHandlerCommon;
import com.GenZVirus.AgeOfTitans.Common.Network.SyncPlayerMotionPacket;
import com.GenZVirus.AgeOfTitans.SpellSystem.Ability;
import com.GenZVirus.AgeOfTitans.SpellSystem.PlayerStats;
import com.GenZVirus.AgeOfTitans.SpellSystem.Requirement;
import com.GenZVirus.AgeOfTitans.SpellSystem.XMLFileJava;
import com.GenZVirus.AgeOfTitans.Util.Helpers.ConeShape;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;

public class ActiveAbility
implements Ability {
    private int id;
    private ResourceLocation icon;
    private ResourceLocation iconOff;
    private ResourceLocation iconHUD;
    public int level = 0;
    public double ratio = 0.0;
    public int cooldown = 0;
    public double base_amount = 0.0;
    public int cost = 0;
    public List<Requirement> requirements = Lists.newArrayList();
    private static final List<Ability> ACTIVE_LIST = Lists.newArrayList();
    private static final ActiveAbility NO_SPELL = new ActiveAbility(0, new ResourceLocation("ageoftitans", "textures/gui/noicon.png"), new ResourceLocation("ageoftitans", "textures/gui/noicon.png"), new ResourceLocation("ageoftitans", "textures/gui/noiconhud.png"), 0, 0);
    private static final ActiveAbility SWORD_SLASH = new ActiveAbility(1, new ResourceLocation("ageoftitans", "textures/gui/swordslashicon.png"), new ResourceLocation("ageoftitans", "textures/gui/swordslashiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/swordslashiconhud.png"), 0, (Integer)AOTConfig.COMMON.sword_slash_cost.get()){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level0", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 0;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            double offset = 1.0;
            double pitch = playerIn.func_189653_aC().field_189982_i;
            double yaw = playerIn.func_189653_aC().field_189983_j;
            double pitchRadian = pitch * (Math.PI / 180);
            double yawRadian = yaw * (Math.PI / 180);
            double newPosX = offset * -Math.sin(yawRadian) * Math.cos(pitchRadian);
            double newPosY = offset * -Math.sin(pitchRadian);
            double newPosZ = offset * Math.cos(yawRadian) * Math.cos(pitchRadian);
            SwordSlashEntity swordslashentity = new SwordSlashEntity(playerIn.field_70170_p, (LivingEntity)playerIn, newPosX, newPosY, newPosZ);
            double d0 = MathHelper.func_76133_a((double)(newPosX * newPosX + newPosY * newPosY + newPosZ * newPosZ));
            swordslashentity.field_70232_b = newPosX / d0 * 0.1;
            swordslashentity.field_70233_c = newPosY / d0 * 0.1;
            swordslashentity.field_70230_d = newPosZ / d0 * 0.1;
            swordslashentity.field_70125_A = (float)pitch;
            swordslashentity.field_70177_z = (float)yaw;
            swordslashentity.func_226288_n_(playerIn.func_226277_ct_(), 1.0 + playerIn.func_226278_cu_(), playerIn.func_226281_cx_());
            swordslashentity.setDamage((Double)AOTConfig.COMMON.sword_slash_base_damage.get() + (Double)AOTConfig.COMMON.sword_slash_damage_ratio.get() * (double)Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Spell_Level1")));
            playerIn.field_70170_p.func_217376_c((Entity)swordslashentity);
            playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)SoundInit.SWORD_SLASH_LAUNCH.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.sword_slash.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.sword_slash.description", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.hold_shift", (Object[])new Object[0]));
            return list;
        }

        @Override
        public List<String> getDetails() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.sword_slash.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.damage", (Object[])new Object[0]) + " (" + Double.toString(this.base_amount + this.ratio * (double)this.level) + "): \u00a73" + Double.toString(this.base_amount) + "\u00a7f + \u00a7e" + Double.toString(this.ratio) + "\u00a7f * \u00a74" + Integer.toString(this.level));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cooldown", (Object[])new Object[0]) + ": " + Integer.toString(this.cooldown) + " " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cost", (Object[])new Object[0]) + ": " + this.cost + " " + I18n.func_135052_a((String)"gui.misc.rage_points", (Object[])new Object[0]));
            list.add("");
            list.add("\u00a73" + I18n.func_135052_a((String)"gui.misc.base", (Object[])new Object[0]) + " \u00a7e" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]) + " \u00a74" + I18n.func_135052_a((String)"gui.misc.level", (Object[])new Object[0]));
            return list;
        }
    };
    private static final ActiveAbility SHIELD_BASH = new ActiveAbility(2, new ResourceLocation("ageoftitans", "textures/gui/shieldbashicon.png"), new ResourceLocation("ageoftitans", "textures/gui/shieldbashiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/shieldbashiconhud.png"), 0, (Integer)AOTConfig.COMMON.shield_bash_cost.get()){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level20", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 20;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            double offset = 5.0;
            double pitch = playerIn.func_189653_aC().field_189982_i;
            double yaw = playerIn.func_189653_aC().field_189983_j;
            AxisAlignedBB CUBE_BOX = VoxelShapes.func_197868_b().func_197752_a();
            Vec3d pos_offset = new Vec3d((Vec3i)playerIn.func_180425_c()).func_72441_c(0.0, 1.6, 0.0);
            AxisAlignedBB aabb = CUBE_BOX.func_191194_a(pos_offset).func_186662_g(offset);
            List list = worldIn.func_72839_b((Entity)playerIn, aabb);
            double pitchRadian = pitch * (Math.PI / 180);
            double yawRadian = yaw * (Math.PI / 180);
            double newPosX = offset * -Math.sin(yawRadian) * Math.cos(pitchRadian);
            double newPosY = offset * -Math.sin(pitchRadian);
            double newPosZ = offset * Math.cos(yawRadian) * Math.cos(pitchRadian);
            ConeShape coneShape = new ConeShape(pos_offset.func_72441_c(newPosX, newPosY, newPosZ), pos_offset, 10.0, 0.1);
            for (double k = 0.0; k <= 2.0 * (offset - 1.0); k += 1.0) {
                for (double j = 0.0; j <= 2.0 * (offset - 1.0); j += 1.0) {
                    for (double i = 0.0; i <= 2.0 * (offset - 1.0); i += 1.0) {
                        BlockPos pos = new BlockPos(new Vec3d(playerIn.func_226277_ct_() - (offset - 1.0) + i, playerIn.func_226278_cu_() - (offset - 1.0) + k, playerIn.func_226281_cx_() - (offset - 1.0) + j));
                        if (!coneShape.containsPoint(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) || !(worldIn.func_180495_p(pos).func_177230_c().func_149638_a() <= 0.3f)) continue;
                        worldIn.func_175655_b(pos, false);
                    }
                }
            }
            for (Entity entity : list) {
                if (!coneShape.containsPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())) continue;
                Vec3d vec = new Vec3d((entity.func_226277_ct_() - playerIn.func_226277_ct_()) * offset, (entity.func_226278_cu_() - playerIn.func_226278_cu_()) * offset, (entity.func_226281_cx_() - playerIn.func_226281_cx_()) * offset);
                entity.func_213293_j(vec.field_72450_a / 2.0, vec.field_72448_b / 2.0, vec.field_72449_c / 2.0);
                entity.func_70097_a(DamageSource.field_76376_m, (float)((Double)AOTConfig.COMMON.shield_bash_base_damage.get() + (Double)AOTConfig.COMMON.shield_bash_damage_ratio.get() * (double)Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Spell_Level2"))));
                if (!(entity instanceof PlayerEntity)) continue;
                PacketHandlerCommon.INSTANCE.sendTo((Object)new SyncPlayerMotionPacket(entity.func_110124_au(), vec.func_82615_a() / 2.0, vec.func_82617_b() / 2.0, vec.func_82616_c() / 2.0), ((ServerPlayerEntity)entity).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
            playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)SoundInit.SHIELD_BASH_LAUNCH.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.shield_bash.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.shield_bash.description", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.hold_shift", (Object[])new Object[0]));
            return list;
        }

        @Override
        public List<String> getDetails() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.shield_bash.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.damage", (Object[])new Object[0]) + " (" + Double.toString(this.base_amount + this.ratio * (double)this.level) + "): \u00a73" + Double.toString(this.base_amount) + "\u00a7f + \u00a7e" + Double.toString(this.ratio) + "\u00a7f * \u00a74" + Integer.toString(this.level));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cooldown", (Object[])new Object[0]) + ": " + Integer.toString(this.cooldown) + " " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cost", (Object[])new Object[0]) + ": " + this.cost + " " + I18n.func_135052_a((String)"gui.misc.rage_points", (Object[])new Object[0]));
            list.add("");
            list.add("\u00a73" + I18n.func_135052_a((String)"gui.misc.base", (Object[])new Object[0]) + " \u00a7e" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]) + " \u00a74" + I18n.func_135052_a((String)"gui.misc.level", (Object[])new Object[0]));
            return list;
        }
    };
    private static final ActiveAbility BERSERKER = new ActiveAbility(3, new ResourceLocation("ageoftitans", "textures/gui/berserkericon.png"), new ResourceLocation("ageoftitans", "textures/gui/berserkericonoff.png"), new ResourceLocation("ageoftitans", "textures/gui/berserkericonhud.png"), 0, (Integer)AOTConfig.COMMON.berserker_cost.get()){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level40", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 40;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            playerIn.func_195064_c(new EffectInstance((Effect)EffectInit.BERSERKER.get(), (int)(400.0 + 20.0 * (Double)AOTConfig.COMMON.berserker_duration_ratio.get() * (double)Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Spell_Level3")))));
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.berseker.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.berseker.description", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.hold_shift", (Object[])new Object[0]));
            return list;
        }

        @Override
        public List<String> getDetails() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.berseker.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.bonus_damage", (Object[])new Object[0]) + ": \u00a73" + Double.toString(this.base_amount));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.duration", (Object[])new Object[0]) + " (" + Double.toString(20.0 + this.ratio * (double)this.level) + "): \u00a7320\u00a7f + \u00a7e" + Double.toString(this.ratio) + "\u00a7f * \u00a74" + Integer.toString(this.level) + "\u00a7f " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cooldown", (Object[])new Object[0]) + ": " + Integer.toString(this.cooldown) + " " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cost", (Object[])new Object[0]) + ": " + this.cost + " " + I18n.func_135052_a((String)"gui.misc.rage_points", (Object[])new Object[0]));
            list.add("");
            list.add("\u00a73" + I18n.func_135052_a((String)"gui.misc.base", (Object[])new Object[0]) + " \u00a7e" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]) + " \u00a74" + I18n.func_135052_a((String)"gui.misc.level", (Object[])new Object[0]));
            return list;
        }
    };
    private static final ActiveAbility CHAIN = new ActiveAbility(4, new ResourceLocation("ageoftitans", "textures/gui/chainicon.png"), new ResourceLocation("ageoftitans", "textures/gui/chainiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/chainiconhud.png"), 0, (Integer)AOTConfig.COMMON.chain_cost.get()){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level20", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 20;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            double offset = 1.0;
            double pitch = playerIn.func_189653_aC().field_189982_i;
            double yaw = playerIn.func_189653_aC().field_189983_j;
            double pitchRadian = pitch * (Math.PI / 180);
            double yawRadian = yaw * (Math.PI / 180);
            double newPosX = offset * -Math.sin(yawRadian) * Math.cos(pitchRadian);
            double newPosY = offset * -Math.sin(pitchRadian);
            double newPosZ = offset * Math.cos(yawRadian) * Math.cos(pitchRadian);
            ChainEntity chainEntity = new ChainEntity(playerIn.field_70170_p, (LivingEntity)playerIn, newPosX, newPosY, newPosZ);
            chainEntity.func_184538_a((Entity)playerIn, (float)pitch, (float)yaw, 0.0f, 1.5f, 0.0f);
            chainEntity.func_226288_n_(playerIn.func_226277_ct_(), 1.0 + playerIn.func_226278_cu_(), playerIn.func_226281_cx_());
            chainEntity.setDamage((Double)AOTConfig.COMMON.chain_base_damage.get() + (Double)AOTConfig.COMMON.chain_damage_ratio.get() * (double)Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Spell_Level4")));
            playerIn.field_70170_p.func_217376_c((Entity)chainEntity);
            playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)SoundInit.CHAIN.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.chain.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.chain.description", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.hold_shift", (Object[])new Object[0]));
            return list;
        }

        @Override
        public List<String> getDetails() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.chain.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.damage", (Object[])new Object[0]) + " (" + Double.toString(this.base_amount + this.ratio * (double)this.level) + "): \u00a73" + Double.toString(this.base_amount) + "\u00a7f + \u00a7e" + Double.toString(this.ratio) + "\u00a7f * \u00a74" + Integer.toString(this.level));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cooldown", (Object[])new Object[0]) + ": " + Integer.toString(this.cooldown) + " " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cost", (Object[])new Object[0]) + ": " + this.cost + " " + I18n.func_135052_a((String)"gui.misc.rage_points", (Object[])new Object[0]));
            list.add("");
            list.add("\u00a73" + I18n.func_135052_a((String)"gui.misc.base", (Object[])new Object[0]) + " \u00a7e" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]) + " \u00a74" + I18n.func_135052_a((String)"gui.misc.level", (Object[])new Object[0]));
            return list;
        }
    };
    private static final ActiveAbility GRAVITY_BOMB = new ActiveAbility(5, new ResourceLocation("ageoftitans", "textures/gui/gravitybombicon.png"), new ResourceLocation("ageoftitans", "textures/gui/gravitybombiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/gravitybombiconhud.png"), 0, (Integer)AOTConfig.COMMON.gravity_bomb_cost.get()){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level20", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 20;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            double pitch = playerIn.func_189653_aC().field_189982_i;
            double yaw = playerIn.func_189653_aC().field_189983_j;
            GravityBombEntity gravityBombEntity = new GravityBombEntity((EntityType<? extends ThrowableEntity>)((EntityType)ModEntityTypes.GRAVITY_BOMB.get()), playerIn.field_70170_p);
            gravityBombEntity.func_184538_a((Entity)playerIn, (float)pitch, (float)yaw, 0.0f, 1.5f, 0.0f);
            gravityBombEntity.func_226288_n_(playerIn.func_226277_ct_(), 1.0 + playerIn.func_226278_cu_(), playerIn.func_226281_cx_());
            gravityBombEntity.setBonusDamage((Double)AOTConfig.COMMON.gravity_bomb_bonus_damage.get());
            gravityBombEntity.setLevel(Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Spell_Level5")) == 0 ? 0 : Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Spell_Level5")) - 1);
            playerIn.field_70170_p.func_217376_c((Entity)gravityBombEntity);
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.gravity_bomb.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.gravity_bomb.description", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.hold_shift", (Object[])new Object[0]));
            return list;
        }

        @Override
        public List<String> getDetails() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.gravity_bomb.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.bonus_damage", (Object[])new Object[0]) + " (x" + Double.toString(this.base_amount + this.ratio * (double)this.level) + "): \u00a73" + Double.toString(this.base_amount) + "\u00a7f + \u00a7e" + Double.toString(this.ratio) + "\u00a7f * \u00a74" + Integer.toString(this.level));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.duration", (Object[])new Object[0]) + ": \u00a733\u00a7f " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cooldown", (Object[])new Object[0]) + ": " + Integer.toString(this.cooldown) + " " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cost", (Object[])new Object[0]) + ": " + this.cost + " " + I18n.func_135052_a((String)"gui.misc.rage_points", (Object[])new Object[0]));
            list.add("");
            list.add("\u00a73" + I18n.func_135052_a((String)"gui.misc.base", (Object[])new Object[0]) + " \u00a7e" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]) + " \u00a74" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]));
            return list;
        }
    };
    private static final ActiveAbility REVITALISE = new ActiveAbility(6, new ResourceLocation("ageoftitans", "textures/gui/revitaliseicon.png"), new ResourceLocation("ageoftitans", "textures/gui/revitaliseiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/revitaliseiconhud.png"), 0, (Integer)AOTConfig.COMMON.revitalise_cost.get()){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level0", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 0;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            playerIn.func_195064_c(new EffectInstance((Effect)EffectInit.REVITALISE.get(), 100));
            playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187541_bC, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.revitalise.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.revitalise.description", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.hold_shift", (Object[])new Object[0]));
            return list;
        }

        @Override
        public List<String> getDetails() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a74\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.revitalise.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.health_per_tick", (Object[])new Object[0]) + " (" + Double.toString(this.base_amount + this.ratio * (double)this.level) + "): \u00a73" + Double.toString(this.base_amount) + "\u00a7f + \u00a7e" + Double.toString(this.ratio) + "\u00a7f * \u00a74" + Integer.toString(this.level));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cooldown", (Object[])new Object[0]) + ": " + Integer.toString(this.cooldown) + " " + I18n.func_135052_a((String)"gui.misc.seconds", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.misc.cost", (Object[])new Object[0]) + ": " + this.cost + " " + I18n.func_135052_a((String)"gui.misc.rage_points", (Object[])new Object[0]));
            list.add("");
            list.add("\u00a73" + I18n.func_135052_a((String)"gui.misc.base", (Object[])new Object[0]) + " \u00a7e" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]) + " \u00a74" + I18n.func_135052_a((String)"gui.misc.ratio", (Object[])new Object[0]));
            return list;
        }
    };

    public ActiveAbility(int id, ResourceLocation icon, ResourceLocation iconOff, ResourceLocation iconHUD, int level, int cost) {
        this.id = id;
        this.icon = icon;
        this.iconHUD = iconHUD;
        this.level = level;
        this.iconOff = iconOff;
        this.cost = cost;
        this.initRequirements();
    }

    @Override
    public void initRequirements() {
    }

    @Override
    public boolean meetsRequirements() {
        for (Requirement requirement : this.requirements) {
            if (requirement.meetsRequirement()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void effect(World worldIn, PlayerEntity playerIn) {
    }

    @Override
    public double getBaseAmount() {
        return this.base_amount;
    }

    @Override
    public double getRatio() {
        return this.ratio;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public void setBaseAmount(double amount) {
        this.base_amount = amount;
    }

    @Override
    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Override
    public void setCooldown(int cd) {
        this.cooldown = cd;
    }

    @Override
    public void setCost(int cost) {
        this.cost = cost;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public ResourceLocation getIconOff() {
        return this.iconOff;
    }

    public ResourceLocation getIconHUD() {
        return this.iconHUD;
    }

    @Override
    public List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    @Override
    public List<String> getDetails() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    public static List<Ability> getList() {
        return ACTIVE_LIST;
    }

    @Override
    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public static void registerSpells() {
        ACTIVE_LIST.add(NO_SPELL.getId(), NO_SPELL);
        ACTIVE_LIST.add(SWORD_SLASH.getId(), SWORD_SLASH);
        ACTIVE_LIST.add(SHIELD_BASH.getId(), SHIELD_BASH);
        ACTIVE_LIST.add(BERSERKER.getId(), BERSERKER);
        ACTIVE_LIST.add(CHAIN.getId(), CHAIN);
        ACTIVE_LIST.add(GRAVITY_BOMB.getId(), GRAVITY_BOMB);
        ACTIVE_LIST.add(REVITALISE.getId(), REVITALISE);
    }
}

