/*
 * Decompiled with CFR 0.152.
 */
package com.GenZVirus.AgeOfTitans.SpellSystem;

import com.GenZVirus.AgeOfTitans.Common.Config.AOTConfig;
import com.GenZVirus.AgeOfTitans.Common.Network.PacketHandlerCommon;
import com.GenZVirus.AgeOfTitans.Common.Network.ReadElementPacket;
import com.GenZVirus.AgeOfTitans.SpellSystem.Ability;
import com.GenZVirus.AgeOfTitans.SpellSystem.PlayerStats;
import com.GenZVirus.AgeOfTitans.SpellSystem.Requirement;
import com.GenZVirus.AgeOfTitans.SpellSystem.XMLFileJava;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class PassiveAbility
implements Ability {
    private int id;
    private ResourceLocation icon;
    private ResourceLocation iconOff;
    private ResourceLocation iconHUD;
    public int level = 0;
    public double ratio = 0.0;
    public int cooldown = 0;
    public double base_amount = 0.0;
    public int cost = 0;
    public List<Requirement> requirements = Lists.newArrayList();
    private static final List<Ability> PASSIVE_LIST = Lists.newArrayList();
    private static final PassiveAbility NO_SPELL = new PassiveAbility(0, new ResourceLocation("ageoftitans", "textures/gui/noicon.png"), new ResourceLocation("ageoftitans", "textures/gui/noicon.png"), new ResourceLocation("ageoftitans", "textures/gui/noiconhud.png"), 0, 0);
    private static final PassiveAbility FORCE_FIELD = new PassiveAbility(1, new ResourceLocation("ageoftitans", "textures/gui/forcefieldicon.png"), new ResourceLocation("ageoftitans", "textures/gui/forcefieldiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/forcefieldiconhud.png"), 0, 0){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level0", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 0;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            float maxShield;
            float currentShield = playerIn.func_110139_bj();
            if (currentShield < (maxShield = (float)((Double)AOTConfig.COMMON.force_field_base_amount.get() * (Double)AOTConfig.COMMON.force_field_ratio.get() * (double)Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Passive_Level1"))))) {
                playerIn.func_110149_m(currentShield + 1.0f);
            }
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a7b\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.force_field.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.force_field.description", (Object[])new Object[0]) + "\u00a73" + Double.toString(this.base_amount * this.ratio * (double)this.level));
            return list;
        }
    };
    private static final PassiveAbility PRESENCE_OF_A_GOD = new PassiveAbility(2, new ResourceLocation("ageoftitans", "textures/gui/pogicon.png"), new ResourceLocation("ageoftitans", "textures/gui/pogiconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/pogiconhud.png"), 0, 0){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level0", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 0;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            double offset = 5.0;
            ArrayList list = Lists.newArrayList();
            ArrayList posList = Lists.newArrayList();
            Random rand = new Random();
            for (double k = 0.0; k <= 2.0 * offset; k += 1.0) {
                for (double j = 0.0; j <= 2.0 * offset; j += 1.0) {
                    for (double i = 0.0; i <= 2.0 * offset; i += 1.0) {
                        IGrowable igrowable;
                        BlockPos pos = new BlockPos(new Vec3d(playerIn.func_226277_ct_() - offset + i, playerIn.func_226278_cu_() - offset + k, playerIn.func_226281_cx_() - offset + j));
                        BlockState blockstate = worldIn.func_180495_p(pos);
                        if (!(blockstate.func_177230_c() instanceof IGrowable) || !(igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, blockstate, worldIn.field_72995_K) || !(worldIn instanceof ServerWorld) || !igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, blockstate)) continue;
                        list.add(igrowable);
                        posList.add(pos);
                    }
                }
            }
            for (int i = 0; i < (Integer)AOTConfig.COMMON.pog_base_amount.get() + (Integer)AOTConfig.COMMON.pog_ratio.get() * Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Passive_Level2")); ++i) {
                if (list.isEmpty()) {
                    return;
                }
                int index = list.size() > 1 ? rand.nextInt(list.size() - 1) : 0;
                ((IGrowable)list.get(index)).func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, (BlockPos)posList.get(index), worldIn.func_180495_p((BlockPos)posList.get(index)));
            }
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a7b\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.presence_of_a_god.name", (Object[])new Object[0]));
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.ability.presence_of_a_god.description", (Object[])new Object[0]) + "\u00a73" + Integer.toString((int)(this.base_amount + this.base_amount * this.ratio * (double)this.level)));
            return list;
        }
    };
    private static final PassiveAbility REAPER_OF_SOULS = new PassiveAbility(3, new ResourceLocation("ageoftitans", "textures/gui/reaper_of_souls_icon.png"), new ResourceLocation("ageoftitans", "textures/gui/reaper_of_souls_iconoff.png"), new ResourceLocation("ageoftitans", "textures/gui/reaper_of_souls_iconhud.png"), 0, 0){

        @Override
        public void initRequirements() {
            this.requirements.add(new Requirement("FRUIT OF THE GODS"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.fruit_of_the_gods", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.APPLES_EATEN != 0;
                }
            });
            this.requirements.add(new Requirement("Level"){

                @Override
                public String getDescription() {
                    return "\u00a74" + I18n.func_135052_a((String)"gui.requirements.level0", (Object[])new Object[0]);
                }

                @Override
                public boolean meetsRequirement() {
                    return PlayerStats.PLAYER_LEVEL >= 0;
                }
            });
        }

        @Override
        public void effect(World worldIn, PlayerEntity playerIn) {
            double chance = (Double)AOTConfig.COMMON.ros_base_amount.get();
            for (int i = 1; i <= Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Passive_Level3")); ++i) {
                chance += chance * (Double)AOTConfig.COMMON.ros_ratio.get();
            }
            Random random = new Random();
            if (random.nextDouble() <= chance) {
                XMLFileJava.editElement(playerIn.func_110124_au(), "Balance", Integer.toString(Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Balance")) + 1));
                PacketHandlerCommon.INSTANCE.sendTo((Object)new ReadElementPacket(playerIn.func_110124_au(), "Balance", Integer.parseInt(XMLFileJava.readElement(playerIn.func_110124_au(), "Balance"))), ((ServerPlayerEntity)playerIn).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }

        @Override
        public List<String> getDescription() {
            ArrayList list = Lists.newArrayList();
            list.add("\u00a7b\u00a7n\u00a7l" + I18n.func_135052_a((String)"gui.ability.reaper_of_souls.name", (Object[])new Object[0]));
            list.add("");
            double chance = this.base_amount;
            for (int i = 1; i <= this.level; ++i) {
                chance += chance * this.ratio;
            }
            list.add(I18n.func_135052_a((String)"gui.ability.reaper_of_souls.description", (Object[])new Object[0]) + "\u00a73" + String.format("%.2f", chance * 100.0) + "%");
            return list;
        }
    };

    public PassiveAbility(int id, ResourceLocation icon, ResourceLocation iconOff, ResourceLocation iconHUD, int level, int cost) {
        this.id = id;
        this.icon = icon;
        this.iconHUD = iconHUD;
        this.level = level;
        this.iconOff = iconOff;
        this.cost = cost;
        this.initRequirements();
    }

    @Override
    public void initRequirements() {
    }

    @Override
    public boolean meetsRequirements() {
        for (Requirement requirement : this.requirements) {
            if (requirement.meetsRequirement()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void effect(World worldIn, PlayerEntity playerIn) {
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setBaseAmount(double amount) {
        this.base_amount = amount;
    }

    @Override
    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Override
    public void setCooldown(int cd) {
        this.cooldown = 0;
    }

    @Override
    public void setCost(int cost) {
        this.cost = 0;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public double getBaseAmount() {
        return this.base_amount;
    }

    @Override
    public double getRatio() {
        return this.ratio;
    }

    @Override
    public int getCooldown() {
        return 0;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public ResourceLocation getIconOff() {
        return this.iconOff;
    }

    public ResourceLocation getIconHUD() {
        return this.iconHUD;
    }

    @Override
    public List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    @Override
    public List<String> getDetails() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    public static List<Ability> getList() {
        return PASSIVE_LIST;
    }

    @Override
    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public static void registerPassives() {
        PASSIVE_LIST.add(NO_SPELL.getId(), NO_SPELL);
        PASSIVE_LIST.add(FORCE_FIELD.getId(), FORCE_FIELD);
        PASSIVE_LIST.add(PRESENCE_OF_A_GOD.getId(), PRESENCE_OF_A_GOD);
        PASSIVE_LIST.add(REAPER_OF_SOULS.getId(), REAPER_OF_SOULS);
    }
}

