/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.block;

import com.bagel.atmospheric.core.data.AtmosphericBlockStates;
import com.bagel.atmospheric.core.data.AtmosphericTags;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.bagel.atmospheric.core.registry.AtmosphericItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class PassionVineBlock
extends Block
implements IGrowable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty AGE = AtmosphericBlockStates.AGE_0_4;
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return EAST_AABB;
    }

    public PassionVineBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        boolean randomNum;
        super.func_196267_b(state, worldIn, pos, random);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        boolean light = worldIn.func_201669_a(pos.func_177984_a(), 0) >= 5;
        boolean notOld = i < 4;
        boolean canFlower = i >= 1;
        boolean canFruit = notOld && light;
        boolean bl = randomNum = worldIn.field_73012_v.nextInt(2) == 1;
        if (canFlower) {
            if (canFruit) {
                if (randomNum) {
                    this.attemptGrowDown(state, worldIn, pos, random);
                } else {
                    this.attemptGrowFruit(state, worldIn, pos, random);
                }
            } else {
                this.attemptGrowDown(state, worldIn, pos, random);
            }
        } else if (canFruit) {
            this.attemptGrowFruit(state, worldIn, pos, random);
        }
    }

    public void attemptGrowFruit(BlockState state, World worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockState hanging = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (hanging.func_177230_c().func_203417_a(AtmosphericTags.PASSION_VINE_GROWABLE_ON)) {
            if (i < 4 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(7) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        } else if (i < 1 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(7) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void attemptGrowDown(BlockState state, World worldIn, BlockPos pos, Random random) {
        BlockState below;
        if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(7) == 0 ? 1 : 0) != 0) && (below = worldIn.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150350_a) {
            worldIn.func_175656_a(pos.func_177977_b(), (BlockState)((BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean flag;
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        boolean bl = flag = i == 4;
        if (!flag && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return false;
        }
        if (i == 4) {
            PassionVineBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)AtmosphericItems.PASSIONFRUIT.get(), 1 + worldIn.field_73012_v.nextInt(2) + worldIn.field_73012_v.nextInt(2) + worldIn.field_73012_v.nextInt(3)));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(1)), 2);
            return true;
        }
        if (i == 1 && player.func_184586_b(handIn).func_77973_b() == Items.field_151097_aZ) {
            Direction direction = hit.func_216354_b();
            Direction direction1 = direction.func_176740_k() == Direction.Axis.Y ? player.func_174811_aO().func_176734_d() : direction;
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5 + (double)direction1.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)direction1.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_222069_lA, 1));
            itementity.func_213293_j(0.05 * (double)direction1.func_82601_c() + worldIn.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.func_82599_e() + worldIn.field_73012_v.nextDouble() * 0.02);
            worldIn.func_217376_c((Entity)itementity);
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, p_213442_1_ -> p_213442_1_.func_213334_d(handIn));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 2);
            return true;
        }
        return super.func_220051_a(state, worldIn, pos, player, handIn, hit);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE, FACING});
    }

    private boolean canAttachTo(IBlockReader p_196471_1_, BlockPos p_196471_2_, Direction p_196471_3_) {
        BlockState blockstate = p_196471_1_.func_180495_p(p_196471_2_);
        return !blockstate.func_185897_m() && blockstate.func_224755_d(p_196471_1_, p_196471_2_, p_196471_3_);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return this.canAttachTo((IBlockReader)worldIn, pos.func_177972_a(direction.func_176734_d()), direction) || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == AtmosphericBlocks.PASSION_VINE.get() && worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)FACING) == state.func_177229_b((IProperty)FACING);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate;
        if (!context.func_196012_c() && (blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()))).func_177230_c() == this && blockstate.func_177229_b((IProperty)FACING) == context.func_196000_l()) {
            return null;
        }
        BlockState blockstate1 = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : context.func_196009_e()) {
            if (!direction.func_176740_k().func_176722_c() || !(blockstate1 = (BlockState)blockstate1.func_206870_a((IProperty)FACING, (Comparable)direction.func_176734_d())).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstate1;
        }
        return null;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 4;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.func_177229_b((IProperty)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

