/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.entity;

import com.bagel.atmospheric.core.data.AtmosphericDamageSources;
import com.bagel.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PassionfruitSeedEntity
extends ProjectileItemEntity {
    private final int amplifier;

    public PassionfruitSeedEntity(EntityType<? extends PassionfruitSeedEntity> type, World world, int amplifier) {
        super(type, world);
        this.amplifier = amplifier;
    }

    public PassionfruitSeedEntity(World worldIn, LivingEntity throwerIn, int amplifier) {
        super(EntityType.field_200746_al, throwerIn, worldIn);
        this.amplifier = amplifier;
    }

    public PassionfruitSeedEntity(World worldIn, double x, double y, double z, int amplifier) {
        super(EntityType.field_200746_al, x, y, z, worldIn);
        this.amplifier = amplifier;
    }

    protected Item func_213885_i() {
        return Items.field_151126_ay;
    }

    @OnlyIn(value=Dist.CLIENT)
    private IParticleData makeParticle() {
        ItemStack itemstack = this.func_213882_k();
        return itemstack.func_190926_b() ? ParticleTypes.field_197593_D : new ItemParticleData(ParticleTypes.field_197591_B, itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            IParticleData iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a(iparticledata, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            entity.func_70097_a(AtmosphericDamageSources.causePassionfruitSeedDamage((Entity)this, (Entity)this.func_85052_h()), 0.5f + (float)(this.amplifier * 1 / 2));
            if (entity instanceof LivingEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this.func_85052_h();
                if (!entity.func_130014_f_().func_201670_d()) {
                    AtmosphericCriteriaTriggers.SPIT_PASSIONFRUIT.trigger(serverplayerentity);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }
}

