/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.world.gen.feature;

import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class RosewoodTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    public RosewoodTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51443_1_, boolean p_i51443_2_) {
        super(p_i51443_1_, p_i51443_2_);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundsIn) {
        int branches = 2 + rand.nextInt(3);
        int height = 4 + rand.nextInt(2) + rand.nextInt(3) + rand.nextInt(3);
        int bonusCanopies = rand.nextInt(3);
        boolean flag = true;
        int i = height;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (RosewoodTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (RosewoodTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - branches - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                boolean canopy = false;
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) {
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, boundsIn, Direction.UP);
                    }
                    if (rand.nextInt(6) != 0 || k1 <= 3 || k1 >= height || canopy) continue;
                    int leafSize = 1 + rand.nextInt(2);
                    for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                            this.placeLeafAt(changedBlocks, worldIn, blockpos.func_177982_a(k3, 0, j4), boundsIn);
                        }
                    }
                    canopy = true;
                }
                ArrayList<String> directions = new ArrayList<String>();
                for (int k2 = 0; k2 < branches; ++k2) {
                    int j4;
                    int k3;
                    Direction offset = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    while (directions.contains(offset.toString())) {
                        offset = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    }
                    directions.add(offset.toString());
                    int turns = 1 + rand.nextInt(3);
                    BlockPos currentPos = position.func_177967_a(Direction.UP, height - 1);
                    int branchLength = 0;
                    int branchHeight = 0;
                    for (int k4 = 0; k4 < turns; ++k4) {
                        branchLength = 1 + rand.nextInt(2) + rand.nextInt(2);
                        branchHeight = 1 + rand.nextInt(3) + rand.nextInt(2);
                        this.createHorizontalLog(branchLength, changedBlocks, worldIn, currentPos, offset, boundsIn);
                        this.createVerticalLog(branchHeight, changedBlocks, worldIn, currentPos.func_177967_a(offset, branchLength), boundsIn, rand);
                        currentPos = currentPos.func_177967_a(offset, branchLength).func_177967_a(Direction.UP, branchHeight);
                    }
                    int leafSize = 2 + rand.nextInt(2);
                    int leafSizeTop = 0;
                    leafSizeTop = leafSize == 2 ? leafSize - 1 : leafSize - 1 - rand.nextInt(2);
                    for (k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                            this.placeLeafAt(changedBlocks, worldIn, currentPos.func_177982_a(k3, 0, j4), boundsIn);
                        }
                    }
                    currentPos = currentPos.func_177967_a(Direction.UP, 1);
                    for (k3 = -leafSizeTop; k3 <= leafSizeTop; ++k3) {
                        for (j4 = -leafSizeTop; j4 <= leafSizeTop; ++j4) {
                            if (Math.abs(k3) == leafSizeTop && Math.abs(j4) == leafSizeTop) continue;
                            this.placeLeafAt(changedBlocks, worldIn, currentPos.func_177982_a(k3, 0, j4), boundsIn);
                        }
                    }
                    logX = position.func_177958_n();
                    logZ = position.func_177952_p();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createHorizontalLog(int branchLength, Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, MutableBoundingBox boundsIn) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.func_82601_c(), logY, logZ += direction.func_82599_e());
            if (!RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos1, boundsIn, direction);
        }
    }

    private void createVerticalLog(int branchHeight, Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox boundsIn, Random rand) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        boolean canopy = false;
        for (int k1 = 0; k1 < branchHeight; ++k1) {
            BlockPos blockpos;
            if (RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(logX, ++logY, logZ)))) {
                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, boundsIn, Direction.UP);
            }
            if (rand.nextInt(6) != 0 || canopy) continue;
            int leafSize = 1 + rand.nextInt(2);
            for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                    this.placeLeafAt(changedBlocks, worldIn, blockpos.func_177982_a(k3, 0, j4), boundsIn);
                }
            }
            canopy = true;
        }
    }

    private void placeLogAt(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, MutableBoundingBox boundsIn, Direction direction) {
        this.func_208520_a(changedBlocks, worldIn, pos, (BlockState)((Block)AtmosphericBlocks.ROSEWOOD_LOG.get()).func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundsIn);
    }

    private void placeLeafAt(Set<BlockPos> worldIn, IWorldGenerationReader pos, BlockPos p_175924_3_, MutableBoundingBox boundsIn) {
        if (RosewoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)pos, (BlockPos)p_175924_3_)) {
            this.func_208520_a(worldIn, (IWorldWriter)pos, p_175924_3_, ((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get()).func_176223_P(), boundsIn);
        }
    }
}

