/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.world.gen.feature;

import com.bagel.atmospheric.core.data.AtmosphericTags;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class YuccaTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    public YuccaTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyIn) {
        super(configFactoryIn, doBlockNotifyIn);
    }

    private void crossSection(IWorldGenerationReader worldIn, BlockPos pos, float p_208529_3_, MutableBoundingBox p_208529_4_, Set<BlockPos> changedBlocks) {
        int i = (int)((double)p_208529_3_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_208529_3_ * p_208529_3_)) || !YuccaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = pos.func_177982_a(j, 0, k)))) continue;
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, ((Block)AtmosphericBlocks.YUCCA_LEAVES.get()).func_176223_P(), p_208529_4_);
            }
        }
    }

    private float treeShape(int p_208527_1_, int p_208527_2_) {
        if ((float)p_208527_2_ < (float)p_208527_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_208527_1_ / 2.0f;
        float f1 = f - (float)p_208527_2_;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    private float foliageShape(int y) {
        if (y >= 0 && y < 5) {
            return y != 0 && y != 4 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    private void foliageCluster(IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox p_202393_3_, Set<BlockPos> changedBlocks) {
        for (int i = 0; i < 5; ++i) {
            this.crossSection(worldIn, pos.func_177981_b(i), this.foliageShape(i), p_202393_3_, changedBlocks);
        }
    }

    private int makeLimb(Set<BlockPos> p_208523_1_, IWorldGenerationReader worldIn, BlockPos p_208523_3_, BlockPos p_208523_4_, boolean p_208523_5_, MutableBoundingBox p_208523_6_) {
        if (!p_208523_5_ && Objects.equals(p_208523_3_, p_208523_4_)) {
            return -1;
        }
        BlockPos blockpos = p_208523_4_.func_177982_a(-p_208523_3_.func_177958_n(), -p_208523_3_.func_177956_o(), -p_208523_3_.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_208523_3_.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (p_208523_5_) {
                this.func_208520_a(p_208523_1_, (IWorldWriter)worldIn, blockpos1, (BlockState)((Block)AtmosphericBlocks.YUCCA_LOG.get()).func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)this.getLoxAxis(p_208523_3_, blockpos1)), p_208523_6_);
                continue;
            }
            if (YuccaTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        if (k > i && k > j) {
            return k;
        }
        return j > i ? j : i;
    }

    private Direction.Axis getLoxAxis(BlockPos p_197170_1_, BlockPos p_197170_2_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_197170_2_.func_177958_n() - p_197170_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_197170_2_.func_177952_p() - p_197170_1_.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                direction$axis = Direction.Axis.X;
            } else if (j == k) {
                direction$axis = Direction.Axis.Z;
            }
        }
        return direction$axis;
    }

    private void makeFoliage(IWorldGenerationReader worldIn, int p_208525_2_, BlockPos pos, List<FoliageCoordinates> p_208525_4_, MutableBoundingBox p_208525_5_, Set<BlockPos> changedBlocks) {
        for (FoliageCoordinates bigtreefeature$foliagecoordinates : p_208525_4_) {
            if (!this.trimBranches(p_208525_2_, bigtreefeature$foliagecoordinates.getBranchBase() - pos.func_177956_o())) continue;
            this.foliageCluster(worldIn, bigtreefeature$foliagecoordinates, p_208525_5_, changedBlocks);
        }
    }

    private boolean trimBranches(int p_208522_1_, int p_208522_2_) {
        return (double)p_208522_2_ >= (double)p_208522_1_ * 0.2;
    }

    private void makeTrunk(Set<BlockPos> p_208526_1_, IWorldGenerationReader p_208526_2_, BlockPos p_208526_3_, int p_208526_4_, MutableBoundingBox p_208526_5_) {
        this.makeLimb(p_208526_1_, p_208526_2_, p_208526_3_, p_208526_3_.func_177981_b(p_208526_4_), true, p_208526_5_);
    }

    private void makeBranches(Set<BlockPos> p_208524_1_, IWorldGenerationReader p_208524_2_, int p_208524_3_, BlockPos p_208524_4_, List<FoliageCoordinates> p_208524_5_, MutableBoundingBox p_208524_6_) {
        for (FoliageCoordinates bigtreefeature$foliagecoordinates : p_208524_5_) {
            int i = bigtreefeature$foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(p_208524_4_.func_177958_n(), i, p_208524_4_.func_177952_p());
            if (blockpos.equals((Object)bigtreefeature$foliagecoordinates) || !this.trimBranches(p_208524_3_, i - p_208524_4_.func_177956_o())) continue;
            this.makeLimb(p_208524_1_, p_208524_2_, blockpos, bigtreefeature$foliagecoordinates, true, p_208524_6_);
        }
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i1;
        int k;
        Random random = new Random(rand.nextLong());
        int i = this.checkLocation(changedBlocks, worldIn, position, 5 + random.nextInt(12), p_208519_5_);
        if (i == -1) {
            return false;
        }
        this.setDirtAt(worldIn, position.func_177977_b(), position);
        int j = (int)((double)i * 0.618);
        if (j >= i) {
            j = i - 1;
        }
        if ((k = (int)(1.382 + Math.pow(1.0 * (double)i / 13.0, 2.0))) < 1) {
            k = 1;
        }
        int l = position.func_177956_o() + j;
        ArrayList list = Lists.newArrayList();
        list.add(new FoliageCoordinates(position.func_177981_b(i1), l));
        for (i1 = i - 5; i1 >= 0; --i1) {
            float f = this.treeShape(i, i1);
            if (f < 0.0f) continue;
            for (int j1 = 0; j1 < k; ++j1) {
                BlockPos blockpos1;
                double d5;
                double d3;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d4 = d2 * Math.sin(d3 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = position.func_177963_a(d4, (double)(i1 - 1), d5 = d2 * Math.cos(d3) + 0.5);
                if (this.makeLimb(changedBlocks, worldIn, blockpos, blockpos1 = blockpos.func_177981_b(5), false, p_208519_5_) != -1) continue;
                int k1 = position.func_177958_n() - blockpos.func_177958_n();
                int l1 = position.func_177952_p() - blockpos.func_177952_p();
                double d6 = (double)blockpos.func_177956_o() - Math.sqrt(k1 * k1 + l1 * l1) * 0.381;
                int i2 = d6 > (double)l ? l : (int)d6;
                BlockPos blockpos2 = new BlockPos(position.func_177958_n(), i2, position.func_177952_p());
                if (this.makeLimb(changedBlocks, worldIn, blockpos2, blockpos, false, p_208519_5_) != -1) continue;
                list.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
        this.makeFoliage(worldIn, i, position, list, p_208519_5_, changedBlocks);
        this.makeTrunk(changedBlocks, worldIn, position, j, p_208519_5_);
        this.makeBranches(changedBlocks, worldIn, i, position, list, p_208519_5_);
        return true;
    }

    private int checkLocation(Set<BlockPos> p_208528_1_, IWorldGenerationReader p_208528_2_, BlockPos p_208528_3_, int p_208528_4_, MutableBoundingBox p_208528_5_) {
        if (!YuccaTreeFeature.isBamboo((IWorldGenerationBaseReader)p_208528_2_, p_208528_3_.func_177977_b(), this.getYuccaSapling())) {
            return -1;
        }
        int i = this.makeLimb(p_208528_1_, p_208528_2_, p_208528_3_, p_208528_3_.func_177981_b(p_208528_4_ - 1), false, p_208528_5_);
        if (i == -1) {
            return p_208528_4_;
        }
        return i < 6 ? -1 : i;
    }

    protected static boolean isBamboo(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return YuccaTreeFeature.isBambooPlantable(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    protected static boolean isBambooPlantable(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_203425_a(AtmosphericTags.YUCCA_PLANTABLE_ON));
    }

    protected IPlantable getYuccaSapling() {
        return (IPlantable)AtmosphericBlocks.YUCCA_SAPLING.get();
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

