/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.core;

import com.bagel.atmospheric.client.renderer.AtmosphericBoatRenderer;
import com.bagel.atmospheric.common.data.PassionVineBundleDispenseBehavior;
import com.bagel.atmospheric.common.data.PassionVineDispenseBehavior;
import com.bagel.atmospheric.common.entity.AtmosphericBoatEntity;
import com.bagel.atmospheric.core.data.AtmosphericBlockData;
import com.bagel.atmospheric.core.data.AtmosphericColors;
import com.bagel.atmospheric.core.registry.AtmosphericBiomes;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.bagel.atmospheric.core.registry.AtmosphericEffects;
import com.bagel.atmospheric.core.registry.AtmosphericEntities;
import com.bagel.atmospheric.core.registry.AtmosphericFoods;
import com.bagel.atmospheric.core.registry.AtmosphericItems;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="atmospheric")
@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Atmospheric {
    public static final String MODID = "atmospheric";

    public Atmospheric() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AtmosphericBlocks.BLOCKS.register(modEventBus);
        AtmosphericItems.ITEMS.register(modEventBus);
        AtmosphericBiomes.BIOMES.register(modEventBus);
        AtmosphericEntities.ENTITY_TYPES.register(modEventBus);
        AtmosphericEffects.EFFECTS.register(modEventBus);
        AtmosphericEffects.POTIONS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::setup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::clientSetup));
    }

    private void setup(FMLCommonSetupEvent event) {
        AtmosphericBiomes.registerBiomesToDictionary();
        AtmosphericBlockData.registerCompostables();
        AtmosphericBlockData.registerFlammables();
        AtmosphericBlockData.registerStrippables();
        AtmosphericEffects.registerBrewingRecipes();
        DispenserBlock.func_199774_a((IItemProvider)((Block)AtmosphericBlocks.PASSION_VINE_BUNDLE.get()).func_199767_j(), (IDispenseItemBehavior)new PassionVineBundleDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((Block)AtmosphericBlocks.PASSION_VINE.get()).func_199767_j(), (IDispenseItemBehavior)new PassionVineDispenseBehavior());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        AtmosphericColors.registerBlockColors();
        RenderingRegistry.registerEntityRenderingHandler(AtmosphericBoatEntity.class, AtmosphericBoatRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterEffects(RegistryEvent.Register<Effect> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Effect[]{AtmosphericFoods.SPITTING, AtmosphericFoods.GOLDEN_SPITTING});
    }
}

