/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.modsupport;

import com.bagel.atmospheric.common.world.biome.dunes.DunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.FlourishingDunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.PetrifiedDunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.RockyDunesBiome;
import com.bagel.atmospheric.common.world.biome.rosewood.RosewoodForestBiome;
import com.bagel.atmospheric.common.world.biome.rosewood.RosewoodPlateauBiome;
import com.bagel.atmospheric.core.registry.AtmosphericFeatures;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class EntombedEcosystems {

    public static class AtmosphericBiomeList {
        public static Biome rosewoodForest = new RosewoodForestBiome();
        public static Biome rosewoodPlateau = new RosewoodPlateauBiome();
        public static Biome rockDunes = new RockyDunesBiome();
        public static Biome petrifiedDunes = new PetrifiedDunesBiome();
        public static Biome flourishingDunes = new FlourishingDunesBiome();
        public static Biome dunesBiomes = new DunesBiome();
    }

    public static class EEPlacerList {
        public static final Placement<AtSurfaceWithExtraConfig> EETREEPLACER = new EETreePlacer(AtSurfaceWithExtraConfig::func_214723_a);
    }

    public static class EETreePlacer
    extends Placement<AtSurfaceWithExtraConfig> {
        public EETreePlacer(Function<Dynamic<?>, ? extends AtSurfaceWithExtraConfig> configFactoryIn) {
            super(configFactoryIn);
        }

        public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, AtSurfaceWithExtraConfig chancesConfig, BlockPos pos) {
            int c = chancesConfig.field_202478_a;
            if (random.nextFloat() < chancesConfig.field_202479_b) {
                c += chancesConfig.field_202480_c;
            }
            boolean airFlag = false;
            boolean airBlock = true;
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            for (int i = 0; i < c; ++i) {
                int x = random.nextInt(16);
                int z = random.nextInt(16);
                for (int height = worldIn.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177982_a(x, 0, z)).func_177956_o() - 5; height > 15; --height) {
                    airBlock = worldIn.func_175623_d(pos.func_177982_a(x, height, z));
                    if (!airFlag && airBlock) {
                        airFlag = true;
                        continue;
                    }
                    if (!airFlag || airBlock) continue;
                    blockPosList.add(pos.func_177982_a(x, height + 1, z));
                    airFlag = false;
                }
            }
            return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
        }
    }

    public static class EEFeatureAdder {
        public static void EEaddRosewoodForestTrees(Biome biomeIn, int count, int extraCountIn) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202292_al, (IFeatureConfig)new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.3f}, Feature.field_202301_A, (IFeatureConfig)IFeatureConfig.field_202429_e), EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.3f, 1)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(AtmosphericFeatures.ROSEWOOD_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(count, 0.1f, extraCountIn)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(AtmosphericFeatures.OAK_BUSH, (IFeatureConfig)IFeatureConfig.field_202429_e, EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        }

        public static void EEaddRosewoodPlateauTrees(Biome biomeIn, int count, int extraCountIn) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(AtmosphericFeatures.ROSEWOOD_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(count, 0.1f, extraCountIn)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(AtmosphericFeatures.OAK_BUSH, (IFeatureConfig)IFeatureConfig.field_202429_e, EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        }

        public static void EEaddYuccaTrees(Biome biomeIn) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(AtmosphericFeatures.YUCCA_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 3)));
        }

        public static void EEaddSparseYuccaTrees(Biome biomeIn) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(AtmosphericFeatures.YUCCA_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, EEPlacerList.EETREEPLACER, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1)));
        }
    }
}

