/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.world.biome;

import com.bagel.atmospheric.common.world.biome.AtmosphericFeatureConfigs;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.bagel.atmospheric.core.registry.AtmosphericFeatures;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;

public class AtmosphericBiomeFeatures {
    public static void addRainforestDoublePlants(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226727_O_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(8))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226724_L_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226723_K_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226725_M_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addRainforestFlowers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226829_x_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.WARM_MONKEY_BRUSH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.HOT_MONKEY_BRUSH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.SCALDING_MONKEY_BRUSH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addGilias(Biome biomeIn, int freq) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.GILIA_CONFIG).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(freq))));
    }

    public static void addAloeVera(Biome biomeIn, int freq) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.ALOE_VERA.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.ALOE_VERA_CONFIG).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(freq))));
    }

    public static void addYuccaFlower(Biome biomeIn, int freq) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.YUCCA_FLOWER.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.YUCCA_FLOWER_CONFIG).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(freq))));
    }

    public static void addBarrelCactus(Biome biomeIn, int count, float extraChance, int extraCount) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.BARREL_CACTUS.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.BARREL_CACTUS_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
    }

    public static void addPodzol(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.PODZOL.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.2f)).func_227228_a_(Placement.field_215038_x.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(160, 80.0, 0.3, Heightmap.Type.WORLD_SURFACE_WG))));
    }

    public static void addRainforestFoliage(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226828_w_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(25))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202326_Z.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215019_e.func_227446_a_((IPlacementConfig)new FrequencyConfig(50))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.PASSION_VINE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addDeadBushes(Biome biomeIn, int freq) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226715_C_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(freq))));
    }

    public static void addRosewoodForestTrees(Biome biomeIn, int count, int extraCountIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226817_l_).func_227227_a_(0.33333334f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226816_k_))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.ROSEWOOD_TREE.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.ROSEWOOD_TREE_BEEHIVES_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, 0.1f, extraCountIn))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.OAK_BUSH.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
    }

    public static void addRosewoodPlateauTrees(Biome biomeIn, int count, int extraCountIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.ROSEWOOD_TREE.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.ROSEWOOD_TREE_BEEHIVES_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, 0.1f, extraCountIn))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.OAK_BUSH.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
    }

    public static void addDuneRocks(Biome biomeIn, int size, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.DUNE_ROCKS.func_225566_b_((IFeatureConfig)new BlockBlobConfig(((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).func_176223_P(), size)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addFossils(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_202316_P.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215025_k.func_227446_a_((IPlacementConfig)new ChanceConfig(64))));
    }

    public static void addSurfaceFossils(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, AtmosphericFeatures.SURFACE_FOSSIL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215025_k.func_227446_a_((IPlacementConfig)new ChanceConfig(64))));
    }

    public static void addYuccaTrees(Biome biomeIn, int count, float extraChance, int extraCount, boolean petrified) {
        Feature<TreeFeatureConfig> feature = petrified ? AtmosphericFeatures.PETRIFIED_YUCCA_TREE : AtmosphericFeatures.YUCCA_TREE_PATCH;
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.YUCCA_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
    }

    public static void addBeehiveYuccaTrees(Biome biomeIn, int count, float extraChance, int extraCount) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.YUCCA_TREE_PATCH.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.FLOURISHING_KOUSA_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
    }

    public static void addBabyYuccaTrees(Biome biomeIn, int count, float extraChance, int extraCount) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.BABY_YUCCA_TREE_PATCH.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.YUCCA_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
    }

    public static void addRainforestWaterFoliage(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226720_H_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(64, 0.6)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addDuneGrassPatches(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.COARSE_DIRT_PATCH.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(Blocks.field_196660_k.func_176223_P(), 7, 2, (List)Lists.newArrayList((Object[])new BlockState[]{((Block)AtmosphericBlocks.RED_ARID_SAND.get()).func_176223_P(), ((Block)AtmosphericBlocks.ARID_SAND.get()).func_176223_P()}))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.8f, 1))));
    }

    public static void addMelons(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)AtmosphericFeatureConfigs.MELON_PATCH_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
    }
}

