/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.common.world.gen.structure;

import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import com.bagel.atmospheric.core.registry.AtmosphericFeatures;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AridShrinePieces {
    private static final ResourceLocation MAIN = new ResourceLocation("atmospheric:arid_shrine/arid_shrine");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)MAIN, (Object)new BlockPos(0, -3, 0));

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, MAIN, blockpos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(AtmosphericFeatures.ARID_SHRINE_PIECES, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(AtmosphericFeatures.ARID_SHRINE_PIECES, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("decor".equals(function)) {
                ArrayList<Object> stateList = new ArrayList<Object>();
                stateList.add(((Block)AtmosphericBlocks.ALOE_BUNDLE.get()).func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X));
                stateList.add(((Block)AtmosphericBlocks.ALOE_BUNDLE.get()).func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                stateList.add(((Block)AtmosphericBlocks.ALOE_BUNDLE.get()).func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z));
                stateList.add(((Block)AtmosphericBlocks.ALOE_GEL_BLOCK.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.POTTED_BARREL_CACTUS.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.POTTED_GILIA.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.POTTED_YUCCA_FLOWER.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.POTTED_YUCCA_SAPLING.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.YUCCA_BUNDLE.get()).func_176223_P());
                stateList.add(((Block)AtmosphericBlocks.YUCCA_GATEAU.get()).func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH));
                stateList.add(((Block)AtmosphericBlocks.YUCCA_GATEAU.get()).func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST));
                stateList.add(((Block)AtmosphericBlocks.YUCCA_GATEAU.get()).func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH));
                stateList.add(((Block)AtmosphericBlocks.YUCCA_GATEAU.get()).func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST));
                worldIn.func_180501_a(pos, (BlockState)stateList.get(rand.nextInt(stateList.size())), 2);
            }
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(0 - blockpos.func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            return super.func_225577_a_(worldIn, p_225577_2_, randomIn, structureBoundingBoxIn, chunkPos);
        }
    }
}

