/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.core.registry;

import com.bagel.atmospheric.common.world.biome.dunes.DunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.DunesHillsBiome;
import com.bagel.atmospheric.common.world.biome.dunes.FlourishingDunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.PetrifiedDunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.RockyDunesBiome;
import com.bagel.atmospheric.common.world.biome.dunes.RockyDunesHillsBiome;
import com.bagel.atmospheric.common.world.biome.rosewood.RosewoodForestBiome;
import com.bagel.atmospheric.common.world.biome.rosewood.RosewoodForestPlateauBiome;
import com.bagel.atmospheric.common.world.biome.rosewood.RosewoodMountainsBiome;
import com.bagel.atmospheric.common.world.biome.rosewood.RosewoodPlateauBiome;
import com.bagel.atmospheric.core.other.AtmosphericConfig;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericBiomes {
    public static final DeferredRegister<Biome> BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "atmospheric");
    public static final RegistryObject<Biome> ROSEWOOD_FOREST = BIOMES.register("rosewood_forest", () -> new RosewoodForestBiome());
    public static final RegistryObject<Biome> ROSEWOOD_MOUNTAINS = BIOMES.register("rosewood_mountains", () -> new RosewoodMountainsBiome());
    public static final RegistryObject<Biome> ROSEWOOD_PLATEAU = BIOMES.register("rosewood_plateau", () -> new RosewoodPlateauBiome());
    public static final RegistryObject<Biome> ROSEWOOD_FOREST_PLATEAU = BIOMES.register("rosewood_forest_plateau", () -> new RosewoodForestPlateauBiome());
    public static final RegistryObject<Biome> DUNES = BIOMES.register("dunes", () -> new DunesBiome());
    public static final RegistryObject<Biome> DUNES_HILLS = BIOMES.register("dunes_hills", () -> new DunesHillsBiome());
    public static final RegistryObject<Biome> FLOURISHING_DUNES = BIOMES.register("flourishing_dunes", () -> new FlourishingDunesBiome());
    public static final RegistryObject<Biome> ROCKY_DUNES = BIOMES.register("rocky_dunes", () -> new RockyDunesBiome());
    public static final RegistryObject<Biome> ROCKY_DUNES_HILLS = BIOMES.register("rocky_dunes_hills", () -> new RockyDunesHillsBiome());
    public static final RegistryObject<Biome> PETRIFIED_DUNES = BIOMES.register("petrified_dunes", () -> new PetrifiedDunesBiome());

    public static void registerBiomesToDictionary() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)ROSEWOOD_FOREST.get(), AtmosphericConfig.ValuesHolder.getRosewoodForestWeight()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)DUNES.get(), AtmosphericConfig.ValuesHolder.getDunesWeight()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)ROCKY_DUNES.get(), AtmosphericConfig.ValuesHolder.getRockyDunesWeight()));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((Biome)((Biome)ROSEWOOD_FOREST.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROSEWOOD_MOUNTAINS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROSEWOOD_PLATEAU.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROSEWOOD_FOREST_PLATEAU.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)DUNES_HILLS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)FLOURISHING_DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROCKY_DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROCKY_DUNES_HILLS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)PETRIFIED_DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
    }
}

