/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.atmospheric.core.registry;

import com.bagel.atmospheric.common.world.biome.AtmosphericBiomeFeatures;
import com.bagel.atmospheric.common.world.gen.feature.AloeVeraFeature;
import com.bagel.atmospheric.common.world.gen.feature.BabyYuccaTreeFeature;
import com.bagel.atmospheric.common.world.gen.feature.BarrelCactusFeature;
import com.bagel.atmospheric.common.world.gen.feature.CoarseDirtPatchFeature;
import com.bagel.atmospheric.common.world.gen.feature.DirectionalFlowersFeature;
import com.bagel.atmospheric.common.world.gen.feature.DuneRocksFeature;
import com.bagel.atmospheric.common.world.gen.feature.PassionVineFeature;
import com.bagel.atmospheric.common.world.gen.feature.PodzolFeature;
import com.bagel.atmospheric.common.world.gen.feature.RosewoodTreeFeature;
import com.bagel.atmospheric.common.world.gen.feature.SurfaceFossilFeature;
import com.bagel.atmospheric.common.world.gen.feature.YuccaFlowerFeature;
import com.bagel.atmospheric.common.world.gen.feature.YuccaTreeFeature;
import com.bagel.atmospheric.common.world.gen.structure.AridShrinePieces;
import com.bagel.atmospheric.common.world.gen.structure.AridShrineStructure;
import com.bagel.atmospheric.common.world.gen.surfacebuilders.DunesSurfaceBuilder;
import com.bagel.atmospheric.common.world.gen.surfacebuilders.WaveyDunesSurfaceBuilder;
import com.bagel.atmospheric.core.registry.AtmosphericBiomes;
import com.bagel.atmospheric.core.registry.AtmosphericBlocks;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.FancyTreeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MegaPineTree;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.ShrubFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericFeatures {
    public static final Feature<ProbabilityConfig> PODZOL = new PodzolFeature(ProbabilityConfig::func_214645_a);
    public static final Feature<NoFeatureConfig> SURFACE_FOSSIL = new SurfaceFossilFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<BaseTreeFeatureConfig> OAK_BUSH = new ShrubFeature(BaseTreeFeatureConfig::func_227376_b_);
    public static final Feature<SphereReplaceConfig> COARSE_DIRT_PATCH = new CoarseDirtPatchFeature(SphereReplaceConfig::func_214691_a);
    public static final Feature<NoFeatureConfig> WARM_MONKEY_BRUSH = new DirectionalFlowersFeature(NoFeatureConfig::func_214639_a, 1);
    public static final Feature<NoFeatureConfig> HOT_MONKEY_BRUSH = new DirectionalFlowersFeature(NoFeatureConfig::func_214639_a, 2);
    public static final Feature<NoFeatureConfig> SCALDING_MONKEY_BRUSH = new DirectionalFlowersFeature(NoFeatureConfig::func_214639_a, 3);
    public static final Feature<TreeFeatureConfig> ROSEWOOD_TREE = new RosewoodTreeFeature(TreeFeatureConfig::func_227338_a_);
    public static final Feature<TreeFeatureConfig> YUCCA_TREE = new YuccaTreeFeature(TreeFeatureConfig::func_227338_a_, false, false);
    public static final Feature<TreeFeatureConfig> PETRIFIED_YUCCA_TREE = new YuccaTreeFeature(TreeFeatureConfig::func_227338_a_, false, true);
    public static final Feature<TreeFeatureConfig> YUCCA_TREE_PATCH = new YuccaTreeFeature(TreeFeatureConfig::func_227338_a_, true, false);
    public static final Feature<TreeFeatureConfig> BABY_YUCCA_TREE = new BabyYuccaTreeFeature(TreeFeatureConfig::func_227338_a_, false);
    public static final Feature<TreeFeatureConfig> BABY_YUCCA_TREE_PATCH = new BabyYuccaTreeFeature(TreeFeatureConfig::func_227338_a_, true);
    public static final Feature<TreeFeatureConfig> KOUSA_TREE = new FancyTreeFeature(TreeFeatureConfig::func_227338_a_);
    public static final Feature<TreeFeatureConfig> ASPEN_TREE = new TreeFeature(TreeFeatureConfig::func_227338_a_);
    public static final Feature<HugeTreeFeatureConfig> MEGA_ASPEN_TREE = new MegaPineTree(HugeTreeFeatureConfig::deserializeSpruce);
    public static final Feature<NoFeatureConfig> PASSION_VINE = new PassionVineFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<BlockClusterFeatureConfig> BARREL_CACTUS = new BarrelCactusFeature(BlockClusterFeatureConfig::func_227300_a_);
    public static final Feature<BlockClusterFeatureConfig> ALOE_VERA = new AloeVeraFeature(BlockClusterFeatureConfig::func_227300_a_);
    public static final Feature<BlockClusterFeatureConfig> YUCCA_FLOWER = new YuccaFlowerFeature(BlockClusterFeatureConfig::func_227300_a_);
    public static final Feature<BlockBlobConfig> DUNE_ROCKS = new DuneRocksFeature(BlockBlobConfig::func_214682_a);
    public static final SurfaceBuilder<SurfaceBuilderConfig> DUNES = new DunesSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
    public static final SurfaceBuilder<SurfaceBuilderConfig> WAVEY_DUNES = new WaveyDunesSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
    public static final Structure<NoFeatureConfig> ARID_SHRINE = new AridShrineStructure(NoFeatureConfig::func_214639_a);
    public static final IStructurePieceType ARID_SHRINE_PIECES = AridShrinePieces.Piece::new;

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{(Feature)PODZOL.setRegistryName("atmospheric", "podzol"), (Feature)OAK_BUSH.setRegistryName("atmospheric", "oak_bush"), (Feature)DUNE_ROCKS.setRegistryName("atmospheric", "dune_rocks"), (Feature)SURFACE_FOSSIL.setRegistryName("atmospheric", "surface_fossil"), (Feature)COARSE_DIRT_PATCH.setRegistryName("atmospheric", "coarse_dirt_patch"), (Feature)WARM_MONKEY_BRUSH.setRegistryName("atmospheric", "warm_monkey_brush"), (Feature)HOT_MONKEY_BRUSH.setRegistryName("atmospheric", "hot_monkey_brush"), (Feature)SCALDING_MONKEY_BRUSH.setRegistryName("atmospheric", "scalding_monkey_brush"), (Feature)PASSION_VINE.setRegistryName("atmospheric", "passion_vine"), (Feature)BARREL_CACTUS.setRegistryName("atmospheric", "barrel_cactus"), (Feature)ALOE_VERA.setRegistryName("atmospheric", "aloe_vera"), (Feature)YUCCA_FLOWER.setRegistryName("atmospheric", "yucca_flower"), (Feature)ROSEWOOD_TREE.setRegistryName("atmospheric", "rosewood_tree"), (Feature)YUCCA_TREE.setRegistryName("atmospheric", "yucca_tree"), (Feature)PETRIFIED_YUCCA_TREE.setRegistryName("atmospheric", "petrified_yucca_tree"), (Feature)YUCCA_TREE_PATCH.setRegistryName("atmospheric", "yucca_tree_patch"), (Feature)BABY_YUCCA_TREE.setRegistryName("atmospheric", "baby_yucca_tree"), (Feature)BABY_YUCCA_TREE_PATCH.setRegistryName("atmospheric", "baby_yucca_tree_patch"), (Feature)ARID_SHRINE.setRegistryName("atmospheric", "run_down_house")});
        AtmosphericFeatures.register(ARID_SHRINE_PIECES, "ARID_SHRINE_PIECES");
    }

    public static void addCarvables() {
        HashSet<IForgeRegistryEntry> allBlocksToCarve = new HashSet<IForgeRegistryEntry>();
        allBlocksToCarve.add(AtmosphericBlocks.ARID_SAND.get());
        allBlocksToCarve.add(AtmosphericBlocks.ARID_SANDSTONE.get());
        allBlocksToCarve.add(AtmosphericBlocks.RED_ARID_SAND.get());
        allBlocksToCarve.add(AtmosphericBlocks.RED_ARID_SANDSTONE.get());
        for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
            for (ConfiguredCarver carver : ((Biome)AtmosphericBiomes.DUNES.get()).func_203603_a(carverStage)) {
                allBlocksToCarve.addAll(carver.field_222732_a.field_222718_j);
                carver.field_222732_a.field_222718_j = allBlocksToCarve;
            }
        }
    }

    @SubscribeEvent
    public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SurfaceBuilder[]{(SurfaceBuilder)DUNES.setRegistryName("atmospheric", "dunes_builder"), (SurfaceBuilder)WAVEY_DUNES.setRegistryName("atmospheric", "wavey_dunes")});
    }

    public static void generateFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(AtmosphericFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome == Biomes.field_76769_d || biome == Biomes.field_76786_s) {
            AtmosphericBiomeFeatures.addYuccaTrees(biome, 0, 0.005f, 1, false);
        }
        if (biome == Biomes.field_185438_aj || biome == Biomes.field_150607_aa) {
            AtmosphericBiomeFeatures.addYuccaTrees(biome, 0, 0.25f, 1, false);
        }
        if (biome == Biomes.field_185435_ag || biome == Biomes.field_185436_ah) {
            AtmosphericBiomeFeatures.addYuccaTrees(biome, 0, 0.15f, 1, false);
        }
        if (biome == Biomes.field_185447_Y) {
            biome.func_226711_a_(ARID_SHRINE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    static IStructurePieceType register(IStructurePieceType structurePiece, String key) {
        return (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)key.toLowerCase(Locale.ROOT), (Object)structurePiece);
    }
}

