/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.block;

import com.minecraftabnormals.atmospheric.core.registry.AtmosphericEffects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class AloeGelBlock
extends BreakableBlock {
    public static final BooleanProperty WET = BooleanProperty.func_177716_a((String)"wet");

    public AloeGelBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WET, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)WET) != false ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)WET, (Comparable)Boolean.valueOf(this.touchingWater(context.func_195995_a(), (IBlockReader)context.func_195991_k())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WET});
    }

    public boolean causesSuffocation(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean isStickyBlock(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WET) == false;
    }

    public boolean isSlimeBlock(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WET) == false;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        if (other.func_177230_c() == Blocks.field_180399_cE) {
            return false;
        }
        if (other.func_177230_c() == Blocks.field_226907_mc_) {
            return false;
        }
        if (other.func_177230_c() == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("autumnity", "snail_slime_block"))) {
            return false;
        }
        if (other.func_177230_c() == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("upgrade_aquatic", "mulberry_jam_block"))) {
            return false;
        }
        return super.canStickTo(state, other);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.func_206870_a((Property)WET, (Comparable)Boolean.valueOf(this.touchingWater(currentPos, (IBlockReader)worldIn)));
    }

    public final boolean touchingWater(BlockPos blockPos, IBlockReader iBlockReader) {
        for (Direction direction : Direction.values()) {
            if (!iBlockReader.func_204610_c(blockPos.func_177972_a(direction)).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_OTHER;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!((Boolean)state.func_177229_b((Property)WET)).booleanValue()) {
            entity.func_213295_a(state, new Vector3d(0.25, 0.25, 0.25));
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.func_195064_c(new EffectInstance(Effects.field_76436_u, 150, 0, false, true, true));
                living.func_195064_c(new EffectInstance((Effect)AtmosphericEffects.GELLED.get(), 330, 0, false, false, true));
            }
        }
    }
}

