/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.block;

import com.minecraftabnormals.atmospheric.common.block.AloeVeraTallBlock;
import com.minecraftabnormals.atmospheric.common.block.AridSandBlock;
import com.minecraftabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.minecraftabnormals.atmospheric.core.other.AtmosphericDamageSources;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class AloeVeraBlock
extends BushBlock
implements IGrowable {
    public static final VoxelShape SHAPE_SMALL = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape SHAPE_MEDIUM = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final VoxelShape SHAPE_LARGE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final IntegerProperty AGE = BlockStateProperties.field_208169_V;

    public AloeVeraBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        VoxelShape shape = age >= 4 ? SHAPE_LARGE : (age >= 2 ? SHAPE_MEDIUM : SHAPE_SMALL);
        Vector3d vec3d = state.func_191059_e(worldIn, pos);
        return shape.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i > 2 && player.func_184586_b(handIn).func_77973_b() == Items.field_151097_aZ) {
            Random rand = new Random();
            int amount = rand.nextInt(5) + 1;
            if (i == 4) {
                amount = rand.nextInt(5) + 2;
            }
            if (i == 5) {
                amount = rand.nextInt(5) + 3;
            }
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(handIn));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187872_fl, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(2)));
            AloeVeraBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)AtmosphericItems.ALOE_LEAVES.get(), amount));
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !(entityIn instanceof BeeEntity)) {
            double chance = 0.1;
            if ((Integer)state.func_177229_b((Property)AGE) == 3) {
                chance = 0.1;
            }
            if ((Integer)state.func_177229_b((Property)AGE) == 4) {
                chance = 0.2;
            }
            if ((Integer)state.func_177229_b((Property)AGE) == 5) {
                chance = 0.4;
            }
            if (!worldIn.field_72995_K && (Integer)state.func_177229_b((Property)AGE) > 2 && Math.random() <= chance) {
                entityIn.func_213295_a(state, new Vector3d((double)0.2f, 0.2, (double)0.2f));
                entityIn.func_70097_a(AtmosphericDamageSources.ALOE_LEAVES, 1.0f);
                if (entityIn instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
                    if (!entityIn.func_130014_f_().func_201670_d() && !serverplayerentity.func_184812_l_()) {
                        AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.trigger(serverplayerentity);
                    }
                }
            }
        }
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block instanceof AridSandBlock;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 5) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        } else if (world.func_180495_p(pos.func_177984_a()).func_196958_f() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == AtmosphericBlocks.ARID_SAND.get()) {
            this.placeAt((IWorld)world, pos, 2);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int chance;
        super.func_225534_a_(state, worldIn, pos, random);
        boolean flag = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == AtmosphericBlocks.RED_ARID_SAND.get();
        int n = chance = flag ? 8 : 12;
        if (worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 12 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(chance) == 0 ? 1 : 0) != 0)) {
            AloeVeraTallBlock tallAloe;
            if ((Integer)state.func_177229_b((Property)AGE) < 5) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)));
            } else if (!flag && (tallAloe = (AloeVeraTallBlock)AtmosphericBlocks.TALL_ALOE_VERA.get()).func_176223_P().func_196955_c((IWorldReader)worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a())) {
                tallAloe.func_196390_a((IWorld)worldIn, pos, 2);
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    public void placeAt(IWorld world, BlockPos pos, int flags) {
        world.func_180501_a(pos, (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).func_176223_P().func_206870_a((Property)AloeVeraTallBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER), flags);
        world.func_180501_a(pos.func_177984_a(), (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).func_176223_P().func_206870_a((Property)AloeVeraTallBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER), flags);
    }
}

