/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.block;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.abnormals_core.common.blocks.AbnormalsFlowerBlock;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class MonkeyBrushBlock
extends AbnormalsFlowerBlock
implements IGrowable,
IPlantable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private final Supplier<Effect> stewEffect;

    public MonkeyBrushBlock(Supplier<Effect> effect, int effectDuration, AbstractBlock.Properties properties) {
        super(Effects.field_76440_q, effectDuration, properties);
        this.stewEffect = effect;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150458_ak || block.getBlock().func_203417_a((ITag)BlockTags.field_200031_h);
    }

    public Effect func_220094_d() {
        return (Effect)this.stewEffect.get();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vec3d = state.func_191059_e(worldIn, pos);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE;
            }
            case UP: 
        }
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public static VoxelShape func_220289_j(BlockState state) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos blockPos, BlockState state) {
        block0: for (int x = 0; x < 64; ++x) {
            BlockPos newBlockPos = blockPos;
            for (int y = 0; y < x / 16; ++y) {
                if (!state.func_196955_c((IWorldReader)world, newBlockPos = newBlockPos.func_177982_a(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)) || !world.func_175623_d(newBlockPos)) continue;
                Direction randomD = Direction.func_239631_a_((Random)random);
                while (randomD == Direction.DOWN || !((BlockState)state.func_206870_a((Property)FACING, (Comparable)randomD)).func_196955_c((IWorldReader)world, newBlockPos)) {
                    randomD = Direction.func_239631_a_((Random)random);
                }
                world.func_175656_a(newBlockPos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)randomD));
                break block0;
            }
        }
    }
}

