/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core.registry;

import com.minecraftabnormals.atmospheric.common.world.biome.AtmosphericBiomeBuilders;
import com.minecraftabnormals.atmospheric.common.world.biome.dunes.DunesBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.dunes.DunesHillsBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.dunes.FlourishingDunesBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.dunes.PetrifiedDunesBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.dunes.RockyDunesBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.dunes.RockyDunesHillsBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.rainforest.RainforestBasinBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.rainforest.RainforestBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.rainforest.RainforestMountainsBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.rainforest.RainforestPlateauBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.rainforest.SparseRainforestBasinBiome;
import com.minecraftabnormals.atmospheric.common.world.biome.rainforest.SparseRainforestPlateauBiome;
import com.minecraftabnormals.atmospheric.core.AtmosphericConfig;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"atmospheric");
    public static final RegistryObject<Biome> RAINFOREST = BIOMES.register("rainforest", () -> new RainforestBiome(AtmosphericBiomeBuilders.RAINFOREST));
    public static final RegistryObject<Biome> RAINFOREST_MOUNTAINS = BIOMES.register("rainforest_mountains", () -> new RainforestMountainsBiome(AtmosphericBiomeBuilders.RAINFOREST_MOUNTAINS));
    public static final RegistryObject<Biome> RAINFOREST_PLATEAU = BIOMES.register("rainforest_plateau", () -> new RainforestPlateauBiome(AtmosphericBiomeBuilders.RAINFOREST_PLATEAU));
    public static final RegistryObject<Biome> SPARSE_RAINFOREST_PLATEAU = BIOMES.register("sparse_rainforest_plateau", () -> new SparseRainforestPlateauBiome(AtmosphericBiomeBuilders.RAINFOREST_PLATEAU));
    public static final RegistryObject<Biome> RAINFOREST_BASIN = BIOMES.register("rainforest_basin", () -> new RainforestBasinBiome(AtmosphericBiomeBuilders.RAINFOREST_BASIN));
    public static final RegistryObject<Biome> SPARSE_RAINFOREST_BASIN = BIOMES.register("sparse_rainforest_basin", () -> new SparseRainforestBasinBiome(AtmosphericBiomeBuilders.RAINFOREST_BASIN));
    public static final RegistryObject<Biome> DUNES = BIOMES.register("dunes", () -> new DunesBiome(AtmosphericBiomeBuilders.DUNES));
    public static final RegistryObject<Biome> DUNES_HILLS = BIOMES.register("dunes_hills", () -> new DunesHillsBiome(AtmosphericBiomeBuilders.DUNES_HILLS));
    public static final RegistryObject<Biome> FLOURISHING_DUNES = BIOMES.register("flourishing_dunes", () -> new FlourishingDunesBiome(AtmosphericBiomeBuilders.DUNES));
    public static final RegistryObject<Biome> ROCKY_DUNES = BIOMES.register("rocky_dunes", () -> new RockyDunesBiome(AtmosphericBiomeBuilders.ROCKY_DUNES));
    public static final RegistryObject<Biome> ROCKY_DUNES_HILLS = BIOMES.register("rocky_dunes_hills", () -> new RockyDunesHillsBiome(AtmosphericBiomeBuilders.ROCKY_DUNES_HILLS));
    public static final RegistryObject<Biome> PETRIFIED_DUNES = BIOMES.register("petrified_dunes", () -> new PetrifiedDunesBiome(AtmosphericBiomeBuilders.DUNES_HILLS));

    public static void registerBiomesToDictionary() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)RAINFOREST.get(), ((Integer)AtmosphericConfig.COMMON.rainforestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)RAINFOREST_MOUNTAINS.get(), ((Integer)AtmosphericConfig.COMMON.rainforestMountainsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)RAINFOREST_PLATEAU.get(), ((Integer)AtmosphericConfig.COMMON.rainforestPlateauWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)SPARSE_RAINFOREST_PLATEAU.get(), ((Integer)AtmosphericConfig.COMMON.sparseRainforestPlateauWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)RAINFOREST_BASIN.get(), ((Integer)AtmosphericConfig.COMMON.rainforestBasinWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)SPARSE_RAINFOREST_BASIN.get(), ((Integer)AtmosphericConfig.COMMON.sparseRainforestBasinWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)DUNES.get(), ((Integer)AtmosphericConfig.COMMON.dunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)DUNES_HILLS.get(), ((Integer)AtmosphericConfig.COMMON.dunesHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)FLOURISHING_DUNES.get(), ((Integer)AtmosphericConfig.COMMON.flourishingDunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)ROCKY_DUNES.get(), ((Integer)AtmosphericConfig.COMMON.rockyDunesWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)ROCKY_DUNES_HILLS.get(), ((Integer)AtmosphericConfig.COMMON.rockyDunesHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)PETRIFIED_DUNES.get(), ((Integer)AtmosphericConfig.COMMON.petrifiedDunesWeight.get()).intValue()));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((Biome)((Biome)RAINFOREST.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)RAINFOREST_MOUNTAINS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SPARSE_RAINFOREST_PLATEAU.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)RAINFOREST_PLATEAU.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)RAINFOREST_BASIN.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SPARSE_RAINFOREST_BASIN.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)DUNES_HILLS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)FLOURISHING_DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROCKY_DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)ROCKY_DUNES_HILLS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)PETRIFIED_DUNES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OVERWORLD});
    }
}

