/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SurfaceFossilFeature
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation STRUCTURE_SPINE_01 = new ResourceLocation("fossil/spine_1");
    private static final ResourceLocation STRUCTURE_SPINE_02 = new ResourceLocation("fossil/spine_2");
    private static final ResourceLocation STRUCTURE_SPINE_03 = new ResourceLocation("fossil/spine_3");
    private static final ResourceLocation STRUCTURE_SPINE_04 = new ResourceLocation("fossil/spine_4");
    private static final ResourceLocation STRUCTURE_SPINE_01_COAL = new ResourceLocation("fossil/spine_1_coal");
    private static final ResourceLocation STRUCTURE_SPINE_02_COAL = new ResourceLocation("fossil/spine_2_coal");
    private static final ResourceLocation STRUCTURE_SPINE_03_COAL = new ResourceLocation("fossil/spine_3_coal");
    private static final ResourceLocation STRUCTURE_SPINE_04_COAL = new ResourceLocation("fossil/spine_4_coal");
    private static final ResourceLocation STRUCTURE_SKULL_01 = new ResourceLocation("fossil/skull_1");
    private static final ResourceLocation STRUCTURE_SKULL_02 = new ResourceLocation("fossil/skull_2");
    private static final ResourceLocation STRUCTURE_SKULL_03 = new ResourceLocation("fossil/skull_3");
    private static final ResourceLocation STRUCTURE_SKULL_04 = new ResourceLocation("fossil/skull_4");
    private static final ResourceLocation STRUCTURE_SKULL_01_COAL = new ResourceLocation("fossil/skull_1_coal");
    private static final ResourceLocation STRUCTURE_SKULL_02_COAL = new ResourceLocation("fossil/skull_2_coal");
    private static final ResourceLocation STRUCTURE_SKULL_03_COAL = new ResourceLocation("fossil/skull_3_coal");
    private static final ResourceLocation STRUCTURE_SKULL_04_COAL = new ResourceLocation("fossil/skull_4_coal");
    private static final ResourceLocation[] FOSSILS = new ResourceLocation[]{STRUCTURE_SPINE_01, STRUCTURE_SPINE_02, STRUCTURE_SPINE_03, STRUCTURE_SPINE_04, STRUCTURE_SKULL_01, STRUCTURE_SKULL_02, STRUCTURE_SKULL_03, STRUCTURE_SKULL_04};
    private static final ResourceLocation[] FOSSILS_COAL = new ResourceLocation[]{STRUCTURE_SPINE_01_COAL, STRUCTURE_SPINE_02_COAL, STRUCTURE_SPINE_03_COAL, STRUCTURE_SPINE_04_COAL, STRUCTURE_SKULL_01_COAL, STRUCTURE_SKULL_02_COAL, STRUCTURE_SKULL_03_COAL, STRUCTURE_SKULL_04_COAL};

    public SurfaceFossilFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        Rotation rotation = Rotation.func_222466_a((Random)random);
        int i = random.nextInt(FOSSILS.length);
        TemplateManager templatemanager = world.func_201672_e().func_73046_m().func_240792_aT_();
        Template template = templatemanager.func_200220_a(FOSSILS[i]);
        Template template1 = templatemanager.func_200220_a(FOSSILS_COAL[i]);
        ChunkPos chunkpos = new ChunkPos(pos);
        MutableBoundingBox mutableboundingbox = new MutableBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), 256, chunkpos.func_180330_f());
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(mutableboundingbox).func_189950_a(random).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        BlockPos blockpos = template.func_186257_a(rotation);
        int j = random.nextInt(16 - blockpos.func_177958_n());
        int k = random.nextInt(16 - blockpos.func_177952_p());
        int l = 256;
        for (int i1 = 0; i1 < blockpos.func_177958_n(); ++i1) {
            for (int j1 = 0; j1 < blockpos.func_177952_p(); ++j1) {
                l = Math.min(l, world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n() + i1 + j, pos.func_177952_p() + j1 + k));
            }
        }
        int k1 = Math.max(l - 15 - random.nextInt(6), 65);
        BlockPos blockpos1 = template.func_189961_a(pos.func_177982_a(j, k1, k), Mirror.NONE, rotation);
        IntegrityProcessor integrityprocessor = new IntegrityProcessor(0.9f);
        placementsettings.func_215219_b().func_215222_a((StructureProcessor)integrityprocessor);
        template.func_237146_a_((IServerWorld)world, blockpos1, blockpos1, placementsettings, random, 4);
        placementsettings.func_215220_b((StructureProcessor)integrityprocessor);
        IntegrityProcessor integrityprocessor1 = new IntegrityProcessor(0.1f);
        placementsettings.func_215219_b().func_215222_a((StructureProcessor)integrityprocessor1);
        template1.func_237146_a_((IServerWorld)world, blockpos1, blockpos1, placementsettings, random, 4);
        return true;
    }
}

