/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.api.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.github.championash5357.backslot.api.client.renderer.BackRender;
import io.github.championash5357.backslot.api.client.renderer.IBackRender;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackSlotTransformationManager
extends JsonReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(TransformationMatrix.class, (Object)new TransformationHelper.Deserializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private Map<Item, IBackRender> renderers = ImmutableMap.of();
    private static final IBackRender EMPTY = stack -> {};

    public BackSlotTransformationManager() {
        super(GSON, "back_slot");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation location = entry.getKey();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item != null) {
                try {
                    builder.put((Object)item, (Object)new BackRender((TransformationMatrix)GSON.fromJson(entry.getValue(), TransformationMatrix.class)));
                }
                catch (JsonParseException e) {
                    LOGGER.error("Parsing error loading item {}", (Object)location);
                }
                continue;
            }
            throw new NullPointerException("Item " + location + " does not exist!");
        }
        this.renderers = builder.build();
        LOGGER.info("Loaded {} back renders", (Object)this.renderers.size());
    }

    public IBackRender getRender(Item item) {
        return this.renderers.getOrDefault(item, EMPTY);
    }
}

