/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.api.data.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.championash5357.backslot.api.data.client.TransformationBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BackSlotTransformationProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator gen;

    public BackSlotTransformationProvider(DataGenerator gen) {
        this.gen = gen;
    }

    protected abstract void registerTransformations(Consumer<TransformationBuilder> var1);

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path outputFolder = this.gen.func_200391_b();
        HashSet items = new HashSet();
        this.registerTransformations(builder -> {
            if (!items.add(builder.getItemName())) {
                throw new IllegalStateException("Duplicate transformation: " + builder.getItemName());
            }
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)builder.serialize(), (Path)this.resolvePath(outputFolder, builder.getItemName()));
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save transformation {}", (Object)builder.getItemName(), (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "Back Slot Transformations";
    }

    private Path resolvePath(Path path, ResourceLocation item) {
        return path.resolve("assets/" + item.func_110624_b() + "/back_slot/" + item.func_110623_a() + ".json");
    }
}

