/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.client;

import io.github.championash5357.backslot.api.client.ClientConfigHolder;
import io.github.championash5357.backslot.api.client.ClientManagers;
import io.github.championash5357.backslot.client.gui.screen.inventory.BackInventoryScreen;
import io.github.championash5357.backslot.client.gui.widget.button.ExtendedImageButton;
import io.github.championash5357.backslot.client.renderer.entity.layer.PlayerBackItemLayer;
import io.github.championash5357.backslot.common.BackSlotMain;
import io.github.championash5357.backslot.common.ISidedReference;
import io.github.championash5357.backslot.common.init.BSContainerTypes;
import io.github.championash5357.backslot.common.inventory.container.BackInventoryContainer;
import io.github.championash5357.backslot.common.network.client.CProcessActionMessage;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;

public class ClientReference
implements ISidedReference {
    public final KeyBinding swapBackSlot = new KeyBinding("key.backslot.swapbackslot", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 71, "key.backslot.categories.backslot");
    private static final ResourceLocation BACK_SLOT_BUTTON = new ResourceLocation("backslot", "textures/gui/back_button.png");
    private Minecraft mc;

    @Override
    public void setup(IEventBus mod, IEventBus forge) {
        mod.addListener(this::construct);
        mod.addListener(this::clientSetup);
        mod.addListener(this::stitchTexture);
        forge.addListener(this::clientLoggedIn);
        forge.addListener(this::keyInput);
        forge.addListener(this::mouseInput);
        forge.addListener(this::screenInit);
    }

    private void construct(FMLConstructModEvent event) {
        event.enqueueWork(() -> ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)ClientManagers.getTransformationManager()));
    }

    private void clientLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        IModInfo info = ((ModContainer)ModList.get().getModContainerById("backslot").get()).getModInfo();
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)info);
        if (((Boolean)ClientConfigHolder.CLIENT.enableUpdateNotifications.get()).booleanValue() && (result.status == VersionChecker.Status.OUTDATED || result.status == VersionChecker.Status.BETA_OUTDATED)) {
            StringTextComponent clickableVersion = new StringTextComponent(TextFormatting.GOLD + "" + result.target);
            if (info instanceof IConfigurable) {
                ((IConfigurable)info).getConfigElement(new String[]{"displayURL"}).ifPresent(arg_0 -> ClientReference.lambda$clientLoggedIn$1((TextComponent)clickableVersion, arg_0));
            }
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("notification.backslot.outdated", new Object[]{new StringTextComponent(TextFormatting.RED + "Back " + TextFormatting.BLUE + "Slot")}).func_240699_a_(TextFormatting.GRAY), Util.field_240973_b_);
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("notification.backslot.current_version", new Object[]{clickableVersion}).func_240699_a_(TextFormatting.GRAY), Util.field_240973_b_);
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("notification.backslot.changelog").func_240699_a_(TextFormatting.WHITE), Util.field_240973_b_);
            for (Map.Entry entry : result.changes.entrySet()) {
                event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(" - " + TextFormatting.GOLD + entry.getKey() + ": " + TextFormatting.GRAY + (String)entry.getValue()), Util.field_240973_b_);
            }
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.mc = (Minecraft)event.getMinecraftSupplier().get();
        ClientRegistry.registerKeyBinding((KeyBinding)this.swapBackSlot);
        event.enqueueWork(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)BSContainerTypes.BACK_INVENTORY.get()), BackInventoryScreen::new);
            if (((Boolean)ClientConfigHolder.CLIENT.enableRendering.get()).booleanValue()) {
                this.mc.func_175598_ae().getSkinMap().forEach((name, renderer) -> renderer.func_177094_a(new PlayerBackItemLayer(renderer)));
            }
        });
    }

    private void stitchTexture(TextureStitchEvent.Pre event) {
        event.addSprite(BackInventoryContainer.EMPTY_BACK_SLOT);
    }

    private void screenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (((Boolean)ClientConfigHolder.CLIENT.enableGui.get()).booleanValue()) {
            Screen screen = event.getGui();
            if (screen instanceof InventoryScreen) {
                event.addWidget((Widget)new ExtendedImageButton((ContainerScreen)screen, (Integer)ClientConfigHolder.CLIENT.xOffset.get(), (Integer)ClientConfigHolder.CLIENT.yOffset.get(), 17, 17, 17, 34, 0, 0, 17, BACK_SLOT_BUTTON, (ITextComponent)new TranslationTextComponent("widget.backslot.to_back_button"), false, button -> BackSlotMain.NETWORK.sendToServer((Object)new CProcessActionMessage(2)), (button, stack, x, y) -> event.getGui().func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("widget.backslot.to_back_button"), x, y)));
            } else if (event.getGui() instanceof BackInventoryScreen) {
                event.addWidget((Widget)new ExtendedImageButton((ContainerScreen)screen, (Integer)ClientConfigHolder.CLIENT.xOffset.get(), (Integer)ClientConfigHolder.CLIENT.yOffset.get(), 17, 17, 17, 34, 0, 0, 17, BACK_SLOT_BUTTON, (ITextComponent)new TranslationTextComponent("widget.backslot.to_front_button"), true, button -> {
                    BackSlotMain.NETWORK.sendToServer((Object)new CProcessActionMessage(3));
                    screen.getMinecraft().func_147108_a((Screen)new InventoryScreen((PlayerEntity)screen.getMinecraft().field_71439_g));
                }, (button, stack, x, y) -> event.getGui().func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("widget.backslot.to_front_button"), x, y)));
            }
        }
    }

    private void keyInput(InputEvent.KeyInputEvent event) {
        if (this.mc.field_71439_g != null && !this.mc.field_71439_g.func_175149_v() && this.swapBackSlot.func_151468_f()) {
            BackSlotMain.NETWORK.sendToServer((Object)new CProcessActionMessage(1));
        }
    }

    private void mouseInput(InputEvent.MouseInputEvent event) {
        if (this.mc.field_71439_g != null && !this.mc.field_71439_g.func_175149_v() && this.swapBackSlot.func_151468_f()) {
            BackSlotMain.NETWORK.sendToServer((Object)new CProcessActionMessage(1));
        }
    }

    private static /* synthetic */ void lambda$clientLoggedIn$1(TextComponent clickableVersion, Object url) {
        if (url instanceof String) {
            clickableVersion.func_230530_a_(clickableVersion.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url)));
        }
    }
}

