/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.common;

import io.github.championash5357.backslot.api.client.ClientConfigHolder;
import io.github.championash5357.backslot.api.common.capability.CapabilityInstances;
import io.github.championash5357.backslot.api.common.capability.IBackSlot;
import io.github.championash5357.backslot.client.ClientReference;
import io.github.championash5357.backslot.common.ISidedReference;
import io.github.championash5357.backslot.common.capability.CapabilityProviderSerializable;
import io.github.championash5357.backslot.common.capability.backslot.CapabilityBackSlot;
import io.github.championash5357.backslot.common.init.BSCapabilities;
import io.github.championash5357.backslot.common.init.BSContainerTypes;
import io.github.championash5357.backslot.common.network.BSNetwork;
import io.github.championash5357.backslot.common.network.server.SUpdateBackSlotMessage;
import io.github.championash5357.backslot.data.client.BSLanguageProvider;
import io.github.championash5357.backslot.data.client.BSTransformationProvider;
import io.github.championash5357.backslot.server.dedicated.DedicatedServerReference;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="backslot")
public class BackSlotMain {
    public static final String ID = "backslot";
    public static final ISidedReference SIDED_SYSTEM = (ISidedReference)DistExecutor.safeRunForDist(() -> ClientReference::new, () -> DedicatedServerReference::new);
    public static final SimpleChannel NETWORK = BSNetwork.network();
    private static final String[] LOCALE_CODES = new String[]{"en_us"};

    public BackSlotMain() {
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forge = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfigHolder.CLIENT_SPEC);
        this.addRegistries(mod);
        mod.addListener(this::setup);
        SIDED_SYSTEM.setup(mod, forge);
        forge.addGenericListener(Entity.class, this::attach);
        forge.addListener(EventPriority.LOWEST, this::entityJoin);
        forge.addListener(this::playerJoin);
        forge.addListener(EventPriority.LOWEST, this::dimensionChanged);
        forge.addListener(this::playerDimensionChanged);
        forge.addListener(EventPriority.LOWEST, this::livingDeath);
        forge.addListener(this::onEntityTrack);
        forge.addListener(this::clonePlayer);
        forge.addListener(this::respawnPlayer);
        mod.addListener(this::data);
    }

    private void setup(FMLCommonSetupEvent event) {
        BSCapabilities.register();
    }

    private void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(CapabilityBackSlot.BACK_SLOT, new CapabilityProviderSerializable<IBackSlot>(CapabilityInstances.BACK_SLOT_CAPABILITY, null).attachListeners(arg_0 -> event.addListener(arg_0)));
        }
    }

    private void dimensionChanged(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof LivingEntity && !event.getEntity().field_70170_p.field_72995_K && !event.isCanceled()) {
            this.sendPacket((LivingEntity)event.getEntity());
        }
    }

    private void playerDimensionChanged(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer().func_70613_aW()) {
            this.sendPacket(event.getEntityLiving());
        }
    }

    private void clonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || event.getPlayer().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || event.getOriginal().func_175149_v()) {
            event.getOriginal().getCapability(CapabilityInstances.BACK_SLOT_CAPABILITY).ifPresent(originalBackSlot -> event.getPlayer().getCapability(CapabilityInstances.BACK_SLOT_CAPABILITY).ifPresent(newBackSlot -> newBackSlot.setBackStack(originalBackSlot.getBackStack())));
        }
    }

    private void respawnPlayer(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer().func_70613_aW()) {
            this.sendPacket(event.getEntityLiving());
        }
    }

    private void livingDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getEntityLiving().func_70613_aW()) {
            LivingEntity entity = event.getEntityLiving();
            if (entity instanceof PlayerEntity && (entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || entity.func_175149_v())) {
                return;
            }
            if (!(entity instanceof PlayerEntity) && !entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                return;
            }
            event.getEntityLiving().getCapability(CapabilityInstances.BACK_SLOT_CAPABILITY).ifPresent(backSlot -> InventoryHelper.func_180173_a((World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ItemStack)backSlot.getBackStack()));
        }
    }

    private void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().func_70613_aW()) {
            this.sendPacket(event.getEntityLiving());
        }
    }

    private void entityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof LivingEntity && !event.getWorld().field_72995_K && !event.isCanceled()) {
            this.sendPacket((LivingEntity)event.getEntity());
        }
    }

    private void onEntityTrack(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof LivingEntity && event.getPlayer().func_70613_aW()) {
            this.sendPacket((ServerPlayerEntity)event.getPlayer(), (LivingEntity)event.getTarget());
        }
    }

    private void sendPacket(ServerPlayerEntity entity, LivingEntity tracked) {
        tracked.getCapability(CapabilityInstances.BACK_SLOT_CAPABILITY).ifPresent(backSlot -> NETWORK.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new SUpdateBackSlotMessage(tracked.func_145782_y(), backSlot.getBackStack())));
    }

    private void sendPacket(LivingEntity entity) {
        entity.getCapability(CapabilityInstances.BACK_SLOT_CAPABILITY).ifPresent(backSlot -> NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SUpdateBackSlotMessage(entity.func_145782_y(), backSlot.getBackStack())));
    }

    private void addRegistries(IEventBus mod) {
        BSContainerTypes.CONTAINER_TYPES.register(mod);
    }

    private void data(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            this.addLanguageProviders(gen);
            gen.func_200390_a((IDataProvider)new BSTransformationProvider(gen));
        }
    }

    private void addLanguageProviders(DataGenerator gen) {
        for (String locale : LOCALE_CODES) {
            gen.func_200390_a((IDataProvider)new BSLanguageProvider(gen, locale));
        }
    }
}

