/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.api.data.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class TransformationBuilder {
    private ResourceLocation location;
    @Nullable
    private Vector3f translation;
    @Nullable
    private Vector3f scale;
    @Nullable
    private Vector3f rotation;
    @Nullable
    private Vector3f postRotation;

    public TransformationBuilder() {
    }

    private TransformationBuilder(ResourceLocation location) {
        this.location = location;
    }

    public static TransformationBuilder transformItem(Item item) {
        return new TransformationBuilder(item.getRegistryName());
    }

    public TransformationBuilder translate(float x, float y, float z) {
        this.translation = new Vector3f(x, y, z);
        return this;
    }

    public TransformationBuilder translate(Vector3f vec3f) {
        this.translation = vec3f.func_229195_e_();
        return this;
    }

    public TransformationBuilder rotate(float x, float y, float z) {
        this.rotation = new Vector3f(x, y, z);
        return this;
    }

    public TransformationBuilder rotate(Vector3f vec3f) {
        this.rotation = vec3f.func_229195_e_();
        return this;
    }

    public TransformationBuilder scale(float x, float y, float z) {
        this.scale = new Vector3f(x, y, z);
        return this;
    }

    public TransformationBuilder scale(Vector3f vec3f) {
        this.scale = vec3f.func_229195_e_();
        return this;
    }

    public TransformationBuilder postRotation(float x, float y, float z) {
        this.postRotation = new Vector3f(x, y, z);
        return this;
    }

    public TransformationBuilder postRotation(Vector3f vec3f) {
        this.postRotation = vec3f.func_229195_e_();
        return this;
    }

    public void build(Consumer<TransformationBuilder> consumer) {
        if (this.translation == null && this.scale == null && this.rotation == null && this.postRotation == null) {
            throw new IllegalArgumentException("There were no changes made to " + this.location);
        }
        consumer.accept(this);
    }

    protected ResourceLocation getItemName() {
        return this.location;
    }

    protected JsonElement serialize() {
        JsonArray list;
        JsonObject parent = new JsonObject();
        if (this.translation != null) {
            list = new JsonArray();
            list.add((Number)Float.valueOf(this.translation.func_195899_a()));
            list.add((Number)Float.valueOf(this.translation.func_195900_b()));
            list.add((Number)Float.valueOf(this.translation.func_195902_c()));
            parent.add("translation", (JsonElement)list);
        }
        if (this.rotation != null) {
            list = new JsonArray();
            list.add((Number)Float.valueOf(this.rotation.func_195899_a()));
            list.add((Number)Float.valueOf(this.rotation.func_195900_b()));
            list.add((Number)Float.valueOf(this.rotation.func_195902_c()));
            parent.add("rotation", (JsonElement)list);
        }
        if (this.scale != null) {
            list = new JsonArray();
            list.add((Number)Float.valueOf(this.scale.func_195899_a()));
            list.add((Number)Float.valueOf(this.scale.func_195900_b()));
            list.add((Number)Float.valueOf(this.scale.func_195902_c()));
            parent.add("scale", (JsonElement)list);
        }
        if (this.postRotation != null) {
            list = new JsonArray();
            list.add((Number)Float.valueOf(this.postRotation.func_195899_a()));
            list.add((Number)Float.valueOf(this.postRotation.func_195900_b()));
            list.add((Number)Float.valueOf(this.postRotation.func_195902_c()));
            parent.add("post-rotation", (JsonElement)list);
        }
        return parent;
    }
}

