/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class BlitUtils {
    private int blitOffset;

    public static void reverseBlit(MatrixStack matrixStack, int x, int y, int reverseBlitOffset, int width, int height, TextureAtlasSprite sprite) {
        BlitUtils.innerReverseBlit(matrixStack.func_227866_c_().func_227870_a_(), x, x + width, y, y + height, reverseBlitOffset, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
    }

    public void reverseBlit(MatrixStack matrixStack, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        BlitUtils.reverseBlit(matrixStack, x, y, this.blitOffset, uOffset, vOffset, uWidth, vHeight, 256, 256);
    }

    public static void reverseBlit(MatrixStack matrixStack, int x, int y, int reverseBlitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureHeight, int textureWidth) {
        BlitUtils.innerReverseBlit(matrixStack, x, x + uWidth, y, y + vHeight, reverseBlitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void reverseBlit(MatrixStack matrixStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        BlitUtils.innerReverseBlit(matrixStack, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void reverseBlit(MatrixStack matrixStack, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        BlitUtils.reverseBlit(matrixStack, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    private static void innerReverseBlit(MatrixStack matrixStack, int x1, int x2, int y1, int y2, int reverseBlitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        BlitUtils.innerReverseBlit(matrixStack.func_227866_c_().func_227870_a_(), x1, x2, y1, y2, reverseBlitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    private static void innerReverseBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, int reverseBlitOffset, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)reverseBlitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)reverseBlitOffset).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)reverseBlitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)reverseBlitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public void setBlitOffset(int value) {
        this.blitOffset = value;
    }
}

