/*
 * Decompiled with CFR 0.152.
 */
package io.github.championash5357.backslot.common.capability.backslot;

import io.github.championash5357.backslot.api.common.capability.IBackSlot;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class BackSlot
implements IBackSlot {
    private ItemStack stack;

    public BackSlot() {
        this(ItemStack.field_190927_a);
    }

    public BackSlot(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public void setBackStack(@Nonnull ItemStack stack) {
        this.stack = stack;
        this.onContentsChanged();
    }

    @Override
    @Nonnull
    public ItemStack getBackStack() {
        return this.stack;
    }

    public void onContentsChanged() {
    }

    @Override
    @Nonnull
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(stack)) {
            return stack;
        }
        ItemStack existing = this.stack;
        int limit = this.getStackLimit(stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stack = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    protected int getStackLimit(@Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(), stack.func_77976_d());
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.stack;
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stack = ItemStack.field_190927_a;
                this.onContentsChanged();
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.stack = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract));
            this.onContentsChanged();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    @Override
    public int getSlotLimit() {
        return 64;
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return true;
    }
}

