/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.beebarker.common.core;

import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.beebarker.common.BeeBarker;
import me.ichun.mods.beebarker.common.core.BarkHelper;
import me.ichun.mods.beebarker.common.entity.EntityBee;
import me.ichun.mods.beebarker.common.item.ItemBeeBarker;
import me.ichun.mods.beebarker.common.packet.PacketSpawnParticles;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandlerServer {
    public static final String BARKABLE_STRING = "BeeBarker_barkable";
    public static final String BEE_HIGHEST_CHARGE = "BeeBarker_beeHighestCharge";
    public static final String BEE_CHARGE_STRING = "BeeBarker_beeCharge";

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        BeeBarker.itemBeeBarker = ((Item)new ItemBeeBarker().func_77664_n().setRegistryName(new ResourceLocation("beebarker", "bee_barker"))).func_77655_b("beebarker.bee_barker").func_77637_a(CreativeTabs.field_78040_i);
        event.getRegistry().register((IForgeRegistryEntry)BeeBarker.itemBeeBarker);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)event.getPlayer());
        if (is.func_77973_b() instanceof ItemBeeBarker) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack is = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (is.func_77973_b() instanceof ItemBeeBarker) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityZombie zombie;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityZombie && (zombie = (EntityZombie)event.getEntityLiving()).func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == BeeBarker.itemBeeBarker && zombie.func_70681_au().nextFloat() < 0.008f) {
            BarkHelper.bark((EntityLivingBase)zombie);
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        EntityWolf wolf;
        NBTTagCompound wolfData;
        if (event.getEntity() instanceof EntityWolf && event.getSound() == SoundEvents.field_187857_gE && !event.getEntity().field_70170_p.field_72995_K && (wolfData = (wolf = (EntityWolf)event.getEntity()).getEntityData()).func_74767_n(BARKABLE_STRING) && wolf.func_70681_au().nextFloat() < 0.05f) {
            for (int i = 0; i < wolf.func_70681_au().nextInt(5) + 1; ++i) {
                wolf.field_70170_p.func_72838_d((Entity)new EntityBee(wolf.field_70170_p, (EntityLivingBase)wolf));
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityWolf wolf;
        if (event.getTarget() instanceof EntityWolf && (wolf = (EntityWolf)event.getTarget()).func_70909_n() && !wolf.func_82150_aj() && wolf.func_70902_q() == event.getEntityPlayer() && !event.getEntityPlayer().func_70093_af()) {
            NBTTagCompound wolfData;
            ItemStack is = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
            boolean forestryCheck = false;
            if (BeeBarker.isForestryInstalled) {
                try {
                    Class<?> clz = Class.forName("forestry.apiculture.items.ItemBeeGE");
                    if (clz.isInstance(is.func_77973_b())) {
                        forestryCheck = true;
                    }
                }
                catch (ClassNotFoundException clz) {
                    // empty catch block
                }
            }
            if (is.func_190926_b()) {
                wolfData = wolf.getEntityData();
                if (wolfData.func_74767_n(BARKABLE_STRING)) {
                    if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
                        NBTTagCompound wolfTag = new NBTTagCompound();
                        wolfData.func_74768_a(BEE_HIGHEST_CHARGE, wolfData.func_74762_e(BEE_CHARGE_STRING));
                        wolf.func_70904_g(false);
                        wolf.func_70039_c(wolfTag);
                        ItemStack wolfStack = new ItemStack(BeeBarker.itemBeeBarker, 1, wolfData.func_74767_n("IsSuperBeeDog") ? 0 : (wolfData.func_74762_e(BEE_CHARGE_STRING) == 0 ? 250 : 1));
                        wolfStack.func_77982_d(new NBTTagCompound());
                        wolfStack.func_77978_p().func_74782_a("WolfData", (NBTBase)wolfTag);
                        event.getEntityPlayer().func_184611_a(EnumHand.MAIN_HAND, wolfStack);
                        event.getEntityPlayer().field_71071_by.func_70296_d();
                        wolf.func_70106_y();
                    }
                    event.setCanceled(true);
                }
            } else if (Block.func_149634_a((Item)is.func_77973_b()) instanceof BlockFlower || forestryCheck) {
                wolfData = wolf.getEntityData();
                if (!event.getEntityPlayer().field_70170_p.field_72995_K && !event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                    if (is.func_190926_b()) {
                        event.getEntityPlayer().field_71071_by.field_70462_a.set(event.getEntityPlayer().field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                        event.getEntityPlayer().field_71071_by.func_70296_d();
                    }
                }
                if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
                    float chance;
                    float f = chance = forestryCheck ? 0.0f : event.getEntityPlayer().func_70681_au().nextFloat();
                    if (wolfData.func_74767_n("IsSuperBeeDog") || wolfData.func_74767_n(BARKABLE_STRING) && wolfData.func_74762_e(BEE_CHARGE_STRING) >= BeeBarker.config.maxBeeCharge) {
                        wolf.func_184185_a(SoundEvents.field_187871_gL, 0.4f, (wolf.func_70681_au().nextFloat() - wolf.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                    } else {
                        if (chance < (float)BeeBarker.config.beeBarkerChance / 100.0f) {
                            BeeBarker.channel.sendToAllAround((AbstractPacket)new PacketSpawnParticles(wolf.func_145782_y(), event.getEntityPlayer().func_145782_y(), false), new NetworkRegistry.TargetPoint(wolf.field_71093_bK, wolf.field_70165_t, wolf.field_70163_u, wolf.field_70161_v, 64.0));
                            wolfData.func_74757_a(BARKABLE_STRING, true);
                            wolfData.func_74768_a(BEE_CHARGE_STRING, wolfData.func_74762_e(BEE_CHARGE_STRING) + 1);
                            wolfData.func_74768_a(BEE_HIGHEST_CHARGE, wolfData.func_74762_e(BEE_CHARGE_STRING));
                        } else {
                            BeeBarker.channel.sendToAllAround((AbstractPacket)new PacketSpawnParticles(wolf.func_145782_y(), event.getEntityPlayer().func_145782_y(), true), new NetworkRegistry.TargetPoint(wolf.field_71093_bK, wolf.field_70165_t, wolf.field_70163_u, wolf.field_70161_v, 64.0));
                        }
                        wolf.func_184185_a(SoundEvents.field_187739_dZ, 0.3f, 1.0f + (wolf.func_70681_au().nextFloat() - wolf.func_70681_au().nextFloat()) * 0.2f);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            for (int i = event.getDrops().size() - 1; i >= 0; --i) {
                if (!EventHandlerServer.spawnWolfFromItem(null, (EntityItem)event.getDrops().get(i), null)) continue;
                event.getDrops().remove(i);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && EventHandlerServer.spawnWolfFromItem(event.getPlayer(), event.getEntityItem(), (EntityLivingBase)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<String, Integer>> ite = BarkHelper.cooldown.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, Integer> e = ite.next();
                if (e.getValue() > 0) {
                    EntityPlayerMP player;
                    if (e.getValue() > 120 && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(e.getKey())) != null) {
                        BeeBarker.channel.sendToAllAround((AbstractPacket)new PacketSpawnParticles(-1, player.func_145782_y(), true), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
                    }
                    e.setValue(e.getValue() - 2);
                    continue;
                }
                ite.remove();
            }
            for (int i = BarkHelper.pressState.size() - 1; i >= 0; --i) {
                String name = BarkHelper.pressState.get(i);
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
                if (player != null) {
                    ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)player);
                    if (is.func_77973_b() == BeeBarker.itemBeeBarker && is.func_77978_p() != null && is.func_77978_p().func_74764_b("WolfData") && BeeBarker.config.easterEgg == 1 && ((NBTTagCompound)is.func_77978_p().func_74781_a("WolfData")).func_74764_b("CustomName") && ((NBTTagCompound)is.func_77978_p().func_74781_a("WolfData")).func_74779_i("CustomName").equals("iChun")) {
                        if (player.field_70173_aa % 4 == 0) {
                            RayTraceResult mop = EntityHelper.getEntityLook((Entity)player, (double)6.0);
                            if (mop.field_72313_a == RayTraceResult.Type.ENTITY && !mop.field_72308_g.func_70045_F()) {
                                mop.field_72308_g.func_70015_d(2);
                                mop.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("beeburnt", mop.field_72308_g, (Entity)player).func_76361_j(), 2.0f);
                            }
                        }
                        if (player.field_70173_aa % 13 != 0) continue;
                        EntityHelper.playSoundAtEntity((Entity)player, (SoundEvent)SoundEvents.field_187865_gI, (SoundCategory)SoundCategory.PLAYERS, (float)0.6f, (float)1.0f);
                        continue;
                    }
                    BarkHelper.removePressState(name);
                    continue;
                }
                BarkHelper.removePressState(name);
            }
        }
    }

    public static boolean spawnWolfFromItem(EntityPlayer player, EntityItem item, EntityLivingBase dropper) {
        ItemStack is = item.func_92059_d();
        if (is.func_77973_b() instanceof ItemBeeBarker && is.func_77978_p() != null && is.func_77978_p().func_74764_b("WolfData")) {
            Entity ent;
            if (!((NBTTagCompound)is.func_77978_p().func_74781_a("WolfData")).func_74764_b("id")) {
                EntityWolf wolf = (EntityWolf)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("minecraft", "wolf"), (World)item.field_70170_p);
                if (player != null) {
                    wolf.func_184754_b(player.func_146103_bH().getId());
                    wolf.func_70903_f(true);
                    wolf.func_175547_a(EnumDyeColor.RED);
                }
                if (((NBTTagCompound)is.func_77978_p().func_74781_a("WolfData")).func_74764_b("CustomName")) {
                    wolf.func_175547_a(EnumDyeColor.BLUE);
                    wolf.func_96094_a(((NBTTagCompound)is.func_77978_p().func_74781_a("WolfData")).func_74779_i("CustomName"));
                }
                wolf.func_70606_j(20.0f);
                wolf.getEntityData().func_74757_a(BARKABLE_STRING, true);
                wolf.getEntityData().func_74757_a("IsSuperBeeDog", true);
                NBTTagCompound wolfTag = new NBTTagCompound();
                wolf.func_70039_c(wolfTag);
                is.func_77978_p().func_74782_a("WolfData", (NBTBase)wolfTag);
            }
            if ((ent = EntityList.func_75615_a((NBTTagCompound)((NBTTagCompound)is.func_77978_p().func_74781_a("WolfData")), (World)item.field_70170_p)) instanceof EntityWolf) {
                if (dropper != null) {
                    ent.func_70012_b(item.field_70165_t, item.field_70163_u, item.field_70161_v, dropper.field_70177_z, dropper.field_70125_A);
                } else {
                    ent.func_70107_b(item.field_70165_t, item.field_70163_u, item.field_70161_v);
                }
                ent.field_70159_w = item.field_70159_w;
                ent.field_70181_x = item.field_70181_x;
                ent.field_70179_y = item.field_70179_y;
                ent.field_70143_R = 0.0f;
                ent.field_70170_p.func_72838_d(ent);
                return true;
            }
        }
        return false;
    }
}

