/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.beebarker.common.core;

import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.beebarker.common.BeeBarker;
import me.ichun.mods.beebarker.common.core.BarkHelper;
import me.ichun.mods.beebarker.common.entity.EntityBee;
import me.ichun.mods.beebarker.common.goal.FlowerBegGoal;
import me.ichun.mods.beebarker.common.item.ItemBeeBarker;
import me.ichun.mods.beebarker.common.packet.PacketSpawnParticles;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.DualHandedItem;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.BegGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class EventHandlerServer {
    public static final String BARKABLE_STRING = "BeeBarker_barkable";
    public static final String BEE_HIGHEST_CHARGE = "BeeBarker_beeHighestCharge";
    public static final String BEE_CHARGE_STRING = "BeeBarker_beeCharge";

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack is = DualHandedItem.getUsableDualHandedItem((LivingEntity)event.getPlayer());
        if (is.func_77973_b() instanceof ItemBeeBarker) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack is = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
        if (is.func_77973_b() == BeeBarker.Items.BEE_BARKER.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ZombieEntity zombie;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof ZombieEntity && (zombie = (ZombieEntity)event.getEntityLiving()).func_184586_b(Hand.MAIN_HAND).func_77973_b() == BeeBarker.Items.BEE_BARKER.get() && zombie.func_70681_au().nextFloat() < 0.008f) {
            BarkHelper.bark((LivingEntity)zombie);
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        WolfEntity wolf;
        CompoundNBT wolfData;
        if (event.getEntity() instanceof WolfEntity && event.getSound() == SoundEvents.field_187857_gE && !event.getEntity().field_70170_p.field_72995_K && (wolfData = (wolf = (WolfEntity)event.getEntity()).getPersistentData()).func_74767_n(BARKABLE_STRING) && wolf.func_70681_au().nextFloat() < 0.05f) {
            for (int i = 0; i < wolf.func_70681_au().nextInt(5) + 1; ++i) {
                wolf.field_70170_p.func_217376_c((Entity)((EntityBee)((EntityType)BeeBarker.EntityTypes.BEE.get()).func_200721_a(wolf.field_70170_p)).setShooter((LivingEntity)wolf));
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        WolfEntity wolf;
        if (event.getTarget() instanceof WolfEntity && (wolf = (WolfEntity)event.getTarget()).func_70909_n() && !wolf.func_82150_aj() && wolf.func_70902_q() == event.getPlayer() && !event.getPlayer().func_225608_bj_()) {
            CompoundNBT wolfData;
            ItemStack is = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
            boolean forestryCheck = false;
            if (BeeBarker.isForestryInstalled) {
                try {
                    Class<?> clz = Class.forName("forestry.apiculture.items.ItemBeeGE");
                    if (clz.isInstance(is.func_77973_b())) {
                        forestryCheck = true;
                    }
                }
                catch (ClassNotFoundException clz) {
                    // empty catch block
                }
            }
            if (is.func_190926_b()) {
                wolfData = wolf.getPersistentData();
                if (wolfData.func_74767_n(BARKABLE_STRING)) {
                    if (!event.getPlayer().field_70170_p.field_72995_K) {
                        CompoundNBT wolfTag = new CompoundNBT();
                        wolfData.func_74768_a(BEE_HIGHEST_CHARGE, wolfData.func_74762_e(BEE_CHARGE_STRING));
                        wolf.func_233686_v_(false);
                        wolf.func_184198_c(wolfTag);
                        ItemStack wolfStack = new ItemStack((IItemProvider)BeeBarker.Items.BEE_BARKER.get());
                        wolfStack.func_196085_b(wolfData.func_74767_n("IsSuperBeeDog") ? 0 : (wolfData.func_74762_e(BEE_CHARGE_STRING) == 0 ? 250 : 1));
                        wolfStack.func_77982_d(new CompoundNBT());
                        wolfStack.func_77978_p().func_218657_a("WolfData", (INBT)wolfTag);
                        event.getPlayer().func_184611_a(Hand.MAIN_HAND, wolfStack);
                        event.getPlayer().field_71071_by.func_70296_d();
                        wolf.func_70106_y();
                    }
                    event.setCanceled(true);
                }
            } else if (Block.func_149634_a((Item)is.func_77973_b()) instanceof FlowerBlock || forestryCheck) {
                wolfData = wolf.getPersistentData();
                if (!event.getPlayer().field_70170_p.field_72995_K && !event.getPlayer().field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                    if (is.func_190926_b()) {
                        event.getPlayer().field_71071_by.field_70462_a.set(event.getPlayer().field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                        event.getPlayer().field_71071_by.func_70296_d();
                    }
                }
                if (!event.getPlayer().field_70170_p.field_72995_K) {
                    float chance;
                    float f = chance = forestryCheck ? 0.0f : event.getPlayer().func_70681_au().nextFloat();
                    if (wolfData.func_74767_n("IsSuperBeeDog") || wolfData.func_74767_n(BARKABLE_STRING) && wolfData.func_74762_e(BEE_CHARGE_STRING) >= BeeBarker.configCommon.maxBeeCharge) {
                        wolf.func_184185_a(SoundEvents.field_187871_gL, 0.4f, (wolf.func_70681_au().nextFloat() - wolf.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                    } else {
                        if (chance < (float)BeeBarker.configCommon.beeBarkerChance / 100.0f) {
                            BeeBarker.channel.sendTo((AbstractPacket)new PacketSpawnParticles(wolf.func_145782_y(), event.getPlayer().func_145782_y(), false), PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(wolf.func_226277_ct_(), wolf.func_226278_cu_(), wolf.func_226281_cx_(), 64.0, wolf.field_70170_p.func_234923_W_())));
                            wolfData.func_74757_a(BARKABLE_STRING, true);
                            wolfData.func_74768_a(BEE_CHARGE_STRING, wolfData.func_74762_e(BEE_CHARGE_STRING) + 1);
                            wolfData.func_74768_a(BEE_HIGHEST_CHARGE, wolfData.func_74762_e(BEE_CHARGE_STRING));
                        } else {
                            BeeBarker.channel.sendTo((AbstractPacket)new PacketSpawnParticles(wolf.func_145782_y(), event.getPlayer().func_145782_y(), true), PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(wolf.func_226277_ct_(), wolf.func_226278_cu_(), wolf.func_226281_cx_(), 64.0, wolf.field_70170_p.func_234923_W_())));
                        }
                        wolf.func_184185_a(SoundEvents.field_187739_dZ, 0.3f, 1.0f + (wolf.func_70681_au().nextFloat() - wolf.func_70681_au().nextFloat()) * 0.2f);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getEntity() instanceof WolfEntity) {
                WolfEntity wolf = (WolfEntity)event.getEntity();
                for (PrioritizedGoal goal : wolf.field_70714_bg.field_220892_d) {
                    if (!(goal.field_220774_a instanceof BegGoal)) continue;
                    goal.field_220774_a = new FlowerBegGoal((BegGoal)goal.field_220774_a);
                }
            } else if (event.getEntity() instanceof ItemEntity && EventHandlerServer.spawnWolfFromItem(null, (ItemEntity)event.getEntity(), null)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            event.getDrops().removeIf(item -> EventHandlerServer.spawnWolfFromItem(null, item, null));
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && EventHandlerServer.spawnWolfFromItem(event.getPlayer(), event.getEntityItem(), (LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<String, Integer>> ite = BarkHelper.cooldown.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, Integer> e = ite.next();
                if (e.getValue() > 0) {
                    ServerPlayerEntity player;
                    if (e.getValue() > 120 && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(e.getKey())) != null) {
                        BeeBarker.channel.sendTo((AbstractPacket)new PacketSpawnParticles(-1, player.func_145782_y(), true), PacketDistributor.NEAR.with(() -> EventHandlerServer.lambda$onServerTick$3((PlayerEntity)player)));
                    }
                    e.setValue(e.getValue() - 2);
                    continue;
                }
                ite.remove();
            }
            for (int i = BarkHelper.pressState.size() - 1; i >= 0; --i) {
                String name = BarkHelper.pressState.get(i);
                ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(name);
                if (player != null) {
                    ItemStack is = DualHandedItem.getUsableDualHandedItem((LivingEntity)player);
                    if (is.func_77973_b() == BeeBarker.Items.BEE_BARKER.get() && is.func_77978_p() != null && is.func_77978_p().func_74764_b("WolfData") && BeeBarker.configServer.easterEgg && is.func_77978_p().func_74775_l("WolfData").func_74764_b("CustomName") && is.func_77978_p().func_74775_l("WolfData").func_74779_i("CustomName").contains("\"text\":\"iChun\"")) {
                        RayTraceResult result;
                        if (player.field_70173_aa % 4 == 0 && (result = EntityHelper.getEntityLook((Entity)player, (double)6.0)).func_216346_c() == RayTraceResult.Type.ENTITY && !((EntityRayTraceResult)result).func_216348_a().func_230279_az_()) {
                            Entity ent = ((EntityRayTraceResult)result).func_216348_a();
                            ent.func_70015_d(2);
                            ent.func_70097_a(new IndirectEntityDamageSource("beeburnt", ent, (Entity)player).func_76361_j(), 2.0f);
                        }
                        if (player.field_70173_aa % 13 != 0) continue;
                        EntityHelper.playSound((Entity)player, (SoundEvent)SoundEvents.field_187865_gI, (SoundCategory)SoundCategory.PLAYERS, (float)0.6f, (float)1.0f);
                        continue;
                    }
                    BarkHelper.removePressState(name);
                    continue;
                }
                BarkHelper.removePressState(name);
            }
        }
    }

    public static boolean spawnWolfFromItem(PlayerEntity player, ItemEntity item, LivingEntity dropper) {
        ItemStack is = item.func_92059_d();
        if (is.func_77973_b() instanceof ItemBeeBarker && is.func_77978_p() != null && is.func_77978_p().func_74764_b("WolfData")) {
            Entity entity;
            if (!is.func_77978_p().func_74775_l("WolfData").func_74764_b("id")) {
                WolfEntity wolf = (WolfEntity)EntityType.field_200724_aC.func_200721_a(item.field_70170_p);
                if (player != null) {
                    wolf.func_184754_b(player.func_146103_bH().getId());
                    wolf.func_70903_f(true);
                    wolf.func_175547_a(DyeColor.RED);
                }
                if (is.func_77978_p().func_74775_l("WolfData").func_74764_b("CustomName")) {
                    wolf.func_175547_a(DyeColor.BLUE);
                    wolf.func_200203_b((ITextComponent)new StringTextComponent(is.func_77978_p().func_74775_l("WolfData").func_74779_i("CustomName")));
                }
                wolf.func_70606_j(20.0f);
                wolf.getPersistentData().func_74757_a(BARKABLE_STRING, true);
                wolf.getPersistentData().func_74757_a("IsSuperBeeDog", true);
                CompoundNBT wolfTag = new CompoundNBT();
                wolf.func_184198_c(wolfTag);
                is.func_77978_p().func_218657_a("WolfData", (INBT)wolfTag);
            }
            return (entity = EntityType.func_220335_a((CompoundNBT)is.func_77978_p().func_74775_l("WolfData"), (World)item.field_70170_p, ent -> {
                CompoundNBT wolfData;
                if (dropper != null) {
                    ent.func_70012_b(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), dropper.field_70177_z, dropper.field_70125_A);
                } else {
                    ent.func_70107_b(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_());
                }
                if (ent instanceof WolfEntity && (wolfData = ent.getPersistentData()).func_74767_n(BARKABLE_STRING) && wolfData.func_74762_e(BEE_CHARGE_STRING) <= 0) {
                    wolfData.func_82580_o(BARKABLE_STRING);
                    wolfData.func_82580_o(BEE_HIGHEST_CHARGE);
                    wolfData.func_82580_o(BEE_CHARGE_STRING);
                }
                ent.func_213317_d(item.func_213322_ci());
                ent.field_70143_R = 0.0f;
                ent.field_70170_p.func_217376_c(ent);
                return ent;
            })) != null;
        }
        return false;
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        BarkHelper.cooldown.clear();
        BarkHelper.pressState.clear();
    }

    private static /* synthetic */ PacketDistributor.TargetPoint lambda$onServerTick$3(PlayerEntity player) {
        return new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 32.0, player.field_70170_p.func_234923_W_());
    }
}

