/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.beebarker.common.entity;

import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import me.ichun.mods.beebarker.common.BeeBarker;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBee
extends Entity {
    public static final DataParameter<Integer> SHOOTER_ID = EntityDataManager.func_187226_a(EntityBee.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int life;
    public LivingEntity shooter;

    public EntityBee(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.life = 60 + this.field_70146_Z.nextInt(40);
    }

    public EntityBee setShooter(LivingEntity shooter) {
        this.shooter = shooter;
        LivingEntity renderedShooter = shooter;
        Vector3d look = shooter.func_70040_Z();
        Vector3d pos = shooter.func_213303_ch().func_72441_c(look.field_72450_a * 1.3 - look.field_72449_c * ((double)renderedShooter.func_213311_cf() * 0.2), look.field_72448_b * 1.3 + (double)renderedShooter.func_70047_e() * 0.8, look.field_72449_c * 1.3 + look.field_72450_a * ((double)renderedShooter.func_213311_cf() * 0.2));
        double gausAmount = 0.02;
        double d0 = this.field_70146_Z.nextGaussian() * gausAmount;
        double d1 = this.field_70146_Z.nextGaussian() * gausAmount;
        double d2 = this.field_70146_Z.nextGaussian() * gausAmount;
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        double mag = shooter instanceof WolfEntity ? 0.15 : 0.4;
        this.func_213293_j(look.field_72450_a * mag + d0, look.field_72448_b * mag + d1, look.field_72449_c * mag + d2);
        Vector3d motion = this.func_213322_ci();
        float var20 = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70177_z = (float)(Math.atan2(motion.field_72450_a, motion.field_72449_c) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(motion.field_72448_b, var20) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.func_184212_Q().func_187227_b(SHOOTER_ID, (Object)shooter.func_145782_y());
        return this;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SHOOTER_ID, (Object)-1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.life;
        if (this.life < 0 && !this.field_70170_p.field_72995_K || this.life < -200 || this.func_70090_H() || this.func_180799_ab() || this.func_70027_ad()) {
            this.func_70106_y();
            return;
        }
        double gausAmount = 0.02;
        double d0 = this.field_70146_Z.nextGaussian() * gausAmount;
        double d1 = this.field_70146_Z.nextGaussian() * gausAmount;
        double d2 = this.field_70146_Z.nextGaussian() * gausAmount;
        this.func_213317_d(this.func_213322_ci().func_72441_c(d0, d1, d2));
        Vector3d motion = this.func_213322_ci();
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult result = EntityHelper.rayTrace((World)this.field_70170_p, (Vector3d)this.func_213303_ch(), (Vector3d)this.func_213303_ch().func_178787_e(this.func_213322_ci()), (Entity)this, (boolean)true, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, b -> true, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY, e -> !(e instanceof EntityBee) && (this.field_70173_aa >= 7 || e != this.shooter));
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity collidedEnt = ((EntityRayTraceResult)result).func_216348_a();
                boolean doNotHarm = false;
                Iterable equipment = collidedEnt.func_184193_aE();
                if (!Iterables.isEmpty((Iterable)equipment)) {
                    doNotHarm = true;
                    for (ItemStack armor : equipment) {
                        if (armor != null && armor.func_77973_b().getClass().getSimpleName().contains("bee")) continue;
                        doNotHarm = false;
                        break;
                    }
                }
                if (!doNotHarm) {
                    collidedEnt.field_70172_ad = 0;
                    collidedEnt.func_70097_a((DamageSource)new IndirectEntityDamageSource("beestung", collidedEnt, (Entity)this.shooter), (float)BeeBarker.configCommon.beeDamage);
                }
                this.func_70106_y();
                return;
            }
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.func_70106_y();
                return;
            }
        }
        this.func_70107_b(this.func_226277_ct_() + motion.field_72450_a, this.func_226278_cu_() + motion.field_72448_b, this.func_226281_cx_() + motion.field_72449_c);
        float var20 = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70177_z = (float)(Math.atan2(motion.field_72450_a, motion.field_72449_c) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(motion.field_72448_b, var20) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_145775_I();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticle();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticle() {
        Particle particle = Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.field_197629_v, this.field_70169_q, this.field_70167_r, this.field_70166_s, 0.0, 0.0, 0.0);
        if (particle instanceof SimpleAnimatedParticle) {
            ((SimpleAnimatedParticle)particle).func_187146_c(15577600);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBee.func_184183_bd()) * d0;
    }

    public void func_181015_d(BlockPos pos) {
        this.func_70106_y();
    }

    @Nullable
    public Entity changeDimension(ServerWorld world, ITeleporter teleporter) {
        this.func_70106_y();
        return null;
    }

    public boolean func_184198_c(CompoundNBT compound) {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

