/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.biomes.BiomeDefinition;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.registry.SoundsRegistry;
import paulevs.betternether.structures.StructureType;
import paulevs.betternether.structures.plants.StructureBlackBush;
import paulevs.betternether.structures.plants.StructureBlackVine;
import paulevs.betternether.structures.plants.StructureFeatherFern;
import paulevs.betternether.structures.plants.StructureJellyfishMushroom;
import paulevs.betternether.structures.plants.StructureOldWillow;
import paulevs.betternether.structures.plants.StructureReeds;
import paulevs.betternether.structures.plants.StructureSmoker;
import paulevs.betternether.structures.plants.StructureSoulVein;
import paulevs.betternether.structures.plants.StructureSwampGrass;
import paulevs.betternether.structures.plants.StructureWallBrownMushroom;
import paulevs.betternether.structures.plants.StructureWallMoss;
import paulevs.betternether.structures.plants.StructureWallRedMushroom;
import paulevs.betternether.structures.plants.StructureWillow;
import paulevs.betternether.structures.plants.StructureWillowBush;

public class OldSwampland
extends NetherBiome {
    protected static final OpenSimplexNoise TERRAIN = new OpenSimplexNoise(523L);

    public OldSwampland(String name) {
        super(new BiomeDefinition(name).setFogColor(137, 19, 78).setLoop(SoundsRegistry.AMBIENT_SWAMPLAND).setAdditions(class_3417.field_22451).setMood(class_3417.field_22453).setMusic(class_3417.field_23796).setDefaultMobs(false).addMobSpawn(class_1299.field_23214, 40, 2, 4).addMobSpawn(class_1299.field_6102, 40, 2, 4));
        this.addStructure("old_willow", new StructureOldWillow(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("willow", new StructureWillow(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("willow_bush", new StructureWillowBush(), StructureType.FLOOR, 0.1f, true);
        this.addStructure("feather_fern", new StructureFeatherFern(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("nether_reed", new StructureReeds(), StructureType.FLOOR, 0.8f, false);
        this.addStructure("soul_vein", new StructureSoulVein(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("smoker", new StructureSmoker(), StructureType.FLOOR, 0.05f, false);
        this.addStructure("jellyfish_mushroom", new StructureJellyfishMushroom(), StructureType.FLOOR, 0.03f, true);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.01f, false);
        this.addStructure("swamp_grass", new StructureSwampGrass(), StructureType.FLOOR, 0.4f, false);
        this.addStructure("black_vine", new StructureBlackVine(), StructureType.CEIL, 0.4f, true);
        this.addStructure("wall_moss", new StructureWallMoss(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL, 0.8f, true);
    }

    @Override
    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
        double value = TERRAIN.eval((double)pos.method_10263() * 0.2, (double)pos.method_10264() * 0.2, (double)pos.method_10260() * 0.2);
        if (value > 0.3 && this.validWalls(world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10164.method_9564());
        } else if (value > -0.3) {
            BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.SWAMPLAND_GRASS.method_9564());
        } else {
            value = TERRAIN.eval((double)pos.method_10263() * 0.5, (double)pos.method_10260() * 0.5);
            BlocksHelper.setWithoutUpdate(world, pos, value > 0.0 ? class_2246.field_10114.method_9564() : class_2246.field_22090.method_9564());
        }
    }

    protected boolean validWalls(class_1936 world, class_2338 pos) {
        return this.validWall(world, pos.method_10074()) && this.validWall(world, pos.method_10095()) && this.validWall(world, pos.method_10072()) && this.validWall(world, pos.method_10078()) && this.validWall(world, pos.method_10067());
    }

    protected boolean validWall(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return BlocksHelper.isLava(state) || BlocksHelper.isNetherGround(state);
    }
}

