/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1547;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import paulevs.betternether.config.Configs;
import paulevs.betternether.entity.EntityChair;
import paulevs.betternether.entity.EntityFirefly;
import paulevs.betternether.entity.EntityFlyingPig;
import paulevs.betternether.entity.EntityHydrogenJellyfish;
import paulevs.betternether.entity.EntityJungleSkeleton;
import paulevs.betternether.entity.EntityNaga;
import paulevs.betternether.entity.EntityNagaProjectile;
import paulevs.betternether.entity.EntitySkull;

public class EntityRegistry {
    public static final Map<class_1299<? extends class_1309>, class_5132> ATTRIBUTES = Maps.newHashMap();
    private static final List<class_1299<?>> NETHER_ENTITIES = Lists.newArrayList();
    public static final class_1299<EntityChair> CHAIR = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityChair::new).dimensions(class_4048.method_18385((float)0.0f, (float)0.0f)).fireImmune().disableSummon().build();
    public static final class_1299<EntityNagaProjectile> NAGA_PROJECTILE = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityNagaProjectile::new).dimensions(class_4048.method_18385((float)1.0f, (float)1.0f)).disableSummon().build();
    public static final class_1299<EntityFirefly> FIREFLY = FabricEntityTypeBuilder.create((class_1311)class_1311.field_6303, EntityFirefly::new).dimensions(class_4048.method_18385((float)0.5f, (float)0.5f)).fireImmune().build();
    public static final class_1299<EntityHydrogenJellyfish> HYDROGEN_JELLYFISH = FabricEntityTypeBuilder.create((class_1311)class_1311.field_6303, EntityHydrogenJellyfish::new).dimensions(class_4048.method_18384((float)2.0f, (float)5.0f)).fireImmune().build();
    public static final class_1299<EntityNaga> NAGA = FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, EntityNaga::new).dimensions(class_4048.method_18385((float)0.625f, (float)2.75f)).fireImmune().build();
    public static final class_1299<EntityFlyingPig> FLYING_PIG = FabricEntityTypeBuilder.create((class_1311)class_1311.field_6303, EntityFlyingPig::new).dimensions(class_4048.method_18385((float)1.0f, (float)1.25f)).fireImmune().build();
    public static final class_1299<EntityJungleSkeleton> JUNGLE_SKELETON = FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, EntityJungleSkeleton::new).dimensions(class_4048.method_18385((float)0.6f, (float)1.99f)).fireImmune().build();
    public static final class_1299<EntitySkull> SKULL = FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, EntitySkull::new).dimensions(class_4048.method_18385((float)0.625f, (float)0.625f)).fireImmune().build();

    public static void register() {
        NETHER_ENTITIES.add(class_1299.field_6107);
        NETHER_ENTITIES.add(class_1299.field_6050);
        NETHER_ENTITIES.add(class_1299.field_22281);
        NETHER_ENTITIES.add(class_1299.field_21973);
        NETHER_ENTITIES.add(class_1299.field_6099);
        NETHER_ENTITIES.add(class_1299.field_23214);
        EntityRegistry.registerEntity("chair", CHAIR, EntityChair.getAttributeContainer());
        EntityRegistry.registerEntity("naga_projectile", NAGA_PROJECTILE);
        EntityRegistry.registerEntity("firefly", FIREFLY, EntityFirefly.getAttributeContainer());
        EntityRegistry.registerEntity("hydrogen_jellyfish", HYDROGEN_JELLYFISH, EntityHydrogenJellyfish.getAttributeContainer());
        EntityRegistry.registerEntity("naga", NAGA, EntityNaga.getAttributeContainer());
        EntityRegistry.registerEntity("flying_pig", FLYING_PIG, EntityFlyingPig.getAttributeContainer());
        EntityRegistry.registerEntity("jungle_skeleton", JUNGLE_SKELETON, class_1547.method_26905().method_26866());
        EntityRegistry.registerEntity("skull", SKULL, EntitySkull.getAttributeContainer());
    }

    public static void registerEntity(String name, class_1299<? extends class_1309> entity) {
        class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("betternether", name), entity);
        ATTRIBUTES.put(entity, class_1308.method_26828().method_26866());
    }

    public static void registerEntity(String name, class_1299<? extends class_1309> entity, class_5132 container) {
        if (Configs.MOBS.getBoolean("mobs", name, true)) {
            class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("betternether", name), entity);
            ATTRIBUTES.put(entity, container);
        }
    }

    public static boolean isNetherEntity(class_1297 entity) {
        return NETHER_ENTITIES.contains(entity.method_5864());
    }

    public static boolean alwaysSpawn(class_1299<?> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        return true;
    }
}

