/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.registry;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import paulevs.betternether.structures.IStructure;
import paulevs.betternether.structures.StructureType;
import paulevs.betternether.structures.bones.StructureBoneReef;
import paulevs.betternether.structures.decorations.StructureCrystal;
import paulevs.betternether.structures.decorations.StructureGeyser;
import paulevs.betternether.structures.decorations.StructureWartDeadwood;
import paulevs.betternether.structures.plants.StructureAgave;
import paulevs.betternether.structures.plants.StructureBarrelCactus;
import paulevs.betternether.structures.plants.StructureBigWarpedTree;
import paulevs.betternether.structures.plants.StructureBlackApple;
import paulevs.betternether.structures.plants.StructureBlackBush;
import paulevs.betternether.structures.plants.StructureBlackVine;
import paulevs.betternether.structures.plants.StructureBloomingVine;
import paulevs.betternether.structures.plants.StructureCrimsonFungus;
import paulevs.betternether.structures.plants.StructureCrimsonGlowingTree;
import paulevs.betternether.structures.plants.StructureCrimsonPinewood;
import paulevs.betternether.structures.plants.StructureCrimsonRoots;
import paulevs.betternether.structures.plants.StructureEggPlant;
import paulevs.betternether.structures.plants.StructureEye;
import paulevs.betternether.structures.plants.StructureGiantMold;
import paulevs.betternether.structures.plants.StructureGoldenVine;
import paulevs.betternether.structures.plants.StructureGrayMold;
import paulevs.betternether.structures.plants.StructureInkBush;
import paulevs.betternether.structures.plants.StructureJunglePlant;
import paulevs.betternether.structures.plants.StructureLucis;
import paulevs.betternether.structures.plants.StructureMagmaFlower;
import paulevs.betternether.structures.plants.StructureMedBrownMushroom;
import paulevs.betternether.structures.plants.StructureMedRedMushroom;
import paulevs.betternether.structures.plants.StructureMushroomFir;
import paulevs.betternether.structures.plants.StructureNetherCactus;
import paulevs.betternether.structures.plants.StructureNetherGrass;
import paulevs.betternether.structures.plants.StructureNetherWart;
import paulevs.betternether.structures.plants.StructureOldBrownMushrooms;
import paulevs.betternether.structures.plants.StructureOldRedMushrooms;
import paulevs.betternether.structures.plants.StructureOrangeMushroom;
import paulevs.betternether.structures.plants.StructureRedMold;
import paulevs.betternether.structures.plants.StructureReeds;
import paulevs.betternether.structures.plants.StructureRubeus;
import paulevs.betternether.structures.plants.StructureRubeusBush;
import paulevs.betternether.structures.plants.StructureSmoker;
import paulevs.betternether.structures.plants.StructureSoulGrass;
import paulevs.betternether.structures.plants.StructureSoulLily;
import paulevs.betternether.structures.plants.StructureSoulVein;
import paulevs.betternether.structures.plants.StructureStalagnate;
import paulevs.betternether.structures.plants.StructureSwampGrass;
import paulevs.betternether.structures.plants.StructureTwistedVines;
import paulevs.betternether.structures.plants.StructureVanillaMushroom;
import paulevs.betternether.structures.plants.StructureWallBrownMushroom;
import paulevs.betternether.structures.plants.StructureWallMoss;
import paulevs.betternether.structures.plants.StructureWallRedMushroom;
import paulevs.betternether.structures.plants.StructureWarpedFungus;
import paulevs.betternether.structures.plants.StructureWarpedRoots;
import paulevs.betternether.structures.plants.StructureWartBush;
import paulevs.betternether.structures.plants.StructureWartSeed;
import paulevs.betternether.structures.plants.StructureWartTree;
import paulevs.betternether.structures.plants.StructureWillow;

public class StructureRegistry {
    private static final Map<StructureType, Map<String, IStructure>> REGISTRY = Maps.newHashMap();

    public static void register(String name, IStructure structure, StructureType type) {
        REGISTRY.get((Object)type).put(name, structure);
    }

    public static IStructure getStructure(String name, StructureType type) {
        return REGISTRY.get((Object)type).get(name);
    }

    static {
        for (StructureType type : StructureType.values()) {
            HashMap list = Maps.newHashMap();
            REGISTRY.put(type, list);
        }
        StructureRegistry.register("agave", new StructureAgave(), StructureType.FLOOR);
        StructureRegistry.register("barrel_cactus", new StructureBarrelCactus(), StructureType.FLOOR);
        StructureRegistry.register("big_warped_tree", new StructureBigWarpedTree(), StructureType.FLOOR);
        StructureRegistry.register("black_apple", new StructureBlackApple(), StructureType.FLOOR);
        StructureRegistry.register("black_bush", new StructureBlackBush(), StructureType.FLOOR);
        StructureRegistry.register("bone_reef", new StructureBoneReef(), StructureType.FLOOR);
        StructureRegistry.register("bush_rubeus", new StructureRubeusBush(), StructureType.FLOOR);
        StructureRegistry.register("crimson_fungus", new StructureCrimsonFungus(), StructureType.FLOOR);
        StructureRegistry.register("crimson_glowing_tree", new StructureCrimsonGlowingTree(), StructureType.FLOOR);
        StructureRegistry.register("crimson_pinewood", new StructureCrimsonPinewood(), StructureType.FLOOR);
        StructureRegistry.register("crimson_roots", new StructureCrimsonRoots(), StructureType.FLOOR);
        StructureRegistry.register("egg_plant", new StructureEggPlant(), StructureType.FLOOR);
        StructureRegistry.register("geyser", new StructureGeyser(), StructureType.FLOOR);
        StructureRegistry.register("giant_mold", new StructureGiantMold(), StructureType.FLOOR);
        StructureRegistry.register("gray_mold", new StructureGrayMold(), StructureType.FLOOR);
        StructureRegistry.register("ink_bush", new StructureInkBush(), StructureType.FLOOR);
        StructureRegistry.register("jungle_plant", new StructureJunglePlant(), StructureType.FLOOR);
        StructureRegistry.register("large_brown_mushroom", new StructureMedBrownMushroom(), StructureType.FLOOR);
        StructureRegistry.register("large_red_mushroom", new StructureMedRedMushroom(), StructureType.FLOOR);
        StructureRegistry.register("magma_flower", new StructureMagmaFlower(), StructureType.FLOOR);
        StructureRegistry.register("mushroom_fir", new StructureMushroomFir(), StructureType.FLOOR);
        StructureRegistry.register("nether_cactus", new StructureNetherCactus(), StructureType.FLOOR);
        StructureRegistry.register("nether_grass", new StructureNetherGrass(), StructureType.FLOOR);
        StructureRegistry.register("swamp_grass", new StructureSwampGrass(), StructureType.FLOOR);
        StructureRegistry.register("nether_reed", new StructureReeds(), StructureType.FLOOR);
        StructureRegistry.register("nether_wart", new StructureNetherWart(), StructureType.FLOOR);
        StructureRegistry.register("obsidian_crystals", new StructureCrystal(), StructureType.FLOOR);
        StructureRegistry.register("old_brown_mushrooms", new StructureOldBrownMushrooms(), StructureType.FLOOR);
        StructureRegistry.register("old_red_mushrooms", new StructureOldRedMushrooms(), StructureType.FLOOR);
        StructureRegistry.register("orange_mushroom", new StructureOrangeMushroom(), StructureType.FLOOR);
        StructureRegistry.register("red_mold", new StructureRedMold(), StructureType.FLOOR);
        StructureRegistry.register("rubeus_tree", new StructureRubeus(), StructureType.FLOOR);
        StructureRegistry.register("smoker", new StructureSmoker(), StructureType.FLOOR);
        StructureRegistry.register("soul_grass", new StructureSoulGrass(), StructureType.FLOOR);
        StructureRegistry.register("soul_lily", new StructureSoulLily(), StructureType.FLOOR);
        StructureRegistry.register("soul_vein", new StructureSoulVein(), StructureType.FLOOR);
        StructureRegistry.register("stalagnate", new StructureStalagnate(), StructureType.FLOOR);
        StructureRegistry.register("twisted_vine", new StructureTwistedVines(), StructureType.FLOOR);
        StructureRegistry.register("vanilla_mushrooms", new StructureVanillaMushroom(), StructureType.FLOOR);
        StructureRegistry.register("warped_fungus", new StructureWarpedFungus(), StructureType.FLOOR);
        StructureRegistry.register("warped_roots", new StructureWarpedRoots(), StructureType.FLOOR);
        StructureRegistry.register("wart_bush", new StructureWartBush(), StructureType.FLOOR);
        StructureRegistry.register("wart_deadwood", new StructureWartDeadwood(), StructureType.FLOOR);
        StructureRegistry.register("wart_seed", new StructureWartSeed(), StructureType.FLOOR);
        StructureRegistry.register("wart_tree", new StructureWartTree(), StructureType.FLOOR);
        StructureRegistry.register("willow", new StructureWillow(), StructureType.FLOOR);
        StructureRegistry.register("black_vine", new StructureBlackVine(), StructureType.CEIL);
        StructureRegistry.register("eye", new StructureEye(), StructureType.CEIL);
        StructureRegistry.register("flowered_vine", new StructureBloomingVine(), StructureType.CEIL);
        StructureRegistry.register("golden_vine", new StructureGoldenVine(), StructureType.CEIL);
        StructureRegistry.register("lucis", new StructureLucis(), StructureType.WALL);
        StructureRegistry.register("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL);
        StructureRegistry.register("wall_moss", new StructureWallMoss(), StructureType.WALL);
        StructureRegistry.register("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL);
    }
}

