/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;

public class StructureNBT {
    protected class_2960 location;
    protected class_3499 structure;
    protected class_2415 mirror = class_2415.field_11302;
    protected class_2470 rotation = class_2470.field_11467;

    public StructureNBT(String structure) {
        this.location = new class_2960("betternether", structure);
        this.structure = this.readStructureFromJar(this.location);
    }

    protected StructureNBT(class_2960 location, class_3499 structure) {
        this.location = location;
        this.structure = structure;
    }

    public StructureNBT setRotation(class_2470 rotation) {
        this.rotation = rotation;
        return this;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public StructureNBT setMirror(class_2415 mirror) {
        this.mirror = mirror;
        return this;
    }

    public void randomRM(Random random) {
        this.rotation = class_2470.values()[random.nextInt(4)];
        this.mirror = class_2415.values()[random.nextInt(3)];
    }

    public boolean generateCentered(class_5425 world, class_2338 pos) {
        if (this.structure == null) {
            System.out.println("No structure: " + this.location.toString());
            return false;
        }
        class_2338.class_2339 blockpos2 = new class_2338.class_2339().method_10101((class_2382)this.structure.method_15160());
        if (this.mirror == class_2415.field_11301) {
            blockpos2.method_20787(-blockpos2.method_10263());
        }
        if (this.mirror == class_2415.field_11300) {
            blockpos2.method_20788(-blockpos2.method_10260());
        }
        blockpos2.method_10101((class_2382)blockpos2.method_10070(this.rotation));
        class_3492 data = new class_3492().method_15123(this.rotation).method_15125(this.mirror);
        this.structure.method_15182(world, pos.method_10069(-blockpos2.method_10263() >> 1, 0, -blockpos2.method_10260() >> 1), data, world.method_8409());
        return true;
    }

    private class_3499 readStructureFromJar(class_2960 resource) {
        String ns = resource.method_12836();
        String nm = resource.method_12832();
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream("/data/" + ns + "/structures/" + nm + ".nbt");
            return this.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class_3499 readStructureFromStream(InputStream stream) throws IOException {
        class_2487 nbttagcompound = class_2507.method_10629((InputStream)stream);
        class_3499 template = new class_3499();
        template.method_15183(nbttagcompound);
        return template;
    }

    public class_2338 getSize() {
        if (this.rotation == class_2470.field_11467 || this.rotation == class_2470.field_11464) {
            return this.structure.method_15160();
        }
        class_2338 size = this.structure.method_15160();
        int x = size.method_10263();
        int z = size.method_10260();
        return new class_2338(z, size.method_10264(), x);
    }

    public String getName() {
        return this.location.method_12832();
    }

    public class_3341 getBoundingBox(class_2338 pos) {
        return this.structure.method_16187(new class_3492().method_15123(this.rotation).method_15125(this.mirror), pos);
    }
}

