/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.structures.IStructure;
import paulevs.betternether.structures.StructureNBT;
import paulevs.betternether.structures.StructureType;

public class StructureWorld
extends StructureNBT
implements IStructure {
    protected static final class_2338.class_2339 POS = new class_2338.class_2339();
    protected final StructureType type;
    protected final int offsetY;

    public StructureWorld(String structure, int offsetY, StructureType type) {
        super(structure);
        this.offsetY = offsetY;
        this.type = type;
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        this.randomRM(random);
        if (this.canGenerate((class_1936)world, pos)) {
            this.generateCentered(world, pos.method_10086(this.offsetY));
        }
    }

    private boolean canGenerate(class_1936 world, class_2338 pos) {
        for (int i = 0; i < this.structure.method_15160().method_10264(); i += 2) {
            if (!world.method_8320(pos.method_10086(i)).method_27852(class_2246.field_9987)) continue;
            return false;
        }
        if (this.type == StructureType.FLOOR) {
            return (double)this.getAirFraction(world, pos) > 0.6 && (double)this.getAirFractionFoundation(world, pos) < 0.5;
        }
        if (this.type == StructureType.LAVA) {
            return (double)this.getLavaFractionFoundation(world, pos) > 0.9 && (double)this.getAirFraction(world, pos) > 0.9;
        }
        if (this.type == StructureType.UNDER) {
            return (double)this.getAirFraction(world, pos) < 0.2;
        }
        if (this.type == StructureType.CEIL) {
            return (double)this.getAirFractionBottom(world, pos) > 0.8 && (double)this.getAirFraction(world, pos) < 0.6;
        }
        return false;
    }

    private float getAirFraction(class_1936 world, class_2338 pos) {
        int airCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)this.structure.method_15160().method_10070(this.rotation));
        size.method_20787(Math.abs(size.method_10263()));
        size.method_20788(Math.abs(size.method_10260()));
        class_2338 start = pos.method_10069(-(size.method_10263() >> 1), 0, -(size.method_10260() >> 1));
        class_2338 end = pos.method_10069(size.method_10263() >> 1, size.method_10264() + this.offsetY, size.method_10260() >> 1);
        int count = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_20787(x);
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                POS.method_10099(y);
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    POS.method_20788(z);
                    if (world.method_22347((class_2338)POS)) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getLavaFractionFoundation(class_1936 world, class_2338 pos) {
        int lavaCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)this.structure.method_15160().method_10070(this.rotation));
        size.method_20787(Math.abs(size.method_10263()));
        size.method_20788(Math.abs(size.method_10260()));
        class_2338 start = pos.method_10069(-(size.method_10263() >> 1), 0, -(size.method_10260() >> 1));
        class_2338 end = pos.method_10069(size.method_10263() >> 1, 0, size.method_10260() >> 1);
        int count = 0;
        POS.method_10099(pos.method_10264() - 1);
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_20787(x);
            for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                POS.method_20788(z);
                if (BlocksHelper.isLava(world.method_8320((class_2338)POS))) {
                    ++lavaCount;
                }
                ++count;
            }
        }
        return (float)lavaCount / (float)count;
    }

    private float getAirFractionFoundation(class_1936 world, class_2338 pos) {
        int airCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)this.structure.method_15160().method_10070(this.rotation));
        size.method_20787(Math.abs(size.method_10263()));
        size.method_20788(Math.abs(size.method_10260()));
        class_2338 start = pos.method_10069(-(size.method_10263() >> 1), -1, -(size.method_10260() >> 1));
        class_2338 end = pos.method_10069(size.method_10263() >> 1, 0, size.method_10260() >> 1);
        int count = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_20787(x);
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                POS.method_10099(y);
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    POS.method_20788(z);
                    if (world.method_8320((class_2338)POS).method_26207().method_15800()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getAirFractionBottom(class_1936 world, class_2338 pos) {
        int airCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)this.structure.method_15160().method_10070(this.rotation));
        size.method_20787(Math.abs(size.method_10263()));
        size.method_20788(Math.abs(size.method_10260()));
        float y1 = Math.min(this.offsetY, 0);
        float y2 = Math.max(this.offsetY, 0);
        class_2338 start = pos.method_10080((double)(-(size.method_10263() >> 1)), (double)y1, (double)(-(size.method_10260() >> 1)));
        class_2338 end = pos.method_10080((double)(size.method_10263() >> 1), (double)y2, (double)(size.method_10260() >> 1));
        int count = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_20787(x);
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                POS.method_10099(y);
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    POS.method_20788(z);
                    if (world.method_8320((class_2338)POS).method_26207().method_15800()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    public boolean loaded() {
        return this.structure != null;
    }

    public StructureType getType() {
        return this.type;
    }
}

