/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.decorations;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.IStructure;

public class StructureCrystal
implements IStructure {
    private static final class_2248[] PALETTES = new class_2248[]{BlocksRegistry.OBSIDIAN_GLASS, class_2246.field_10540, BlocksRegistry.BLUE_OBSIDIAN_GLASS, BlocksRegistry.BLUE_OBSIDIAN};
    private static final double SQRT05 = Math.sqrt(0.5);
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private static final float MAX_ANGLE_X = (float)Math.toRadians(45.0);
    private static final float MAX_ANGLE_Y = (float)Math.PI * 2;
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        int index = random.nextInt(PALETTES.length >> 1);
        double a = random.nextDouble();
        double radius = 2.0 + a * a * 5.0;
        int sideXZ = (int)Math.ceil(radius * 2.0);
        int sideY = (int)Math.ceil(radius * 3.0);
        float angleX = random.nextFloat() * MAX_ANGLE_X;
        float angleY = random.nextFloat() * ((float)Math.PI * 2);
        for (int y = -sideY; y <= sideY; ++y) {
            for (int x = -sideXZ; x <= sideXZ; ++x) {
                for (int z = -sideXZ; z <= sideXZ; ++z) {
                    class_243 v = new class_243((double)x, (double)y, (double)z).method_1037(angleX).method_1024(angleY);
                    if (!this.isInside(v.field_1352, v.field_1351, v.field_1350, radius)) continue;
                    POS.method_20787(pos.method_10263() + x);
                    POS.method_10099(pos.method_10264() + y);
                    POS.method_20788(pos.method_10260() + z);
                    class_2680 state = random.nextInt(40) == 0 && this.isNotEdge(v.field_1352, v.field_1351, v.field_1350, radius) ? class_2246.field_10171.method_9564() : this.getState(index, v);
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, state);
                }
            }
        }
    }

    private boolean isInside(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size) <= 0.0;
    }

    private boolean isNotEdge(double x, double y, double z, double size) {
        return this.isInside(x + 1.0, y, z, size) && this.isInside(x - 1.0, y, z, size) && this.isInside(x, y + 1.0, z, size) && this.isInside(x, y - 1.0, z, size) && this.isInside(x, y, z + 1.0, size) && this.isInside(x, y, z - 1.0, size);
    }

    private double dodecahedronSDF(double x, double y, double z) {
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return (Math.max(Math.max(x + y, y + z), z + x) - 1.0) * SQRT05;
    }

    private double rigidNoise(class_243 pos, double scale) {
        double val = NOISE.eval(pos.field_1352 * scale, pos.field_1351 * scale, pos.field_1350 * scale);
        return Math.abs(val);
    }

    private class_2680 getState(int index, class_243 pos) {
        int subindex = this.rigidNoise(pos, 0.2) > 0.2 ? 0 : 1;
        int blockIndex = index << 1 | subindex;
        return PALETTES[blockIndex].method_9564();
    }
}

