/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockPlantWall;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.IStructure;

public class StructureAnchorTree
implements IStructure {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);
    private static final Set<class_2338> BLOCKS = new HashSet<class_2338>(2048);
    private class_2248[] wallPlants;

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        if (this.canGenerate(pos)) {
            this.grow(world, pos, pos.method_10087(BlocksHelper.downRay((class_1936)world, pos, 255)), random);
        }
    }

    private boolean canGenerate(class_2338 pos) {
        return (pos.method_10263() & 0xF) == 7 && (pos.method_10260() & 0xF) == 7;
    }

    private void grow(class_5425 world, class_2338 up, class_2338 down, Random random) {
        if (up.method_10264() - down.method_10264() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((class_1936)world, down, 128) + 1;
        for (int i = 0; i < 5; ++i) {
            class_2248 block = world.method_8320(down.method_10087(pd + i)).method_26204();
            if (block != class_2246.field_10266 && block != BlocksRegistry.NETHER_BRICK_TILE_LARGE && block != BlocksRegistry.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        class_2338 trunkTop = this.lerp(down, up, 0.6);
        class_2338 trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.method_10264() - trunkBottom.method_10264()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<class_2338> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        BLOCKS.clear();
        if (this.wallPlants == null) {
            this.wallPlants = new class_2248[]{BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.WALL_MUSHROOM_BROWN, BlocksRegistry.WALL_MUSHROOM_RED};
        }
        this.buildLine(blocks, 4.0);
        count = (up.method_10264() - down.method_10264()) / 10 - 1;
        if (count < 3) {
            count = 3;
        }
        this.buildBigCircle(trunkTop, 15, count, 2, random.nextDouble() * Math.PI * 2.0, 3.5, random);
        this.buildBigCircle(trunkBottom, -15, count, 2, random.nextDouble() * Math.PI * 2.0, 3.5, random);
        int offset = random.nextInt(4);
        for (class_2338 bpos : BLOCKS) {
            class_2680 state;
            if (bpos.method_10264() < 1 || bpos.method_10264() > 126 || !BlocksHelper.isNetherGround(state = world.method_8320(bpos)) && !state.method_26207().method_15800()) continue;
            boolean blockUp = true;
            blockUp = BLOCKS.contains(bpos.method_10084());
            if (blockUp && BLOCKS.contains(bpos.method_10074())) {
                BlocksHelper.setWithUpdate((class_1936)world, bpos, BlocksRegistry.ANCHOR_TREE.log.method_9564());
            } else {
                BlocksHelper.setWithUpdate((class_1936)world, bpos, BlocksRegistry.ANCHOR_TREE.bark.method_9564());
            }
            if (bpos.method_10264() > 45 && bpos.method_10264() < 90 && (bpos.method_10264() & 3) == offset && NOISE.eval((double)bpos.method_10263() * 0.1, (double)bpos.method_10264() * 0.1, (double)bpos.method_10260() * 0.1) > 0.0) {
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10095())) {
                    StructureAnchorTree.makeMushroom(world, bpos.method_10095(), random.nextDouble() * 3.0 + 1.5);
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10072())) {
                    StructureAnchorTree.makeMushroom(world, bpos.method_10072(), random.nextDouble() * 3.0 + 1.5);
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10078())) {
                    StructureAnchorTree.makeMushroom(world, bpos.method_10078(), random.nextDouble() * 3.0 + 1.5);
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10067())) {
                    StructureAnchorTree.makeMushroom(world, bpos.method_10067(), random.nextDouble() * 3.0 + 1.5);
                }
            }
            if (bpos.method_10264() <= 64) continue;
            if (!blockUp && world.method_8320(bpos.method_10084()).method_26207().method_15800()) {
                BlocksHelper.setWithUpdate((class_1936)world, bpos.method_10084(), BlocksRegistry.MOSS_COVER.method_9564());
            }
            if (!(NOISE.eval((double)bpos.method_10263() * 0.05, (double)bpos.method_10264() * 0.05, (double)bpos.method_10260() * 0.05) > 0.0)) continue;
            state = this.wallPlants[random.nextInt(this.wallPlants.length)].method_9564();
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10095()) && world.method_22347(bpos.method_10095())) {
                BlocksHelper.setWithUpdate((class_1936)world, bpos.method_10095(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11043));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10072()) && world.method_22347(bpos.method_10072())) {
                BlocksHelper.setWithUpdate((class_1936)world, bpos.method_10072(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11035));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10078()) && world.method_22347(bpos.method_10078())) {
                BlocksHelper.setWithUpdate((class_1936)world, bpos.method_10078(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11034));
            }
            if (random.nextInt(8) != 0 || BLOCKS.contains(bpos.method_10067()) || !world.method_22347(bpos.method_10067())) continue;
            BlocksHelper.setWithUpdate((class_1936)world, bpos.method_10067(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11039));
        }
    }

    private void buildBigCircle(class_2338 pos, int length, int count, int iteration, double angle, double size, Random random) {
        if (iteration < 0) {
            return;
        }
        List<List<class_2338>> lines = this.circleLinesEnds(pos, angle, count, length, (double)Math.abs(length) * 0.7, random);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.nextDouble() * angle * 0.75;
        for (List<class_2338> line : lines) {
            this.buildLine(line, size);
            this.buildBigCircle(line.get(1), length, count, iteration - 1, angle, sizeSmall, random);
        }
    }

    private void buildLine(List<class_2338> blocks, double radius) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            class_2338 a = blocks.get(i);
            class_2338 b = blocks.get(i + 1);
            if (b.method_10264() < a.method_10264()) {
                class_2338 c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.method_10264() - a.method_10264())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.method_10264(); y <= b.method_10264(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.method_10264()) / max), radius);
            }
        }
    }

    private class_2338 lerp(class_2338 start, class_2338 end, double mix) {
        double x = class_3532.method_16436((double)mix, (double)start.method_10263(), (double)end.method_10263());
        double y = class_3532.method_16436((double)mix, (double)start.method_10264(), (double)end.method_10264());
        double z = class_3532.method_16436((double)mix, (double)start.method_10260(), (double)end.method_10260());
        return new class_2338(x, y, z);
    }

    private class_2338 lerpCos(class_2338 start, class_2338 end, int y, double mix) {
        double v = this.lcos(mix);
        double x = class_3532.method_16436((double)v, (double)start.method_10263(), (double)end.method_10263());
        double z = class_3532.method_16436((double)v, (double)start.method_10260(), (double)end.method_10260());
        return new class_2338(x, (double)y, z);
    }

    private double lcos(double mix) {
        return class_3532.method_15350((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<class_2338> line(class_2338 start, class_2338 end, int count, Random random, double range) {
        ArrayList<class_2338> result = new ArrayList<class_2338>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = class_3532.method_16436((double)delta, (double)start.method_10263(), (double)end.method_10263()) + random.nextGaussian() * range;
            double y = class_3532.method_16436((double)delta, (double)start.method_10264(), (double)end.method_10264());
            double z = class_3532.method_16436((double)delta, (double)start.method_10260(), (double)end.method_10260()) + random.nextGaussian() * range;
            result.add(new class_2338(x, y, z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(class_2338 pos, double radius) {
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.method_10260();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.method_10264() * 0.5, (double)z * 0.5) * 0.25 + 0.75))) continue;
                BLOCKS.add(new class_2338(x, pos.method_10264(), z));
            }
        }
    }

    private List<List<class_2338>> circleLinesEnds(class_2338 pos, double startAngle, int count, int height, double radius, Random random) {
        ArrayList<List<class_2338>> result = new ArrayList<List<class_2338>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.method_10263() + Math.sin(startAngle) * radius;
            double z = (double)pos.method_10260() + Math.cos(startAngle) * radius;
            class_2338 end = new class_2338(x, (double)(pos.method_10264() + height) + (double)height * random.nextDouble() * 0.5, z);
            ArrayList<class_2338> elem = new ArrayList<class_2338>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(class_5425 world, class_2338 pos, double radius) {
        if (!world.method_8320(pos).method_26207().method_15800()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        ArrayList<class_2338> placed = new ArrayList<class_2338>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                class_2338 p;
                int pz2 = z - pos.method_10260();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.method_8320(p = new class_2338(x, pos.method_10264(), z)).method_26207().method_15800()) continue;
                placed.add(p);
            }
        }
        for (class_2338 p : placed) {
            boolean north = world.method_8320(p.method_10095()).method_26204() != BlocksRegistry.GIANT_LUCIS;
            boolean south = world.method_8320(p.method_10072()).method_26204() != BlocksRegistry.GIANT_LUCIS;
            boolean east = world.method_8320(p.method_10078()).method_26204() != BlocksRegistry.GIANT_LUCIS;
            boolean west = world.method_8320(p.method_10067()).method_26204() != BlocksRegistry.GIANT_LUCIS;
            class_2680 state = BlocksRegistry.GIANT_LUCIS.method_9564();
            BlocksHelper.setWithUpdate((class_1936)world, p, (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(north))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(south))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(east))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(west)));
        }
    }
}

