/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockAnchorTreeVine;
import paulevs.betternether.blocks.BlockPlantWall;
import paulevs.betternether.blocks.BlockProperties;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.IStructure;
import paulevs.betternether.structures.plants.StructureAnchorTree;
import paulevs.betternether.structures.plants.StructureLucis;

public class StructureAnchorTreeRoot
implements IStructure {
    private static final Set<class_2338> BLOCKS = new HashSet<class_2338>(2048);
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private class_2248[] wallPlants;
    private static final StructureLucis LUCIS = new StructureLucis();

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        if (pos.method_10264() < 96) {
            return;
        }
        double angle = random.nextDouble() * Math.PI * 2.0;
        double dx = Math.sin(angle);
        double dz = Math.cos(angle);
        double size = (double)MHelper.randRange(10, 25, random) * 0.5;
        int count = MHelper.floor(size * 2.0);
        if (count < 3) {
            count = 3;
        }
        if ((count & 1) == 0) {
            ++count;
        }
        POS.method_10102((double)pos.method_10263() - dx * size, (double)(pos.method_10264() + 10), (double)pos.method_10260() - dz * size);
        class_2338 start = POS.method_10086(BlocksHelper.upRay((class_1936)world, (class_2338)POS, 64));
        if (start.method_10264() < pos.method_10264()) {
            start = POS.method_10101((class_2382)start).method_10069(0, 10, 0).method_10062();
        }
        POS.method_10102((double)pos.method_10263() + dx * size, (double)(pos.method_10264() + 10), (double)pos.method_10260() + dz * size);
        class_2338 end = POS.method_10086(BlocksHelper.upRay((class_1936)world, (class_2338)POS, 64));
        if (end.method_10264() < pos.method_10264()) {
            end = POS.method_10101((class_2382)end).method_10069(0, 10, 0).method_10062();
        }
        List<class_2338> blocks = this.lineParable(start, end, count, random, 0.2);
        BLOCKS.clear();
        this.buildLine(blocks, 1.3 + random.nextDouble());
        if (this.wallPlants == null) {
            this.wallPlants = new class_2248[]{BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.WALL_MUSHROOM_BROWN, BlocksRegistry.WALL_MUSHROOM_RED};
        }
        class_2680 vine = BlocksRegistry.ANCHOR_TREE_VINE.method_9564();
        for (class_2338 bpos : BLOCKS) {
            int length;
            class_2680 state;
            if (bpos.method_10264() < 1 || bpos.method_10264() > 126 || !BlocksHelper.isNetherGround(state = world.method_8320(bpos)) && !this.canReplace(state)) continue;
            boolean blockUp = true;
            boolean blockDown = true;
            blockUp = BLOCKS.contains(bpos.method_10084());
            if (blockUp && (blockDown = BLOCKS.contains(bpos.method_10074()))) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos, BlocksRegistry.ANCHOR_TREE.log.method_9564());
            } else {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos, BlocksRegistry.ANCHOR_TREE.bark.method_9564());
            }
            if (!blockUp && world.method_8320(bpos.method_10084()).method_26207().method_15800()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10084(), BlocksRegistry.MOSS_COVER.method_9564());
            }
            if ((bpos.method_10264() & 3) == 0 && StructureAnchorTree.NOISE.eval((double)bpos.method_10263() * 0.1, (double)bpos.method_10264() * 0.1, (double)bpos.method_10260() * 0.1) > 0.0) {
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10095())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.method_10095(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10072())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.method_10072(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10078())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.method_10078(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.method_10067())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.method_10067(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
            }
            state = this.wallPlants[random.nextInt(this.wallPlants.length)].method_9564();
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10095()) && world.method_22347(bpos.method_10095())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10095(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11043));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10072()) && world.method_22347(bpos.method_10072())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10072(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11035));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10078()) && world.method_22347(bpos.method_10078())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10078(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11034));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10067()) && world.method_22347(bpos.method_10067())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10067(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11039));
            }
            if (!blockUp || blockDown || random.nextInt(16) != 0 || (length = BlocksHelper.downRay((class_1936)world, bpos = bpos.method_10074(), 17)) <= 4) continue;
            length = MHelper.randRange(3, length, random);
            for (int i = 0; i < length - 2; ++i) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10087(i), vine);
            }
            BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10087(length - 2), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)));
            BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10087(length - 1), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
        }
    }

    private boolean canReplace(class_2680 state) {
        return state.method_26207().method_15800() || state.method_26204() == BlocksRegistry.GIANT_LUCIS || state.method_26204() == BlocksRegistry.LUCIS_MUSHROOM || state.method_26204() instanceof BlockPlantWall;
    }

    private void buildLine(List<class_2338> blocks, double radius) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            class_2338 a = blocks.get(i);
            class_2338 b = blocks.get(i + 1);
            if (b.method_10264() < a.method_10264()) {
                class_2338 c = b;
                b = a;
                a = c;
            }
            int count = (int)Math.ceil(Math.sqrt(b.method_10262((class_2382)a)));
            for (int j = 0; j < count; ++j) {
                this.sphere(this.lerpCos(a, b, (double)j / (double)count), radius);
            }
        }
    }

    private class_2338 lerpCos(class_2338 start, class_2338 end, double mix) {
        double v = this.lcos(mix);
        double x = class_3532.method_16436((double)v, (double)start.method_10263(), (double)end.method_10263());
        double y = class_3532.method_16436((double)v, (double)start.method_10264(), (double)end.method_10264());
        double z = class_3532.method_16436((double)v, (double)start.method_10260(), (double)end.method_10260());
        return new class_2338(x, y, z);
    }

    private double lcos(double mix) {
        return class_3532.method_15350((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<class_2338> lineParable(class_2338 start, class_2338 end, int count, Random random, double range) {
        ArrayList<class_2338> result = new ArrayList<class_2338>(count);
        int max = count - 1;
        int middle = count / 2;
        result.add(start);
        double size = Math.sqrt(start.method_10262((class_2382)end)) * 0.8;
        for (int i = 1; i < max; ++i) {
            double offset = (double)(i - middle) / (double)middle;
            offset = 1.0 - offset * offset;
            double delta = (double)i / (double)max;
            double x = class_3532.method_16436((double)delta, (double)start.method_10263(), (double)end.method_10263()) + random.nextGaussian() * range;
            double y = class_3532.method_16436((double)delta, (double)start.method_10264(), (double)end.method_10264()) - offset * size;
            double z = class_3532.method_16436((double)delta, (double)start.method_10260(), (double)end.method_10260()) + random.nextGaussian() * range;
            result.add(new class_2338(x, y, z));
        }
        result.add(end);
        return result;
    }

    private void sphere(class_2338 pos, double radius) {
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int y1 = MHelper.floor((double)pos.method_10264() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.method_10264() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.method_10260();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.method_10264();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    BLOCKS.add(new class_2338(x, y, z));
                }
            }
        }
    }
}

