/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.structure.v1.FabricStructureBuilder;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_4538;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5425;
import net.minecraft.class_5458;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlockStalactite;
import paulevs.betternether.config.Configs;
import paulevs.betternether.registry.BiomesRegistry;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.StructureCaves;
import paulevs.betternether.structures.StructurePath;
import paulevs.betternether.structures.StructureType;
import paulevs.betternether.world.structures.CityFeature;

public class BNWorldGenerator {
    private static boolean hasCleaningPass;
    private static boolean hasFixPass;
    private static float cincinnasiteDensity;
    private static float rubyDensity;
    private static float lapisDensity;
    private static float structureDensity;
    private static float lavaStructureDensity;
    private static float globalDensity;
    private static final class_2680 AIR;
    private static class_2338.class_2339 popPos;
    private static final NetherBiome[][][] BIOMES;
    private static final List<class_2338> LIST_FLOOR;
    private static final List<class_2338> LIST_WALL;
    private static final List<class_2338> LIST_CEIL;
    private static final List<class_2338> LIST_LAVA;
    private static final HashSet<class_1959> MC_BIOMES;
    private static boolean hasCaves;
    private static boolean hasPaths;
    private static StructureCaves caves;
    private static StructurePath paths;
    private static NetherBiome biome;
    protected static int biomeSizeXZ;
    protected static int biomeSizeY;
    protected static boolean volumetric;
    public static final CityFeature CITY;
    public static final class_5312<class_3111, ? extends class_3195<class_3111>> CITY_CONFIGURED;

    public static void onModInit() {
        hasCleaningPass = Configs.GENERATOR.getBoolean("generator.world.terrain", "terrain_cleaning_pass", true);
        hasFixPass = Configs.GENERATOR.getBoolean("generator.world.terrain", "world_fixing_pass", true);
        hasCaves = Configs.GENERATOR.getBoolean("generator.world.environment", "generate_caves", true);
        hasPaths = Configs.GENERATOR.getBoolean("generator.world.environment", "generate_paths", true);
        cincinnasiteDensity = Configs.GENERATOR.getFloat("generator.world.ores", "cincinnasite_ore_density", 9.765625E-4f);
        rubyDensity = Configs.GENERATOR.getFloat("generator.world.ores", "ruby_ore_density", 2.5E-4f);
        lapisDensity = Configs.GENERATOR.getFloat("generator.world.ores", "lapis_ore_density", 2.5E-4f);
        structureDensity = Configs.GENERATOR.getFloat("generator.world", "structures_density", 0.0625f) * 1.0001f;
        lavaStructureDensity = Configs.GENERATOR.getFloat("generator.world", "lava_structures_density", 0.005f) * 1.0001f;
        globalDensity = Configs.GENERATOR.getFloat("generator.world", "global_plant_and_structures_density", 1.0f) * 1.0001f;
        biomeSizeXZ = Configs.GENERATOR.getInt("generator_world", "biome_size_xz", 200);
        biomeSizeY = Configs.GENERATOR.getInt("generator_world", "biome_size_y", 40);
        volumetric = Configs.GENERATOR.getBoolean("generator_world", "volumetric_biomes", true);
        int distance = Configs.GENERATOR.getInt("generator.world.cities", "distance", 64);
        int separation = distance >> 1;
        Configs.GENERATOR.getBoolean("generator.world.cities", "generate", true);
        FabricStructureBuilder.create((class_2960)new class_2960("betternether", "nether_city"), (class_3195)CITY).step(class_2893.class_2895.field_13174).defaultConfig(new class_5314(distance, separation, 1234)).superflatFeature(CITY_CONFIGURED).register();
        class_5458.method_30562((class_2378)class_5458.field_25930, (class_2960)new class_2960("betternether", "nether_city"), CITY_CONFIGURED);
    }

    public static void init(long seed) {
        caves = new StructureCaves(seed);
        paths = new StructurePath(seed + 1L);
    }

    private static NetherBiome getBiomeLocal(int x, int y, int z, Random random) {
        int px = (int)Math.round((double)x + random.nextGaussian() * 0.5) >> 1;
        int py = (int)Math.round((double)y + random.nextGaussian() * 0.5) >> 1;
        int pz = (int)Math.round((double)z + random.nextGaussian() * 0.5) >> 1;
        return BIOMES[BNWorldGenerator.clamp(px, 7)][BNWorldGenerator.clamp(py, 63)][BNWorldGenerator.clamp(pz, 7)];
    }

    private static int clamp(int x, int max) {
        return x < 0 ? 0 : (x > max ? max : x);
    }

    public static void populate(class_3233 world, int sx, int sz, Random random) {
        if (random.nextFloat() < structureDensity) {
            popPos.method_10103(sx + random.nextInt(16), MHelper.randRange(33, 100, random), sz + random.nextInt(16));
            StructureType type = StructureType.FLOOR;
            boolean isAir = world.method_8320((class_2338)popPos).method_26207().method_15800();
            boolean airUp = world.method_8320(popPos.method_10084()).method_26207().method_15800() && world.method_8320(popPos.method_10086(3)).method_26207().method_15800();
            boolean airDown = world.method_8320(popPos.method_10074()).method_26207().method_15800() && world.method_8320(popPos.method_10087(3)).method_26207().method_15800();
            NetherBiome biome = BNWorldGenerator.getBiomeLocal(popPos.method_10263() - sx, popPos.method_10264(), popPos.method_10260() - sz, random);
            if (!(isAir || airUp || airDown || random.nextInt(8) != 0)) {
                type = StructureType.UNDER;
            } else if (popPos.method_10264() < 45 || !biome.hasCeilStructures() || random.nextBoolean()) {
                if (!isAir) {
                    while (!world.method_8320((class_2338)popPos).method_26207().method_15800() && popPos.method_10264() > 1) {
                        popPos.method_10099(popPos.method_10264() - 1);
                    }
                }
                while (world.method_8320(popPos.method_10074()).method_26207().method_15800() && popPos.method_10264() > 1) {
                    popPos.method_10099(popPos.method_10264() - 1);
                }
            } else {
                if (!isAir) {
                    while (!world.method_8320((class_2338)popPos).method_26207().method_15800() && popPos.method_10264() > 1) {
                        popPos.method_10099(popPos.method_10264() + 1);
                    }
                }
                while (!BlocksHelper.isNetherGroundMagma(world.method_8320(popPos.method_10084())) && popPos.method_10264() < 127) {
                    popPos.method_10099(popPos.method_10264() + 1);
                }
                type = StructureType.CEIL;
            }
            biome = BNWorldGenerator.getBiomeLocal(popPos.method_10263() - sx, popPos.method_10264(), popPos.method_10260() - sz, random);
            if (world.method_8320((class_2338)popPos).method_26207().method_15800()) {
                class_2680 up;
                if (type == StructureType.FLOOR) {
                    class_2680 down = world.method_8320(popPos.method_10074());
                    if (BlocksHelper.isNetherGroundMagma(down)) {
                        biome.genFloorBuildings((class_5425)world, (class_2338)popPos, random);
                    }
                } else if (type == StructureType.CEIL && BlocksHelper.isNetherGroundMagma(up = world.method_8320(popPos.method_10084()))) {
                    biome.genCeilBuildings((class_5425)world, (class_2338)popPos, random);
                }
            } else {
                biome.genUnderBuildings((class_5425)world, (class_2338)popPos, random);
            }
        }
        if (random.nextFloat() < lavaStructureDensity) {
            popPos.method_10103(sx + random.nextInt(16), 32, sz + random.nextInt(16));
            if (world.method_22347((class_2338)popPos) && BlocksHelper.isLava(world.method_8320(popPos.method_10074()))) {
                biome = BNWorldGenerator.getBiomeLocal(popPos.method_10263() - sx, popPos.method_10264(), popPos.method_10260() - sz, random);
                biome.genLavaBuildings((class_5425)world, (class_2338)popPos, random);
            }
        }
        LIST_LAVA.clear();
        LIST_FLOOR.clear();
        LIST_WALL.clear();
        LIST_CEIL.clear();
        int ex = sx + 16;
        int ez = sz + 16;
        for (int x = 0; x < 16; ++x) {
            int wx = sx + x;
            for (int z = 0; z < 16; ++z) {
                int wz = sz + z;
                for (int y = 1; y < 126; ++y) {
                    if (caves.isInCave(x, y, z)) continue;
                    biome = BNWorldGenerator.getBiomeLocal(x, y, z, random);
                    popPos.method_10103(wx, y, wz);
                    class_2680 state = world.method_8320((class_2338)popPos);
                    boolean lava = BlocksHelper.isLava(state);
                    if (!lava && !BlocksHelper.isNetherGroundMagma(state) && state.method_26204() != class_2246.field_10255) continue;
                    if (!(lava || !(state = world.method_8320(popPos.method_10084())).method_26215() && state.method_26207().method_15804() && state.method_26207().method_15801() || !state.method_26227().method_15769())) {
                        biome.genSurfColumn((class_1936)world, (class_2338)popPos, random);
                    }
                    if ((x + y + z & 1) == 0 && random.nextFloat() < globalDensity && random.nextFloat() < biome.getPlantDensity()) {
                        if (world.method_22347(popPos.method_10084())) {
                            if (lava) {
                                LIST_LAVA.add(popPos.method_10084());
                            } else {
                                LIST_FLOOR.add(new class_2338((class_2382)popPos.method_10084()));
                            }
                        } else if (world.method_22347(popPos.method_10074())) {
                            LIST_CEIL.add(new class_2338((class_2382)popPos.method_10074()));
                        } else {
                            boolean bNorth = world.method_22347(popPos.method_10095());
                            boolean bSouth = world.method_22347(popPos.method_10072());
                            boolean bEast = world.method_22347(popPos.method_10078());
                            boolean bWest = world.method_22347(popPos.method_10067());
                            if (bNorth || bSouth || bEast || bWest) {
                                class_2338 objPos = null;
                                objPos = bNorth ? popPos.method_10095() : (bSouth ? popPos.method_10072() : (bEast ? popPos.method_10078() : popPos.method_10067()));
                                if (popPos.method_10263() >= sx && popPos.method_10263() < ex && popPos.method_10260() >= sz && popPos.method_10260() < ez) {
                                    boolean bDown = world.method_22347(objPos.method_10074());
                                    boolean bUp = world.method_22347(objPos.method_10084());
                                    if (bDown && bUp) {
                                        LIST_WALL.add(new class_2338((class_2382)objPos));
                                    }
                                }
                            }
                        }
                    }
                    if (random.nextFloat() < cincinnasiteDensity) {
                        BNWorldGenerator.spawnOre(BlocksRegistry.CINCINNASITE_ORE.method_9564(), (class_1936)world, (class_2338)popPos, random, 6, 14);
                    }
                    if (random.nextFloat() < rubyDensity) {
                        BNWorldGenerator.spawnOre(BlocksRegistry.NETHER_RUBY_ORE.method_9564(), (class_1936)world, (class_2338)popPos, random, 1, 5);
                    }
                    if (!(random.nextFloat() < lapisDensity)) continue;
                    BNWorldGenerator.spawnOre(BlocksRegistry.NETHER_LAPIS_ORE.method_9564(), (class_1936)world, (class_2338)popPos, random, 1, 6);
                }
            }
        }
        for (class_2338 pos : LIST_LAVA) {
            if (!world.method_22347(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random)) == null) continue;
            biome.genLavaObjects((class_5425)world, pos, random);
        }
        for (class_2338 pos : LIST_FLOOR) {
            if (!world.method_22347(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random)) == null) continue;
            biome.genFloorObjects((class_5425)world, pos, random);
        }
        for (class_2338 pos : LIST_WALL) {
            if (!world.method_22347(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random)) == null) continue;
            biome.genWallObjects((class_5425)world, pos, random);
        }
        for (class_2338 pos : LIST_CEIL) {
            if (!world.method_22347(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random)) == null) continue;
            biome.genCeilObjects((class_5425)world, pos, random);
        }
    }

    private static void makeLocalBiomes(class_3233 world, int sx, int sz) {
        MC_BIOMES.clear();
        for (int x = 0; x < 8; ++x) {
            popPos.method_20787(sx + (x << 1) + 2);
            for (int y = 0; y < 64; ++y) {
                popPos.method_10099((y << 1) + 2);
                for (int z = 0; z < 8; ++z) {
                    popPos.method_20788(sz + (z << 1) + 2);
                    class_1959 b = world.method_23753((class_2338)popPos);
                    BNWorldGenerator.BIOMES[x][y][z] = BiomesRegistry.getFromBiome(b);
                    MC_BIOMES.add(b);
                }
            }
        }
    }

    public static void prePopulate(class_3233 world, int sx, int sz, Random random) {
        BNWorldGenerator.makeLocalBiomes(world, sx, sz);
        if (hasCaves) {
            popPos.method_10103(sx, 0, sz);
            caves.generate((class_5425)world, (class_2338)popPos, random);
        }
        if (hasCleaningPass) {
            class_2338 up;
            ArrayList<class_2338> pos = new ArrayList<class_2338>();
            for (int y = 32; y < 110; ++y) {
                popPos.method_10099(y);
                for (int x = 0; x < 16; ++x) {
                    popPos.method_20787(x | sx);
                    for (int z = 0; z < 16; ++z) {
                        popPos.method_20788(z | sz);
                        if (!BNWorldGenerator.canReplace((class_1936)world, (class_2338)popPos)) continue;
                        up = popPos.method_10084();
                        class_2338 down = popPos.method_10074();
                        class_2338 north = popPos.method_10095();
                        class_2338 south = popPos.method_10072();
                        class_2338 east = popPos.method_10078();
                        class_2338 west = popPos.method_10067();
                        if (world.method_22347(north) && world.method_22347(south)) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(east) && world.method_22347(west)) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(up) && world.method_22347(down)) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(popPos.method_10095().method_10078().method_10074()) && world.method_22347(popPos.method_10072().method_10067().method_10084())) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(popPos.method_10072().method_10078().method_10074()) && world.method_22347(popPos.method_10095().method_10067().method_10084())) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(popPos.method_10095().method_10067().method_10074()) && world.method_22347(popPos.method_10072().method_10078().method_10084())) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (!world.method_22347(popPos.method_10072().method_10067().method_10074()) || !world.method_22347(popPos.method_10095().method_10078().method_10084())) continue;
                        pos.add(new class_2338((class_2382)popPos));
                    }
                }
            }
            for (class_2338 p : pos) {
                BlocksHelper.setWithoutUpdate((class_1936)world, p, AIR);
                up = p.method_10084();
                class_2680 state = world.method_8320(up);
                if (state.method_26204().method_9558(state, (class_4538)world, up)) continue;
                BlocksHelper.setWithoutUpdate((class_1936)world, up, AIR);
            }
        }
        if (hasPaths) {
            popPos.method_10103(sx, 0, sz);
            paths.generate((class_5425)world, (class_2338)popPos, random);
        }
    }

    private static boolean canReplace(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return BlocksHelper.isNetherGround(state) || state.method_26204() == class_2246.field_10255;
    }

    private static void spawnOre(class_2680 state, class_1936 world, class_2338 pos, Random random, int minSize, int maxSize) {
        int size = MHelper.randRange(minSize, maxSize, random);
        for (int i = 0; i < size; ++i) {
            class_2338 local = pos.method_10069(random.nextInt(3), random.nextInt(3), random.nextInt(3));
            if (!BlocksHelper.isNetherrack(world.method_8320(local))) continue;
            BlocksHelper.setWithoutUpdate(world, local, state);
        }
    }

    public static void cleaningPass(class_1936 world, int sx, int sz) {
        if (hasFixPass) {
            BNWorldGenerator.fixBlocks(world, sx, 30, sz, sx + 15, 110, sz + 15);
        }
    }

    private static void fixBlocks(class_1936 world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int y = y1; y <= y2; ++y) {
            popPos.method_10099(y);
            for (int x = x1; x <= x2; ++x) {
                popPos.method_20787(x);
                for (int z = z1; z <= z2; ++z) {
                    popPos.method_20788(z);
                    class_2680 state = world.method_8320((class_2338)popPos);
                    if (!state.method_26184((class_4538)world, (class_2338)popPos)) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, AIR);
                        continue;
                    }
                    if (!state.method_26225() && world.method_8320(popPos.method_10084()).method_26204() == class_2246.field_10266) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, class_2246.field_10266.method_9564());
                        continue;
                    }
                    if (BlocksHelper.isLava(state) && world.method_22347(popPos.method_10084()) && world.method_22347(popPos.method_10074())) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, AIR);
                        continue;
                    }
                    if (state.method_26204() == class_2246.field_10541 || state.method_26204() == class_2246.field_22115) {
                        if (!world.method_22347(popPos.method_10074()) || !world.method_22347(popPos.method_10084()) || !world.method_22347(popPos.method_10095()) || !world.method_22347(popPos.method_10072()) || !world.method_22347(popPos.method_10078()) || !world.method_22347(popPos.method_10067())) continue;
                        BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, AIR);
                        continue;
                    }
                    if (!(state.method_26204() instanceof BlockStalactite) || (state = world.method_8320(popPos.method_10074())).method_26234((class_1922)world, popPos.method_10074()) || state.method_26204() instanceof BlockStalactite) continue;
                    class_2338.class_2339 sp = new class_2338.class_2339().method_10101((class_2382)popPos);
                    while (world.method_8320((class_2338)sp).method_26204() instanceof BlockStalactite) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)sp, AIR);
                        sp.method_10093(class_2350.field_11036);
                    }
                }
            }
        }
    }

    public static HashSet<class_1959> getPopulateBiomes() {
        return MC_BIOMES;
    }

    static {
        AIR = class_2246.field_10124.method_9564();
        popPos = new class_2338.class_2339();
        BIOMES = new NetherBiome[8][64][8];
        LIST_FLOOR = new ArrayList<class_2338>(4096);
        LIST_WALL = new ArrayList<class_2338>(4096);
        LIST_CEIL = new ArrayList<class_2338>(4096);
        LIST_LAVA = new ArrayList<class_2338>(1024);
        MC_BIOMES = new HashSet();
        CITY = new CityFeature();
        CITY_CONFIGURED = CITY.method_28659((class_3037)class_3111.field_13603);
    }
}

