/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2919;
import net.minecraft.class_3532;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.world.BiomeChunk;

public class BiomeMap {
    private static final HashMap<class_1923, BiomeChunk> MAPS = new HashMap();
    private static final class_2919 RANDOM = new class_2919();
    private final int sizeXZ;
    private final int sizeY;
    protected final int maxHeight;
    private final int depth;
    private final int size;
    private final OpenSimplexNoise noiseX;
    private final OpenSimplexNoise noiseY;
    private final OpenSimplexNoise noiseZ;
    private final boolean volumetric;

    public BiomeMap(long seed, int sizeXZ, int sizeY, boolean volumetric) {
        MAPS.clear();
        RANDOM.setSeed(seed);
        this.noiseX = new OpenSimplexNoise(RANDOM.nextLong());
        this.noiseY = new OpenSimplexNoise(RANDOM.nextLong());
        this.noiseZ = new OpenSimplexNoise(RANDOM.nextLong());
        this.sizeXZ = sizeXZ;
        this.sizeY = sizeY;
        this.volumetric = volumetric;
        this.maxHeight = volumetric ? (int)Math.ceil(128.0f / (float)sizeY) : 1;
        this.depth = (int)Math.ceil(Math.log(Math.max(sizeXZ, sizeY)) / Math.log(2.0)) - 2;
        this.size = 1 << this.depth;
    }

    public void clearCache() {
        if (MAPS.size() > 16) {
            MAPS.clear();
        }
    }

    private NetherBiome getRawBiome(int bx, int by, int bz) {
        double x = bx * this.size / this.sizeXZ;
        double y = this.volumetric ? (double)(by * this.size / this.sizeY) : 0.0;
        double z = bz * this.size / this.sizeXZ;
        double nx = x;
        double ny = y;
        double nz = z;
        double px = (double)bx * 0.2;
        double py = (double)by * 0.2;
        double pz = (double)bz * 0.2;
        for (int i = 0; i < this.depth; ++i) {
            nx = (x + this.noiseX.eval(px, pz)) / 2.0;
            nz = (z + this.noiseZ.eval(px, pz)) / 2.0;
            if (this.volumetric) {
                nz = (z + this.noiseY.eval(px, pz)) / 2.0;
                y = ny;
                py = py / 2.0 + (double)i;
            }
            x = nx;
            z = nz;
            px = px / 2.0 + (double)i;
            pz = pz / 2.0 + (double)i;
        }
        class_1923 cpos = new class_1923((int)Math.floor(x / 16.0), (int)Math.floor(z / 16.0));
        BiomeChunk chunk = MAPS.get(cpos);
        if (chunk == null) {
            RANDOM.method_12659(cpos.field_9181, cpos.field_9180);
            chunk = new BiomeChunk(this, (Random)RANDOM);
            MAPS.put(cpos, chunk);
        }
        return chunk.getBiome((int)x, class_3532.method_15340((int)((int)y), (int)0, (int)(this.maxHeight - 1)), (int)z);
    }

    public NetherBiome getBiome(int x, int y, int z) {
        NetherBiome biome = this.getRawBiome(x, y > 30 ? y : 30, z);
        if (biome.hasEdge() || biome.hasParentBiome() && biome.getParentBiome().hasEdge()) {
            int d;
            NetherBiome search = biome;
            if (biome.hasParentBiome()) {
                search = biome.getParentBiome();
            }
            boolean edge = !search.isSame(this.getRawBiome(x + (d = (int)Math.ceil(search.getEdgeSize() / 4.0f) << 2), y, z));
            edge = edge || !search.isSame(this.getRawBiome(x - d, y, z));
            edge = edge || !search.isSame(this.getRawBiome(x, y, z + d));
            edge = edge || !search.isSame(this.getRawBiome(x, y, z - d));
            edge = edge || !search.isSame(this.getRawBiome(x - 1, y, z - 1));
            edge = edge || !search.isSame(this.getRawBiome(x - 1, y, z + 1));
            edge = edge || !search.isSame(this.getRawBiome(x + 1, y, z - 1));
            boolean bl = edge = edge || !search.isSame(this.getRawBiome(x + 1, y, z + 1));
            if (edge) {
                biome = search.getEdge();
            }
        }
        return biome;
    }
}

