/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blockentities.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;
import net.minecraft.class_837;
import paulevs.betternether.blockentities.BNSignBlockEntity;
import paulevs.betternether.blocks.BNSign;
import paulevs.betternether.registry.BlocksRegistry;

public class BNSignBlockEntityRenderer
implements class_827<BNSignBlockEntity> {
    private static final HashMap<class_2248, class_1921> LAYERS = Maps.newHashMap();
    private static class_1921 defaultLayer;
    private final Map<class_4719, class_837.class_4702> typeToModel = (Map)class_4719.method_24026().collect(ImmutableMap.toImmutableMap(signType -> signType, signType -> new class_837.class_4702(ctx.method_32140(class_5602.method_32078((class_4719)signType)))));
    private final class_327 textRenderer;
    private static final int RENDER_DISTANCE;
    private static final int GLOWING_BLACK_COLOR = -988212;

    public BNSignBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
    }

    public void render(BNSignBlockEntity signBlockEntity, float tickDelta, class_4587 matrixStack, class_4597 provider, int light, int overlay) {
        class_5481 orderedText;
        int lightLevel;
        boolean sldRender;
        int textColor;
        class_2680 state = signBlockEntity.method_11010();
        class_4719 signType = BNSignBlockEntityRenderer.getSignType(state.method_26204());
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.5, 0.5);
        float angle = -((float)((Integer)state.method_11654((class_2769)class_2508.field_11559) * 360) / 16.0f);
        class_837.class_4702 model = this.typeToModel.get(signType);
        class_2680 blockState = signBlockEntity.method_11010();
        if (((Boolean)blockState.method_11654((class_2769)BNSign.FLOOR)).booleanValue()) {
            matrixStack.method_22907(class_1160.field_20705.method_23214(angle));
            model.field_21531.field_3665 = true;
        } else {
            matrixStack.method_22907(class_1160.field_20705.method_23214(angle + 180.0f));
            matrixStack.method_22904(0.0, -0.3125, -0.4375);
            model.field_21531.field_3665 = false;
        }
        matrixStack.method_22903();
        matrixStack.method_22905(0.6666667f, -0.6666667f, -0.6666667f);
        class_4730 spriteIdentifier = class_4722.method_33082((class_4719)signType);
        Objects.requireNonNull(model);
        class_4588 vertexConsumer = BNSignBlockEntityRenderer.getConsumer(provider, state.method_26204());
        model.field_27756.method_22698(matrixStack, vertexConsumer, light, overlay);
        matrixStack.method_22909();
        matrixStack.method_22904(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStack.method_22905(0.010416667f, -0.010416667f, 0.010416667f);
        int color = BNSignBlockEntityRenderer.getColor(signBlockEntity);
        class_5481[] orderedTexts = signBlockEntity.updateSign(class_310.method_1551().method_33883(), text -> {
            List list = this.textRenderer.method_1728((class_5348)text, 90);
            class_5481 o = list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
            return o == null ? class_5481.field_26385 : o;
        });
        if (signBlockEntity.isGlowingText()) {
            textColor = signBlockEntity.getTextColor().method_16357();
            sldRender = BNSignBlockEntityRenderer.shouldRender(signBlockEntity, textColor);
            lightLevel = 0xF000F0;
        } else {
            textColor = color;
            sldRender = false;
            lightLevel = light;
        }
        for (int y = 0; y < 4; ++y) {
            orderedText = orderedTexts[y];
            if (orderedText == null) {
                orderedText = class_5481.field_26385;
            }
            float x = -this.textRenderer.method_30880(orderedText) / 2;
            if (sldRender) {
                this.textRenderer.method_37296(orderedText, x, (float)(y * 10 - 20), textColor, color, matrixStack.method_23760().method_23761(), provider, lightLevel);
                continue;
            }
            this.textRenderer.method_22942(orderedText, x, (float)(y * 10 - 20), textColor, false, matrixStack.method_23760().method_23761(), provider, false, 0, lightLevel);
        }
        for (int s = 0; s < 4; ++s) {
            orderedText = signBlockEntity.getTextBeingEditedOnRow(s, text -> {
                List list = this.textRenderer.method_1728((class_5348)text, 90);
                return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
            });
            if (orderedText == null) continue;
            float t = -this.textRenderer.method_30880(orderedText) / 2;
            this.textRenderer.method_22942(orderedText, t, (float)(s * 10 - 20), textColor, false, matrixStack.method_23760().method_23761(), provider, false, 0, light);
        }
        matrixStack.method_22909();
    }

    public static class_837.class_4702 createSignModel(class_5599 entityModelLoader, class_4719 type) {
        return new class_837.class_4702(entityModelLoader.method_32072(class_5602.method_32078((class_4719)type)));
    }

    private static boolean shouldRender(BNSignBlockEntity sign, int signColor) {
        if (signColor == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraftClient = class_310.method_1551();
        class_746 clientPlayerEntity = minecraftClient.field_1724;
        if (clientPlayerEntity != null && minecraftClient.field_1690.method_31044().method_31034() && clientPlayerEntity.method_31550()) {
            return true;
        }
        class_1297 entity = minecraftClient.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)sign.method_11016())) < (double)RENDER_DISTANCE;
    }

    public static class_4719 getSignType(class_2248 block) {
        class_4719 signType2 = block instanceof class_2478 ? ((class_2478)block).method_24025() : class_4719.field_21676;
        return signType2;
    }

    private static int getColor(BNSignBlockEntity sign) {
        int color = sign.getTextColor().method_16357();
        double k = 0.4;
        int r = (int)((double)class_1011.method_24033((int)color) * 0.4);
        int g = (int)((double)class_1011.method_24034((int)color) * 0.4);
        int b = (int)((double)class_1011.method_24035((int)color) * 0.4);
        return color == class_1767.field_7963.method_16357() && sign.isGlowingText() ? -988212 : class_1011.method_24031((int)0, (int)r, (int)g, (int)b);
    }

    public static class_4730 getModelTexture(class_2248 block) {
        class_4719 signType2 = block instanceof class_2478 ? ((class_2478)block).method_24025() : class_4719.field_21676;
        return class_4722.method_33082((class_4719)signType2);
    }

    public static class_4588 getConsumer(class_4597 provider, class_2248 block) {
        return provider.getBuffer(LAYERS.getOrDefault(block, defaultLayer));
    }

    static {
        RENDER_DISTANCE = class_3532.method_34954((int)16);
        defaultLayer = class_1921.method_23572((class_2960)new class_2960("textures/entity/signs/oak.png"));
        BlocksRegistry.getPossibleBlocks().forEach(name -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960("betternether", name));
            if (block instanceof BNSign) {
                class_1921 layer = class_1921.method_23572((class_2960)new class_2960("betternether", "textures/entity/signs/" + name + ".png"));
                LAYERS.put(block, layer);
            }
        });
    }
}

