/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1297;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import paulevs.betternether.entity.EntityNaga;

public class ModelNaga
extends class_4592<EntityNaga> {
    private static final int SPIKE_COUNT = 8;
    private static final int TAIL_COUNT = 4;
    public class_630 head;
    public class_630 body;
    public class_630[] tail;
    public class_630[] spikes;
    private float pitch;
    private float maxAngle = 0.1f;

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData_HEAD = modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-5.0f, -10.0f, -7.0f, 10.0f, 10.0f, 10.0f), class_5603.method_32090((float)0.0f, (float)-9.0f, (float)0.0f));
        class_5610 modelPartData_BODY = modelPartData.method_32117("body", class_5606.method_32108().method_32101(40, 0).method_32097(-2.0f, 0.0f, -1.0f, 4.0f, 20.0f, 2.0f).method_32101(0, 20).method_32097(-5.0f, 3.0f, -6.0f, 10.0f, 16.0f, 6.0f), class_5603.method_32090((float)0.0f, (float)-10.0f, (float)0.0f));
        modelPartData_BODY.method_32117("spike_0", class_5606.method_32108().method_32101(33, 25).method_32097(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0)), (float)0.0f));
        modelPartData_BODY.method_32117("spike_1", class_5606.method_32108().method_32101(33, 25).method_32097(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-140.0)), (float)0.0f));
        float[] tailPitch = new float[]{(float)Math.toRadians(45.0), (float)Math.toRadians(45.0), 0.0f, 0.0f};
        assert (tailPitch.length == 4);
        class_5610 tailParent = modelPartData_BODY;
        for (int i = 0; i < 4; ++i) {
            class_5610 modelPartData_TAIL;
            int width;
            int height = (4 - i) * 4 / 4;
            if (height < 2) {
                height = 2;
            }
            if ((width = Math.round((float)height / 2.0f)) < 1) {
                width = 1;
            }
            tailParent = modelPartData_TAIL = tailParent.method_32117("tail_" + i, class_5606.method_32108().method_32101(40, 0).method_32097((float)(-height) * 0.5f, 0.0f, (float)(-width) * 0.5f, (float)height, 20.0f, (float)width), class_5603.method_32091((float)0.0f, (float)19.0f, (float)0.0f, (float)tailPitch[i], (float)0.0f, (float)0.0f));
            if (i >= 3) continue;
            int px = 32 + (12 - height * 3);
            int index = (i << 1) + 2;
            modelPartData_TAIL.method_32117("spike_" + index, class_5606.method_32108().method_32101(px, 22).method_32097(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-60.0)), (float)0.0f));
            modelPartData_TAIL.method_32117("spike_" + ++index, class_5606.method_32108().method_32101(px, 22).method_32097(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-120.0)), (float)0.0f));
        }
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    public ModelNaga(class_630 root) {
        this.body = root.method_32086("body");
        this.head = root.method_32086("head");
        this.tail = new class_630[4];
        this.spikes = new class_630[8];
        this.spikes[0] = this.body.method_32086("spike_0");
        this.spikes[1] = this.body.method_32086("spike_1");
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                this.tail[0] = this.body.method_32086("tail_0");
            } else {
                this.tail[i] = this.tail[i - 1].method_32086("tail_" + i);
            }
            if (i >= 3) continue;
            int index = (i << 1) + 2;
            this.spikes[index] = this.tail[i].method_32086("spike_" + index);
            this.spikes[++index] = this.tail[i].method_32086("spike_" + index);
        }
    }

    protected Iterable<class_630> method_22946() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.body);
    }

    public void animateModel(EntityNaga livingEntity, float f, float g, float h) {
        this.pitch = livingEntity.method_6024(h);
        super.method_2816((class_1297)livingEntity, f, g, h);
    }

    public void setAngles(EntityNaga entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        int i;
        float angle;
        boolean rollTooBig = entity.method_6003() > 4;
        boolean isSwimming = entity.method_20232();
        this.head.field_3675 = headYaw * ((float)Math.PI / 180);
        this.head.field_3654 = rollTooBig ? -0.7853982f : (this.pitch > 0.0f ? (isSwimming ? this.lerpAngle(this.head.field_3654, -0.7853982f, this.pitch) : this.lerpAngle(this.head.field_3654, headPitch * ((float)Math.PI / 180), this.pitch)) : headPitch * ((float)Math.PI / 180));
        double speed = entity.method_24828() && (entity.method_18798().field_1352 != 0.0 || entity.method_18798().field_1350 != 0.0) && !entity.method_5765() ? 6.0 : 0.5;
        this.maxAngle = this.lerpAngle(this.maxAngle, speed > 1.0 ? 0.1f : 0.5f, 0.03f);
        double animation = (double)animationProgress * speed / 20.0;
        float start_angle = angle = (float)Math.sin(animation) * this.maxAngle * 0.3f;
        this.tail[0].field_3675 = angle;
        for (i = 1; i < this.tail.length; ++i) {
            angle = (float)Math.atan(Math.sin((double)i * 1.7 + animation)) * this.maxAngle;
            this.tail[i].field_3674 = angle - start_angle;
            start_angle += angle;
        }
        for (i = 0; i < this.spikes.length; ++i) {
            float yaw;
            this.spikes[i].field_3675 = yaw = (i & 1) == 0 ? (float)Math.toRadians(-50.0 + Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0) : (float)Math.toRadians(-110.0 - Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0);
        }
    }

    protected float lerpAngle(float from, float to, float position) {
        float angle = (to - from) % ((float)Math.PI * 2);
        if (angle < (float)(-Math.PI)) {
            angle += (float)Math.PI * 2;
        }
        if (angle >= (float)Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        return from + position * angle;
    }
}

