/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5458;
import paulevs.betternether.biomes.CrimsonGlowingWoods;
import paulevs.betternether.biomes.CrimsonPinewood;
import paulevs.betternether.biomes.FloodedDeltas;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.biomes.NetherBiomeWrapper;
import paulevs.betternether.biomes.NetherBoneReef;
import paulevs.betternether.biomes.NetherGrasslands;
import paulevs.betternether.biomes.NetherGravelDesert;
import paulevs.betternether.biomes.NetherJungle;
import paulevs.betternether.biomes.NetherMagmaLand;
import paulevs.betternether.biomes.NetherMushroomForest;
import paulevs.betternether.biomes.NetherMushroomForestEdge;
import paulevs.betternether.biomes.NetherPoorGrasslands;
import paulevs.betternether.biomes.NetherSoulPlain;
import paulevs.betternether.biomes.NetherSulfuricBoneReef;
import paulevs.betternether.biomes.NetherSwampland;
import paulevs.betternether.biomes.NetherSwamplandTerraces;
import paulevs.betternether.biomes.NetherWartForest;
import paulevs.betternether.biomes.NetherWartForestEdge;
import paulevs.betternether.biomes.OldFungiwoods;
import paulevs.betternether.biomes.OldSwampland;
import paulevs.betternether.biomes.OldWarpedWoods;
import paulevs.betternether.biomes.UpsideDownForest;
import paulevs.betternether.config.Config;
import paulevs.betternether.config.Configs;

public class BiomesRegistry {
    private static final ArrayList<NetherBiome> REGISTRY = new ArrayList();
    private static final ArrayList<NetherBiome> ALL_BIOMES = new ArrayList();
    private static final HashMap<class_1959, NetherBiome> MUTABLE = Maps.newHashMap();
    private static final ArrayList<NetherBiome> GENERATOR = new ArrayList();
    private static final Set<Integer> OCCUPIED_IDS = Sets.newHashSet();
    public static final NetherBiome BIOME_EMPTY_NETHER = new NetherBiomeWrapper(new class_2960("nether_wastes"));
    public static final NetherBiome BIOME_CRIMSON_FOREST = new NetherBiomeWrapper(new class_2960("crimson_forest"));
    public static final NetherBiome BIOME_WARPED_FOREST = new NetherBiomeWrapper(new class_2960("warped_forest"));
    public static final NetherBiome BIOME_BASALT_DELTAS = new NetherBiomeWrapper(new class_2960("basalt_deltas"));
    public static final NetherBiome BIOME_GRAVEL_DESERT = new NetherGravelDesert("Gravel Desert");
    public static final NetherBiome BIOME_NETHER_JUNGLE = new NetherJungle("Nether Jungle");
    public static final NetherBiome BIOME_WART_FOREST = new NetherWartForest("Wart Forest");
    public static final NetherBiome BIOME_GRASSLANDS = new NetherGrasslands("Nether Grasslands");
    public static final NetherBiome BIOME_MUSHROOM_FOREST = new NetherMushroomForest("Nether Mushroom Forest");
    public static final NetherBiome BIOME_MUSHROOM_FOREST_EDGE = new NetherMushroomForestEdge("Nether Mushroom Forest Edge");
    public static final NetherBiome BIOME_WART_FOREST_EDGE = new NetherWartForestEdge("Wart Forest Edge");
    public static final NetherBiome BIOME_BONE_REEF = new NetherBoneReef("Bone Reef");
    public static final NetherBiome BIOME_SULFURIC_BONE_REEF = new NetherSulfuricBoneReef("Sulfuric Bone Reef");
    public static final NetherBiome BIOME_POOR_GRASSLANDS = new NetherPoorGrasslands("Poor Nether Grasslands");
    public static final NetherBiome NETHER_SWAMPLAND = new NetherSwampland("Nether Swampland");
    public static final NetherBiome NETHER_SWAMPLAND_TERRACES = new NetherSwamplandTerraces("Nether Swampland Terraces");
    public static final NetherBiome MAGMA_LAND = new NetherMagmaLand("Magma Land");
    public static final NetherBiome SOUL_PLAIN = new NetherSoulPlain("Soul Plain");
    public static final NetherBiome CRIMSON_GLOWING_WOODS = new CrimsonGlowingWoods("Crimson Glowing Woods");
    public static final NetherBiome OLD_WARPED_WOODS = new OldWarpedWoods("Old Warped Woods");
    public static final NetherBiome CRIMSON_PINEWOOD = new CrimsonPinewood("Crimson Pinewood");
    public static final NetherBiome OLD_FUNGIWOODS = new OldFungiwoods("Old Fungiwoods");
    public static final NetherBiome FLOODED_DELTAS = new FloodedDeltas("Flooded Deltas");
    public static final NetherBiome UPSIDE_DOWN_FOREST = new UpsideDownForest("Upside Down Forest");
    public static final NetherBiome OLD_SWAMPLAND = new OldSwampland("Old Swampland");
    private static int maxDefChance = 0;
    private static int maxChance = 0;
    private static int biomeID = 7000;

    public static void register() {
        class_5458.field_25933.forEach(biome -> {
            if (biome.method_8688() == class_1959.class_1961.field_9366) {
                class_2960 id = class_5458.field_25933.method_10221(biome);
                Configs.GENERATOR.getFloat("biomes." + id.method_12836() + ".main", id.method_12832() + "_chance", 1.0f);
            }
        });
        BiomesRegistry.registerNetherBiome(BIOME_GRAVEL_DESERT);
        BiomesRegistry.registerNetherBiome(BIOME_NETHER_JUNGLE);
        BiomesRegistry.registerNetherBiome(BIOME_WART_FOREST);
        BiomesRegistry.registerNetherBiome(BIOME_GRASSLANDS);
        BiomesRegistry.registerNetherBiome(BIOME_MUSHROOM_FOREST);
        BiomesRegistry.registerEdgeBiome(BIOME_MUSHROOM_FOREST_EDGE, BIOME_MUSHROOM_FOREST, 2);
        BiomesRegistry.registerEdgeBiome(BIOME_WART_FOREST_EDGE, BIOME_WART_FOREST, 2);
        BiomesRegistry.registerNetherBiome(BIOME_BONE_REEF);
        BiomesRegistry.registerSubBiome(BIOME_SULFURIC_BONE_REEF, BIOME_BONE_REEF, 0.3f);
        BiomesRegistry.registerSubBiome(BIOME_POOR_GRASSLANDS, BIOME_GRASSLANDS, 0.3f);
        BiomesRegistry.registerNetherBiome(NETHER_SWAMPLAND);
        BiomesRegistry.registerSubBiome(NETHER_SWAMPLAND_TERRACES, NETHER_SWAMPLAND, 1.0f);
        BiomesRegistry.registerNetherBiome(MAGMA_LAND);
        BiomesRegistry.registerSubBiome(SOUL_PLAIN, BIOME_WART_FOREST, 1.0f);
        BiomesRegistry.registerSubBiome(CRIMSON_GLOWING_WOODS, BIOME_CRIMSON_FOREST, 0.3f);
        BiomesRegistry.registerSubBiome(OLD_WARPED_WOODS, BIOME_WARPED_FOREST, 1.0f);
        BiomesRegistry.registerSubBiome(CRIMSON_PINEWOOD, BIOME_CRIMSON_FOREST, 0.3f);
        BiomesRegistry.registerSubBiome(OLD_FUNGIWOODS, BIOME_MUSHROOM_FOREST, 0.3f);
        BiomesRegistry.registerSubBiome(FLOODED_DELTAS, BIOME_BASALT_DELTAS, 1.0f);
        BiomesRegistry.registerNetherBiome(UPSIDE_DOWN_FOREST);
        BiomesRegistry.registerSubBiome(OLD_SWAMPLAND, NETHER_SWAMPLAND, 1.0f);
        BiomesRegistry.registerNetherBiome(BIOME_EMPTY_NETHER);
        BiomesRegistry.registerNetherBiome(BIOME_CRIMSON_FOREST);
        BiomesRegistry.registerNetherBiome(BIOME_WARPED_FOREST);
        BiomesRegistry.registerNetherBiome(BIOME_BASALT_DELTAS);
        RegistryEntryAddedCallback.event((class_2378)class_5458.field_25933).register((i, id, biome) -> {
            if (biome.method_8688() == class_1959.class_1961.field_9366) {
                class_2960 bioID = class_5458.field_25933.method_10221(biome);
                Configs.GENERATOR.getFloat("biomes." + bioID.method_12836() + ".main", bioID.method_12832() + "_chance", 1.0f);
            }
        });
    }

    public static void mutateRegistry(class_2378<class_1959> biomeRegistry) {
        GENERATOR.clear();
        GENERATOR.addAll(REGISTRY);
        MUTABLE.clear();
        for (NetherBiome netherBiome : BiomesRegistry.getAllBiomes()) {
            class_1959 biome = (class_1959)biomeRegistry.method_10223(netherBiome.getID());
            netherBiome.setActualBiome(biome);
            MUTABLE.put(biome, netherBiome);
        }
        if (maxDefChance == 0) {
            maxDefChance = maxChance;
        }
        maxChance = maxDefChance;
        for (class_1959 biome : biomeRegistry) {
            if (biome.method_8688() != class_1959.class_1961.field_9366 || MUTABLE.containsKey(biome)) continue;
            class_2960 id = biomeRegistry.method_10221((Object)biome);
            NetherBiomeWrapper netherBiome = new NetherBiomeWrapper(biomeRegistry.method_10221((Object)biome), biome);
            netherBiome.setActualBiome(biome);
            MUTABLE.put(biome, netherBiome);
            float chance = Configs.GENERATOR.getFloat("biomes." + id.method_12836() + ".main", id.method_12832() + "_chance", 1.0f);
            if (!(chance > 0.0f)) continue;
            maxChance = (int)((float)maxChance + chance);
            netherBiome.setGenChance(maxChance);
            String path = "generator.biome." + netherBiome.getID().method_12836() + "." + netherBiome.getID().method_12832();
            netherBiome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            netherBiome.build();
            GENERATOR.add(netherBiome);
        }
        Config.save();
    }

    private static void register(NetherBiome biome) {
        if (class_5458.field_25933.method_10223(biome.getID()) == null) {
            if (OCCUPIED_IDS.isEmpty()) {
                class_5458.field_25933.forEach(bio -> OCCUPIED_IDS.add(class_5458.field_25933.method_10206(bio)));
            }
            ++biomeID;
            while (OCCUPIED_IDS.contains(biomeID)) {
                ++biomeID;
            }
            class_2378.method_10231((class_2378)class_5458.field_25933, (int)biomeID, (String)biome.getID().toString(), (Object)biome.getBiome());
        }
    }

    public static void registerNetherBiome(NetherBiome biome) {
        float chance = Configs.GENERATOR.getFloat("biomes." + biome.getID().method_12836() + ".main", biome.getID().method_12832() + "_chance", 1.0f);
        if (chance > 0.0f) {
            maxChance = (int)((float)maxChance + chance);
            String path = "generator.biome." + biome.getID().method_12836() + "." + biome.getID().method_12832();
            biome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            biome.setGenChance(maxChance);
            biome.build();
            REGISTRY.add(biome);
            ALL_BIOMES.add(biome);
            BiomesRegistry.register(biome);
        }
    }

    public static void registerEdgeBiome(NetherBiome biome, NetherBiome mainBiome, int size) {
        String regName = biome.getRegistryName();
        float sizeConf = Configs.GENERATOR.getFloat("biomes.betternether.edge", regName + "_size", size);
        if (sizeConf > 0.0f) {
            String path = "generator.biome." + biome.getID().method_12836() + "." + biome.getID().method_12832();
            biome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            mainBiome.setEdge(biome);
            mainBiome.setEdgeSize(sizeConf);
            biome.build();
            ALL_BIOMES.add(biome);
            BiomesRegistry.register(biome);
        }
    }

    public static void registerSubBiome(NetherBiome biome, NetherBiome mainBiome, float chance) {
        String regName = biome.getRegistryName();
        chance = Configs.GENERATOR.getFloat("biomes.betternether.variation", regName + "_chance", chance);
        if (chance > 0.0f) {
            String path = "generator.biome." + biome.getID().method_12836() + "." + biome.getID().method_12832();
            biome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            mainBiome.addSubBiome(biome, chance);
            biome.build();
            ALL_BIOMES.add(biome);
            BiomesRegistry.register(biome);
        }
    }

    public static NetherBiome getBiome(Random random) {
        float chance = random.nextFloat() * (float)maxChance;
        for (NetherBiome biome : GENERATOR) {
            if (!biome.canGenerate(chance)) continue;
            return biome;
        }
        return BIOME_EMPTY_NETHER;
    }

    public static NetherBiome getFromBiome(class_1959 biome) {
        return MUTABLE.getOrDefault(biome, BIOME_EMPTY_NETHER);
    }

    public static ArrayList<NetherBiome> getRegisteredBiomes() {
        return REGISTRY;
    }

    public static ArrayList<NetherBiome> getAllBiomes() {
        return ALL_BIOMES;
    }
}

