/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.decorations;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockStalactite;
import paulevs.betternether.structures.IStructure;

public class StructureStalactiteFloor
implements IStructure {
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private final class_2248 block;
    private final class_2248 under;
    private final class_2248[] ground;

    public StructureStalactiteFloor(class_2248 block, class_2248 under) {
        this.block = block;
        this.ground = null;
        this.under = under;
    }

    public StructureStalactiteFloor(class_2248 block, class_2248 under, class_2248 ... ground) {
        this.block = block;
        this.under = under;
        this.ground = ground;
    }

    private boolean canPlaceAt(class_5425 world, class_2338 pos) {
        return world.method_22347(pos) && (this.ground == null ? BlocksHelper.isNetherGround(world.method_8320(pos.method_10074())) : this.groundContains(world.method_8320(pos.method_10074()).method_26204()));
    }

    private boolean groundContains(class_2248 block) {
        for (class_2248 b : this.ground) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        if (this.canPlaceAt(world, pos)) {
            block0: for (int i = 0; i < 16; ++i) {
                int offset;
                boolean stalagnate;
                int h;
                int dz;
                int x = pos.method_10263() + (int)(random.nextGaussian() * 2.0);
                int z = pos.method_10260() + (int)(random.nextGaussian() * 2.0);
                POS.method_10103(x, pos.method_10264(), z);
                int y = pos.method_10264() - BlocksHelper.downRay((class_1936)world, (class_2338)POS, 8);
                if (!this.canPlaceAt(world, (class_2338)POS)) continue;
                int dx = x - pos.method_10263();
                float dist = 4.0f - (float)Math.sqrt(dx * dx + (dz = z - pos.method_10260()) * dz);
                if (dist < 1.0f) {
                    dist = 1.0f;
                }
                h = (h = (int)((float)random.nextInt((int)Math.ceil(dist + 1.0f)) + dist + (float)random.nextInt(2))) > 8 ? 8 : h;
                POS.method_33098(y);
                int h2 = BlocksHelper.upRay((class_1936)world, (class_2338)POS, h + 2) + 1;
                POS.method_33098(y + h2);
                boolean bl = stalagnate = h2 <= h && BlocksHelper.isNetherrack(world.method_8320((class_2338)POS));
                if (h2 <= h) {
                    h = h2;
                }
                int n = stalagnate ? (h < 8 ? MHelper.randRange(0, 8 - h, random) : 0) : (offset = 0);
                if (this.under != null && h > 2) {
                    POS.method_33098(y - 1);
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, this.under.method_9564());
                    if (stalagnate) {
                        POS.method_33098(y + h);
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, this.under.method_9564());
                    }
                }
                for (int n2 = 0; n2 < h; ++n2) {
                    POS.method_33098(y + n2);
                    if (!world.method_22347((class_2338)POS)) continue block0;
                    int size = stalagnate ? Math.abs(h / 2 - n2) + offset : h - n2 - 1;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, (class_2680)this.block.method_9564().method_11657((class_2769)BlockStalactite.SIZE, (Comparable)Integer.valueOf(size)));
                }
            }
        }
    }
}

