/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockPlantWall;
import paulevs.betternether.blocks.BlockProperties;
import paulevs.betternether.blocks.RubeusLog;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.StructureFuncScatter;

public class StructureRubeus
extends StructureFuncScatter {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final int MIDDLE_Y = 10;
    private static final Set<class_2338> POINTS = new HashSet<class_2338>();
    private static final Set<class_2338> MIDDLE = new HashSet<class_2338>();
    private static final Set<class_2338> TOP = new HashSet<class_2338>();

    public StructureRubeus() {
        super(7);
    }

    @Override
    public void grow(class_5425 world, class_2338 pos, Random random) {
        this.grow(world, pos, random, true);
    }

    public void grow(class_5425 world, class_2338 pos, Random random, boolean natural) {
        world.method_8652(pos, class_2246.field_10124.method_9564(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.method_10264() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 5.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((class_1936)world, x1, y1 + 1, z1, crownR, random);
            int middle = Math.round((float)pos.method_10264() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.method_10264() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.method_8320((class_2338)POS.method_10103(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.method_8320((class_2338)POS.method_10103(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.method_10263();
                        y2 = pos.method_10264();
                        generate = false;
                    }
                }
                this.line((class_1936)world, x1, y1, z1, x2, y2, z2, middle);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<class_2338> iterator = TOP.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos == null || !POINTS.contains(bpos.method_10084()) || TOP.contains(bpos.method_10084())) continue;
            iterator.remove();
        }
        iterator = MIDDLE.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos != null) {
                class_2338 up = bpos.method_10084();
                if (!MIDDLE.contains(up) && (TOP.contains(up) || !POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (class_2338 bpos : POINTS) {
            class_2680 state;
            if (POINTS.contains(bpos.method_10084()) && POINTS.contains(bpos.method_10074())) {
                state = BlocksRegistry.RUBEUS_LOG.method_9564();
                if (MIDDLE.contains(bpos)) {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)), false, random);
                    continue;
                }
                if (TOP.contains(bpos)) {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)), false, random);
                    continue;
                }
                this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)), natural, random);
                continue;
            }
            state = BlocksRegistry.RUBEUS_BARK.method_9564();
            if (MIDDLE.contains(bpos)) {
                this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)), false, random);
                continue;
            }
            if (TOP.contains(bpos)) {
                this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)), false, random);
                continue;
            }
            this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)), natural, random);
        }
        POINTS.clear();
        MIDDLE.clear();
        TOP.clear();
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        int length = BlocksHelper.upRay((class_1936)world, pos, 27);
        if (length >= 25) {
            super.generate(world, pos, random);
        }
    }

    @Override
    protected boolean isStructure(class_2680 state) {
        return state.method_26204() == BlocksRegistry.RUBEUS_LOG;
    }

    @Override
    protected boolean isGround(class_2680 state) {
        return BlocksHelper.isNetherGround(state);
    }

    private void line(class_1936 world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        class_2338 pos = POS.method_10103(x1, y1, z1).method_10062();
        POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            TOP.add(pos);
        }
        pos = POS.method_10103(x2, y2, z2).method_10062();
        POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            POS.method_10103(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = POS.method_10062();
            POINTS.add(pos);
            if (POS.method_10264() == middleY) {
                MIDDLE.add(pos);
                continue;
            }
            if (POS.method_10264() <= middleY) continue;
            TOP.add(pos);
        }
    }

    private void crown(class_1936 world, int x, int y, int z, float radius, Random random) {
        int start;
        class_2680 leaves = BlocksRegistry.RUBEUS_LEAVES.method_9564();
        class_2680 cone = BlocksRegistry.RUBEUS_CONE.method_9564();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.method_33098((int)((float)(y + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.method_33097(x + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.method_33099(z + cz);
                        this.setIfAirLeaves(world, (class_2338)POS, leaves);
                        if ((POS.method_10263() + POS.method_10260() & 1) == 0 && random.nextInt(6) == 0) {
                            this.setIfAir(world, POS.method_10074(), cone);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private void setCondition(class_1936 world, class_2338 pos, int y, class_2680 state, boolean moss, Random random) {
        if (pos.method_10264() > y) {
            this.setIfAir(world, pos, state);
        } else {
            this.setIfGroundOrAir(world, pos, state);
        }
        if (moss && Math.abs(pos.method_10264() - y) < 4) {
            for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                if (random.nextInt(3) <= 0) continue;
                this.setIfAir(world, pos.method_10093(dir), (class_2680)BlocksRegistry.JUNGLE_MOSS.method_9564().method_11657((class_2769)BlockPlantWall.FACING, (Comparable)dir));
            }
        }
    }

    private void setIfAir(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 bState = world.method_8320(pos);
        if (world.method_22347(pos) || bState.method_26207().method_15800() || bState.method_26204() == BlocksRegistry.RUBEUS_LEAVES || bState.method_26204() == BlocksRegistry.RUBEUS_CONE) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfGroundOrAir(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 bState = world.method_8320(pos);
        if (bState.method_26215() || bState.method_26204() == BlocksRegistry.RUBEUS_LEAVES || bState.method_26207().method_15800() || BlocksHelper.isNetherGround(bState)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfAirLeaves(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 bState = world.method_8320(pos);
        if (world.method_22347(pos) || bState.method_26207().method_15800()) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }
}

