/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.Random;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.registry.BiomesRegistry;
import paulevs.betternether.world.BiomeMap;

public class BiomeChunk {
    protected static final int WIDTH = 16;
    private static final int SM_WIDTH = 8;
    private static final int MASK_A = 7;
    private static final int MASK_C = 15;
    private final int maxY;
    private final int maskB;
    private final NetherBiome[][][] biomes;

    public BiomeChunk(BiomeMap map, Random random) {
        int z;
        int x;
        int y;
        int sm_height = this.clampOne(map.maxHeight >> 1);
        this.maskB = sm_height - 1;
        this.maxY = map.maxHeight - 1;
        NetherBiome[][][] PreBio = new NetherBiome[sm_height][8][8];
        this.biomes = new NetherBiome[map.maxHeight][16][16];
        for (y = 0; y < sm_height; ++y) {
            for (x = 0; x < 8; ++x) {
                for (z = 0; z < 8; ++z) {
                    PreBio[y][x][z] = BiomesRegistry.getBiome(random);
                }
            }
        }
        for (y = 0; y < map.maxHeight; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.biomes[y][x][z] = PreBio[this.offsetY(y, random)][this.offsetXZ(x, random)][this.offsetXZ(z, random)].getSubBiome(random);
                }
            }
        }
    }

    public NetherBiome getBiome(int x, int y, int z) {
        return this.biomes[this.clamp(y)][x & 0xF][z & 0xF];
    }

    private int offsetXZ(int x, Random random) {
        return x + random.nextInt(2) >> 1 & 7;
    }

    private int offsetY(int y, Random random) {
        return y + random.nextInt(2) >> 1 & this.maskB;
    }

    private int clamp(int y) {
        return y < 0 ? 0 : (y > this.maxY ? this.maxY : y);
    }

    private int clampOne(int x) {
        return x < 1 ? 1 : x;
    }
}

