/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5314;
import paulevs.betternether.world.BNWorldGenerator;

public class CityHelper {
    private static final Set<class_1923> POSITIONS = new HashSet<class_1923>(16);
    private static final class_2338.class_2339 POS = new class_2338.class_2339();

    public static boolean stopStructGen(int chunkX, int chunkZ, class_2794 chunkGenerator, long worldSeed, class_2919 chunkRandom) {
        class_5314 config = chunkGenerator.method_12109().method_28600((class_3195)BNWorldGenerator.CITY);
        if (config != null && config.method_28803() > 0) {
            CityHelper.collectNearby(chunkX, chunkZ, config, worldSeed, chunkRandom);
        }
        return CityHelper.stopGeneration(chunkX, chunkZ);
    }

    private static void collectNearby(int chunkX, int chunkZ, class_5314 config, long worldSeed, class_2919 chunkRandom) {
        int x1 = chunkX - 16;
        int x2 = chunkX + 16;
        int z1 = chunkZ - 16;
        int z2 = chunkZ + 16;
        POSITIONS.clear();
        for (int x = x1; x <= x2; x += 8) {
            for (int z = z1; z <= z2; z += 8) {
                class_1923 chunk = BNWorldGenerator.CITY.method_27218(config, worldSeed, chunkRandom, x, z);
                POSITIONS.add(chunk);
            }
        }
    }

    private static void collectNearby(class_3218 world, int chunkX, int chunkZ, class_5314 config, long worldSeed, class_2919 chunkRandom) {
        int x1 = chunkX - 16;
        int x2 = chunkX + 16;
        int z1 = chunkZ - 16;
        int z2 = chunkZ + 16;
        POSITIONS.clear();
        POS.method_33098(64);
        for (int x = x1; x <= x2; x += 8) {
            POS.method_33097(x << 4);
            for (int z = z1; z <= z2; z += 8) {
                POS.method_33099(z << 4);
                if (!world.method_23753((class_2338)POS).method_30970().method_30980((class_3195)BNWorldGenerator.CITY)) continue;
                class_1923 chunk = BNWorldGenerator.CITY.method_27218(config, worldSeed, chunkRandom, x, z);
                POSITIONS.add(chunk);
            }
        }
    }

    private static boolean stopGeneration(int chunkX, int chunkZ) {
        for (class_1923 p : POSITIONS) {
            int dx = p.field_9181 - chunkX;
            int dz = p.field_9180 - chunkZ;
            if (dx * dx + dz * dz >= 64) continue;
            return true;
        }
        return false;
    }

    private static long sqr(int x) {
        return (long)x * (long)x;
    }

    public static class_2338 getNearestCity(class_2338 pos, class_3218 world) {
        int cx = pos.method_10263() >> 4;
        int cz = pos.method_10260() >> 4;
        class_5314 config = world.method_14178().method_12129().method_12109().method_28600((class_3195)BNWorldGenerator.CITY);
        if (config == null || config.method_28803() < 1) {
            return null;
        }
        CityHelper.collectNearby(world, cx, cz, config, world.method_8412(), new class_2919());
        Iterator<class_1923> iterator = POSITIONS.iterator();
        if (iterator.hasNext()) {
            class_1923 nearest = POSITIONS.iterator().next();
            long d = CityHelper.sqr(nearest.field_9181 - cx) + CityHelper.sqr(nearest.field_9180 - cz);
            while (iterator.hasNext()) {
                class_1923 n = iterator.next();
                long d2 = CityHelper.sqr(n.field_9181 - cx) + CityHelper.sqr(n.field_9180 - cz);
                if (d2 >= d) continue;
                d = d2;
                nearest = n;
            }
            return nearest.method_8323();
        }
        return null;
    }
}

