/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay.client;

import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.vladmarica.betterpingdisplay.BetterPingDisplayConfig;
import com.vladmarica.betterpingdisplay.BetterPingDisplayMod;
import com.vladmarica.betterpingdisplay.client.PlayerComparator;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderPingHandler {
    private static final Ordering<PlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private static final int DEFAULT_PING_TEXT_COLOR = 0xA0A0A0;
    private static final String DEFAULT_PING_TEXT_FORMAT = "%dms";
    private static final int PING_TEXT_RENDER_OFFSET = -13;
    private static final int PLAYER_SLOT_EXTRA_WIDTH = 45;
    private static final int PLAYER_ICON_WIDTH = 9;
    private boolean configLoaded = false;
    private int pingTextColor;
    private String pingTextFormat;

    public void loadConfig() {
        if (BetterPingDisplayConfig.textColor.startsWith("#")) {
            try {
                this.pingTextColor = Integer.parseInt(BetterPingDisplayConfig.textColor.substring(1), 16);
            }
            catch (NumberFormatException ex) {
                BetterPingDisplayMod.logger().error("Config option 'pingTextColor' is invalid - it must be a hex color code");
                this.pingTextColor = 0xA0A0A0;
            }
        } else {
            this.pingTextColor = 0xA0A0A0;
        }
        if (BetterPingDisplayConfig.textFormatString.contains("%d")) {
            this.pingTextFormat = BetterPingDisplayConfig.textFormatString;
        } else {
            this.pingTextFormat = DEFAULT_PING_TEXT_FORMAT;
            BetterPingDisplayMod.logger().error("Config option 'textFormatString' is invalid - it needs to contain %d");
        }
    }

    @SubscribeEvent
    public void onRenderGuiPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
            if (!this.configLoaded) {
                this.loadConfig();
                this.configLoaded = true;
            }
            this.renderPlayerList(event.getMatrixStack(), Minecraft.m_91087_());
        }
    }

    private void renderPlayerList(PoseStack matrixStack, Minecraft mc) {
        boolean displayPlayerIcons;
        int playerCount;
        PlayerTabOverlay playerListGui = mc.f_91065_.m_93088_();
        int width = mc.m_91268_().m_85445_();
        Scoreboard scoreboard = mc.f_91073_.m_6188_();
        Objective objective = scoreboard.m_83416_(0);
        ClientPacketListener handler = mc.f_91074_.f_108617_;
        List playerList = ENTRY_ORDERING.sortedCopy((Iterable)handler.m_105142_());
        int i = 0;
        int j = 0;
        for (PlayerInfo playerInfo : playerList) {
            int nameStringWidth = mc.f_91062_.m_92852_((FormattedText)playerListGui.m_94549_(playerInfo));
            i = Math.max(i, nameStringWidth);
            if (objective == null || objective.m_83324_() == ObjectiveCriteria.RenderType.HEARTS) continue;
            nameStringWidth = mc.f_91062_.m_92895_(" " + scoreboard.m_83471_(playerInfo.m_105312_().getName(), objective).m_83400_());
            j = Math.max(j, nameStringWidth);
        }
        playerList = playerList.subList(0, Math.min(playerList.size(), 80));
        int j4 = playerCount = playerList.size();
        int k4 = 1;
        while (j4 > 20) {
            j4 = (playerCount + ++k4 - 1) / k4;
        }
        boolean bl = displayPlayerIcons = mc.m_91090_() || mc.m_91403_().m_6198_().m_129535_();
        int l = objective != null ? (objective.m_83324_() == ObjectiveCriteria.RenderType.HEARTS ? 90 : j) : 0;
        int i1 = Math.min(k4 * ((displayPlayerIcons ? 9 : 0) + i + l + 13 + 45), width - 50) / k4;
        int j1 = width / 2 - (i1 * k4 + (k4 - 1) * 5) / 2;
        int k1 = 10;
        int l1 = i1 * k4 + (k4 - 1) * 5;
        List list1 = null;
        if (playerListGui.f_94522_ != null) {
            list1 = mc.f_91062_.m_92923_((FormattedText)playerListGui.f_94522_, width - 50);
            for (Object s : list1) {
                l1 = Math.max(l1, mc.f_91062_.m_92724_((FormattedCharSequence)s));
            }
        }
        List list2 = null;
        if (playerListGui.f_94521_ != null) {
            list2 = mc.f_91062_.m_92923_((FormattedText)playerListGui.f_94521_, width - 50);
            for (FormattedCharSequence s1 : list2) {
                l1 = Math.max(l1, mc.f_91062_.m_92724_(s1));
            }
        }
        if (list1 != null) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + list1.size() * 9), (int)Integer.MIN_VALUE);
            for (FormattedCharSequence s2 : list1) {
                int i2 = mc.f_91062_.m_92724_(s2);
                mc.f_91062_.m_92744_(matrixStack, s2, (float)(width / 2 - i2 / 2), (float)k1, -1);
                k1 += 9;
            }
            ++k1;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + j4 * 9), (int)Integer.MIN_VALUE);
        int l4 = mc.f_91066_.m_92143_(0x20FFFFFF);
        for (int playerIndex = 0; playerIndex < playerCount; ++playerIndex) {
            int l5;
            int i6;
            int j5 = playerIndex / j4;
            int j2 = playerIndex % j4;
            int k2 = j1 + j5 * i1 + j5 * 5;
            int l2 = k1 + j2 * 9;
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)k2, (int)l2, (int)(k2 + i1), (int)(l2 + 8), (int)l4);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            if (playerIndex >= playerList.size()) continue;
            PlayerInfo player = (PlayerInfo)playerList.get(playerIndex);
            GameProfile gameprofile = player.m_105312_();
            if (displayPlayerIcons) {
                Player playerentity = mc.f_91073_.m_46003_(gameprofile.getId());
                boolean flag1 = playerentity != null && playerentity.m_36170_(PlayerModelPart.CAPE) && ("Dinnerbone".equals(gameprofile.getName()) || "Grumm".equals(gameprofile.getName()));
                RenderSystem.m_157456_((int)0, (ResourceLocation)player.m_105337_());
                int i3 = 8 + (flag1 ? 8 : 0);
                int j3 = 8 * (flag1 ? -1 : 1);
                GuiComponent.m_93160_((PoseStack)matrixStack, (int)k2, (int)l2, (int)8, (int)8, (float)8.0f, (float)i3, (int)8, (int)j3, (int)64, (int)64);
                if (playerentity != null && playerentity.m_36170_(PlayerModelPart.HAT)) {
                    int k3 = 8 + (flag1 ? 8 : 0);
                    int l3 = 8 * (flag1 ? -1 : 1);
                    GuiComponent.m_93160_((PoseStack)matrixStack, (int)k2, (int)l2, (int)8, (int)8, (float)40.0f, (float)k3, (int)8, (int)l3, (int)64, (int)64);
                }
                k2 += 9;
            }
            Component displayName = playerListGui.m_94549_(player);
            int nameColor = player.m_105325_() == GameType.SPECTATOR ? -1862270977 : -1;
            mc.f_91062_.m_92763_(matrixStack, displayName, (float)k2, (float)l2, nameColor);
            if (objective != null && player.m_105325_() != GameType.SPECTATOR && (i6 = (l5 = k2 + i + 1) + l) - l5 > 5) {
                playerListGui.m_94530_(objective, l2, gameprofile.getName(), l5, i6, player, matrixStack);
            }
            String pingString = String.format(this.pingTextFormat, player.m_105330_());
            int pingStringWidth = mc.f_91062_.m_92895_(pingString);
            mc.f_91062_.m_92763_(matrixStack, (Component)new TextComponent(pingString), (float)i1 + (float)k2 - (float)pingStringWidth + -13.0f - (float)(displayPlayerIcons ? 9 : 0), (float)l2, this.pingTextColor);
            playerListGui.m_94538_(matrixStack, i1, k2 - (displayPlayerIcons ? 9 : 0), l2, player);
        }
        if (list2 != null) {
            k1 = k1 + j4 * 9 + 1;
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + list2.size() * 9), (int)Integer.MIN_VALUE);
            for (FormattedCharSequence s3 : list2) {
                int k5 = mc.f_91062_.m_92724_(s3);
                mc.f_91062_.m_92744_(matrixStack, s3, (float)(width / 2 - k5 / 2), (float)k1, -1);
                k1 += 9;
            }
        }
    }
}

