/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay.hud;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.vladmarica.betterpingdisplay.BetterPingDisplayMod;
import com.vladmarica.betterpingdisplay.Config;
import com.vladmarica.betterpingdisplay.hud.PingColors;
import com.vladmarica.betterpingdisplay.hud.PlayerListHudUtil;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_640;

public final class CustomPlayerListHud {
    private static final Ordering<class_640> ENTRY_ORDERING = Ordering.from((Comparator)new EntryOrderComparator());
    private static final int PING_TEXT_RENDER_OFFSET = -13;
    private static final int PLAYER_SLOT_EXTRA_WIDTH = 45;
    private static final int PLAYER_ICON_WIDTH = 9;
    private static final int PING_BARS_WIDTH = 11;

    public static void render(class_355 hud, class_4587 stack, int width, class_269 scoreboard, class_266 obj) {
        int y;
        int var10004;
        int var10002;
        boolean displayPlayerIcons;
        int l;
        int n;
        class_310 mc = class_310.method_1551();
        class_327 textRenderer = mc.field_1772;
        class_2561 header = PlayerListHudUtil.getHeader(hud);
        class_2561 footer = PlayerListHudUtil.getFooter(hud);
        Config config = BetterPingDisplayMod.instance().getConfig();
        class_634 clientPlayNetworkHandler = mc.field_1724.field_3944;
        List playerList = ENTRY_ORDERING.sortedCopy((Iterable)clientPlayNetworkHandler.method_2880());
        int i = 0;
        int j = 0;
        for (class_640 playerListEntry : playerList) {
            n = mc.field_1772.method_27525((class_5348)hud.method_1918(playerListEntry));
            i = Math.max(i, n);
            if (obj == null || obj.method_1118() == class_274.class_275.field_1471) continue;
            n = textRenderer.method_1727(" " + scoreboard.method_1180(playerListEntry.method_2966().getName(), obj).method_1126());
            j = Math.max(j, n);
        }
        playerList = playerList.subList(0, Math.min(playerList.size(), 80));
        int m = l = playerList.size();
        n = 1;
        while (m > 20) {
            m = (l + ++n - 1) / n;
        }
        boolean bl = displayPlayerIcons = mc.method_1542() || mc.method_1562().method_2872().method_10771();
        int q = obj != null ? (obj.method_1118() == class_274.class_275.field_1471 ? 90 : j) : 0;
        int r = Math.min(n * ((displayPlayerIcons ? 9 : 0) + i + q + 13 + 45), width - 50) / n;
        int s = width / 2 - (r * n + (n - 1) * 5) / 2;
        int t = 10;
        int u = r * n + (n - 1) * 5;
        List headerLines = null;
        if (header != null) {
            headerLines = mc.field_1772.method_1728((class_5348)header, width - 50);
            for (class_5481 headerLine : headerLines) {
                u = Math.max(u, mc.field_1772.method_30880(headerLine));
            }
        }
        List footerLines = null;
        if (footer != null) {
            footerLines = mc.field_1772.method_1728((class_5348)footer, width - 50);
            for (class_5481 footerLine : footerLines) {
                u = Math.max(u, mc.field_1772.method_30880(footerLine));
            }
        }
        if (headerLines != null) {
            int var10000 = width / 2 - u / 2 - 1;
            int var10001 = t - 1;
            var10002 = width / 2 + u / 2 + 1;
            var10004 = headerLines.size();
            class_332.method_25294((class_4587)stack, (int)var10000, (int)var10001, (int)var10002, (int)(t + var10004 * 9), (int)Integer.MIN_VALUE);
            for (class_5481 headerLine : headerLines) {
                y = mc.field_1772.method_30880(headerLine);
                mc.field_1772.method_27517(stack, headerLine, (float)(width / 2 - y / 2), (float)t, -1);
                t += 9;
            }
            ++t;
        }
        class_332.method_25294((class_4587)stack, (int)(width / 2 - u / 2 - 1), (int)(t - 1), (int)(width / 2 + u / 2 + 1), (int)(t + m * 9), (int)Integer.MIN_VALUE);
        int w = mc.field_1690.method_19344(0x20FFFFFF);
        for (int x = 0; x < l; ++x) {
            int ag;
            int ah;
            y = x / m;
            int ai = x % m;
            int aa = s + y * r + y * 5;
            int ab = t + ai * 9;
            class_332.method_25294((class_4587)stack, (int)aa, (int)ab, (int)(aa + r), (int)(ab + 8), (int)w);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (x >= playerList.size()) continue;
            class_640 player = (class_640)playerList.get(x);
            GameProfile gameProfile = player.method_2966();
            if (displayPlayerIcons) {
                class_1657 playerEntity = mc.field_1687.method_18470(gameProfile.getId());
                boolean bl2 = playerEntity != null && playerEntity.method_7348(class_1664.field_7559) && ("Dinnerbone".equals(gameProfile.getName()) || "Grumm".equals(gameProfile.getName()));
                mc.method_1531().method_22813(player.method_2968());
                ah = 8 + (bl2 ? 8 : 0);
                int ad = 8 * (bl2 ? -1 : 1);
                class_332.method_25293((class_4587)stack, (int)aa, (int)ab, (int)8, (int)8, (float)8.0f, (float)ah, (int)8, (int)ad, (int)64, (int)64);
                if (playerEntity != null && playerEntity.method_7348(class_1664.field_7563)) {
                    int ae = 8 + (bl2 ? 8 : 0);
                    int af = 8 * (bl2 ? -1 : 1);
                    class_332.method_25293((class_4587)stack, (int)aa, (int)ab, (int)8, (int)8, (float)40.0f, (float)ae, (int)8, (int)af, (int)64, (int)64);
                }
                aa += 9;
            }
            class_2561 playerName = hud.method_1918(player);
            if (player.method_2958() == class_1934.field_9219) {
                mc.field_1772.method_30881(stack, playerName, (float)aa, (float)ab, -1862270977);
            } else {
                mc.field_1772.method_30881(stack, playerName, (float)aa, (float)ab, -1);
            }
            if (obj != null && player.method_2958() != class_1934.field_9219 && (ah = (ag = aa + i + 1) + q) - ag > 5) {
                PlayerListHudUtil.renderScoreboardObjective(hud, stack, obj, ab, gameProfile.getName(), ag, ah, player);
            }
            String pingString = String.format(config.getTextFormatString(), player.method_2959());
            int pingStringWidth = textRenderer.method_1727(pingString);
            int textX = r + aa - pingStringWidth + -13;
            if (displayPlayerIcons) {
                textX -= 9;
            }
            if (!config.shouldRenderPingBars()) {
                textX += 11;
            }
            int pingTextColor = config.shouldAutoColorPingText() ? PingColors.getColor(player.method_2959()) : config.getTextColor();
            textRenderer.method_1720(stack, pingString, (float)textX, (float)ab, pingTextColor);
            if (config.shouldRenderPingBars()) {
                PlayerListHudUtil.renderLatencyIcon(hud, stack, r, aa - (displayPlayerIcons ? 9 : 0), ab, player);
                continue;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (footerLines != null) {
            int var10000 = width / 2 - u / 2 - 1;
            int var10001 = (t += m * 9 + 1) - 1;
            var10002 = width / 2 + u / 2 + 1;
            var10004 = footerLines.size();
            class_332.method_25294((class_4587)stack, (int)var10000, (int)var10001, (int)var10002, (int)(t + var10004 * 9), (int)Integer.MIN_VALUE);
            for (class_5481 footerLine : footerLines) {
                int ai = textRenderer.method_30880(footerLine);
                textRenderer.method_27517(stack, footerLine, (float)(width / 2 - ai / 2), (float)t, -1);
                t += 9;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class EntryOrderComparator
    implements Comparator<class_640> {
        EntryOrderComparator() {
        }

        @Override
        public int compare(class_640 p1, class_640 p2) {
            class_268 team = p1.method_2955();
            class_268 team2 = p2.method_2955();
            return ComparisonChain.start().compareTrueFirst(p1.method_2958() != class_1934.field_9219, p2.method_2958() != class_1934.field_9219).compare((Comparable)((Object)(team != null ? team.method_1197() : "")), (Comparable)((Object)(team2 != null ? team2.method_1197() : ""))).compare((Object)p1.method_2966().getName(), (Object)p2.method_2966().getName(), String::compareToIgnoreCase).result();
        }
    }
}

