/*
 * Decompiled with CFR 0.152.
 */
package com.tome.bettershields;

import com.tome.bettershields.BetterShieldItem;
import com.tome.bettershields.Config;
import com.tome.bettershields.ShieldRecipes;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="bettershields")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterShields {
    public static final String MODID = "bettershields";
    public static BetterShieldItem ironShield;
    public static BetterShieldItem goldShield;
    public static BetterShieldItem diamondShield;

    public BetterShields() {
        new Config();
        ironShield = new BetterShieldItem("iron_shield", () -> (Integer)Config.ironDamageReduction.get(), (Tag<Item>)Tags.Items.INGOTS_IRON, (int)((Integer)Config.ironDurability.get()));
        goldShield = new BetterShieldItem("gold_shield", () -> (Integer)Config.goldDamageReduction.get(), (Tag<Item>)Tags.Items.INGOTS_GOLD, (int)((Integer)Config.goldDurability.get()));
        diamondShield = new BetterShieldItem("diamond_shield", () -> (Integer)Config.diamondDamageReduction.get(), (Tag<Item>)Tags.Items.GEMS_DIAMOND, (int)((Integer)Config.diamondDurability.get()));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{ironShield, goldShield, diamondShield});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register(ShieldRecipes.SERIALIZER.setRegistryName(new ResourceLocation(MODID, "shield_decoration")));
    }

    public static ITextComponent getBlockingTextComponent() {
        return new TranslationTextComponent("bettershields.shield_blocking", new Object[0]).func_211708_a(TextFormatting.GRAY);
    }

    public static ITextComponent getDamageReductionTextComponent(int reduction) {
        return new TranslationTextComponent("bettershields.shield_damage_reduction", new Object[]{reduction}).func_211708_a(TextFormatting.DARK_GREEN);
    }
}

