/*
 * Decompiled with CFR 0.152.
 */
package com.tome.bettershields.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredColorMaskTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShieldTextures {
    public static final Cache IRON_SHIELD_DESIGNS = new Cache("shield_", new ResourceLocation("bettershields", "textures/entity/iron_shield_base.png"), "textures/entity/shield/");
    public static final Cache GOLD_SHIELD_DESIGNS = new Cache("shield_", new ResourceLocation("bettershields", "textures/entity/gold_shield_base.png"), "textures/entity/shield/");
    public static final Cache DIAMOND_SHIELD_DESIGNS = new Cache("shield_", new ResourceLocation("bettershields", "textures/entity/diamond_shield_base.png"), "textures/entity/shield/");
    public static final ResourceLocation IRON_SHIELD_BASE_TEXTURE = new ResourceLocation("bettershields", "textures/entity/iron_shield_base_nopattern.png");
    public static final ResourceLocation GOLD_SHIELD_BASE_TEXTURE = new ResourceLocation("bettershields", "textures/entity/gold_shield_base_nopattern.png");
    public static final ResourceLocation DIAMOND_SHIELD_BASE_TEXTURE = new ResourceLocation("bettershields", "textures/entity/diamond_shield_base_nopattern.png");

    @OnlyIn(value=Dist.CLIENT)
    static class CacheEntry {
        public long lastUseMillis;
        public ResourceLocation textureLocation;

        private CacheEntry() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();
        private final ResourceLocation cacheResourceLocation;
        private final String cacheResourceBase;
        private final String cacheId;
        private final ResourceLocation baseTexture;

        public Cache(String id, ResourceLocation baseResource, String resourcePath) {
            this.cacheId = id;
            this.cacheResourceLocation = baseResource;
            this.cacheResourceBase = resourcePath;
            this.baseTexture = new ResourceLocation(baseResource.func_110624_b(), baseResource.func_110623_a().replaceAll(".png", "_nopattern.png"));
        }

        @Nullable
        public ResourceLocation getResourceLocation(String id, List<BannerPattern> patternList, List<DyeColor> colorList) {
            if (id.isEmpty()) {
                return null;
            }
            if (!patternList.isEmpty() && !colorList.isEmpty()) {
                id = this.cacheId + id;
                CacheEntry bannertextures$cacheentry = this.cacheMap.get(id);
                if (bannertextures$cacheentry == null) {
                    if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                        return this.baseTexture;
                    }
                    ArrayList list = Lists.newArrayList();
                    for (BannerPattern bannerpattern : patternList) {
                        list.add(this.cacheResourceBase + bannerpattern.func_190997_a() + ".png");
                    }
                    bannertextures$cacheentry = new CacheEntry();
                    bannertextures$cacheentry.textureLocation = new ResourceLocation(id);
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(bannertextures$cacheentry.textureLocation, (ITextureObject)new LayeredColorMaskTexture(this.cacheResourceLocation, (List)list, colorList));
                    this.cacheMap.put(id, bannertextures$cacheentry);
                }
                bannertextures$cacheentry.lastUseMillis = Util.func_211177_b();
                return bannertextures$cacheentry.textureLocation;
            }
            return MissingTextureSprite.func_195675_b();
        }

        private boolean freeCacheSlot() {
            long i = Util.func_211177_b();
            Iterator<String> iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                CacheEntry bannertextures$cacheentry = this.cacheMap.get(s);
                if (i - bannertextures$cacheentry.lastUseMillis <= 5000L) continue;
                Minecraft.func_71410_x().func_110434_K().func_147645_c(bannertextures$cacheentry.textureLocation);
                iterator.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }
}

